/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.cycling.LoadCommand;
import com.agfa.pacs.impaxee.hanging.AbstractStudyContainer;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.StudyType;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.IDisposable;
import com.tiani.base.data.IStudyData;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.CollectionUtils;

public class ImpaxEEStudyContainer
extends AbstractStudyContainer {
    private static final IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    private static final ALogger LOG = ALogger.getLogger(ImpaxEEStudyContainer.class);
    private IPatientRepresentation patient = null;
    private Prior[] priors = null;
    private String preferedHanging = null;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean isStudyAgeCheckEnabled = true;
    private static final DataManager DATA_MANAGER = DataManager.getInstance();

    public ImpaxEEStudyContainer(IStudyData iStudyData, String string, String string2) {
        super(string2);
        this.baseStudy = iStudyData;
        this.preferedHanging = string;
    }

    public IPatientRepresentation getPatientRepresentation() {
        return this.patient;
    }

    public void setPatientRepresentation(IPatientRepresentation iPatientRepresentation) {
        this.patient = iPatientRepresentation;
    }

    public void setPriors(List<IStudyInfo> list) {
        boolean bl = this.obtainWriteLock();
        try {
            this.priors = new Prior[list.size()];
            int n = 0;
            while (n < list.size()) {
                this.priors[n] = new Prior(list.get(n), null);
                ++n;
            }
        }
        finally {
            if (bl) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void setPriors(Map<IStudyInfo, IStudyData> map) {
        boolean bl = this.obtainWriteLock();
        try {
            this.priors = new Prior[map.size() - 1];
            int n = 0;
            for (Map.Entry<IStudyInfo, IStudyData> entry : map.entrySet()) {
                if (entry.getValue().getKey().equals(this.baseStudy.getKey())) continue;
                this.priors[n] = new Prior(entry.getKey(), entry.getValue());
                ++n;
            }
        }
        finally {
            if (bl) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void addPriorAndLoad(IStudyInfo iStudyInfo) {
        int n = this.addPrior(iStudyInfo);
        this.loadRelevantPrior(n, true);
    }

    private int addPrior(IStudyInfo iStudyInfo) {
        boolean bl = this.obtainWriteLock();
        try {
            if (this.priors == null) {
                this.priors = new Prior[1];
                this.priors[0] = new Prior(iStudyInfo, null);
                return 0;
            }
            int n = 0;
            while (n < this.priors.length) {
                if (this.priors[n].study.getStudyUID().equals(iStudyInfo.getStudyUID())) {
                    this.priors[n].unloaded = false;
                    int n2 = n;
                    return n2;
                }
                ++n;
            }
            this.priors = Arrays.copyOf(this.priors, this.priors.length + 1);
            this.priors[this.priors.length - 1] = new Prior(iStudyInfo, null);
            int n3 = this.priors.length - 1;
            return n3;
        }
        finally {
            if (bl) {
                this.lock.writeLock().unlock();
            }
        }
    }

    public boolean hasStudy(String string) {
        if (this.baseStudy.getKey().equals(string)) {
            return true;
        }
        if (this.priors != null) {
            Prior[] priorArray = this.priors;
            int n = this.priors.length;
            int n2 = 0;
            while (n2 < n) {
                Prior prior = priorArray[n2];
                if (prior != null && prior.study.getKey().equals(string)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public IStudyInfo getPriorInfo(int n) {
        return this.priors[n].study;
    }

    public int getRelevantPriorCount() {
        if (this.priors == null) {
            return 0;
        }
        return this.priors.length;
    }

    public int getLoadedPriorCount() {
        if (this.priors == null) {
            return 0;
        }
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            int n = 0;
            Prior[] priorArray = this.priors;
            int n2 = this.priors.length;
            int n3 = 0;
            while (n3 < n2) {
                Prior prior = priorArray[n3];
                if (prior.loaded != null) {
                    ++n;
                }
                ++n3;
            }
            int n4 = n;
            return n4;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isPriorLoaded(int n) {
        return this.priors[n].loaded != null;
    }

    public IStudyData loadRelevantPrior(int n) {
        return this.loadRelevantPrior(n, false);
    }

    private IStudyData loadRelevantPrior(int n, boolean bl) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            if (this.priors == null || this.priors.length < n + 1) {
                return null;
            }
            if (this.priors[n].loaded == null) {
                if (this.priors[n].unloaded) {
                    return null;
                }
                this.priors[n].loaded = this.loadStudy(this.priors[n].study, bl);
            }
            IStudyData iStudyData = this.priors[n].loaded;
            return iStudyData;
        }
        catch (NullPointerException nullPointerException) {
            LOG.info("Priors loaded during patient removal");
            return null;
        }
        finally {
            lock.unlock();
        }
    }

    public synchronized void reorderStudy(String string, int n) {
        boolean bl = this.obtainWriteLock();
        try {
            int n2 = -1;
            int n3 = 0;
            while (n3 < this.priors.length) {
                if (this.priors[n3].study.getKey().equals(string)) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 < 0 || n < 0 || n > this.priors.length - 1) {
                throw new IllegalArgumentException();
            }
            Prior prior = this.priors[n2];
            this.priors[n2] = this.priors[n];
            this.priors[n] = prior;
        }
        finally {
            if (bl) {
                this.lock.writeLock().unlock();
            }
        }
    }

    private IStudyData loadStudy(IStudyInfo iStudyInfo, boolean bl) {
        dicomCache.registerStudyUsage(iStudyInfo.getKey(), (IDisposable)iStudyInfo);
        PerformanceProfiler.getInstance().addStudyOpened(iStudyInfo, true);
        LoadCommand loadCommand = LoadCommand.createLoadCommandForPrior(iStudyInfo, bl);
        loadCommand.performAllSteps();
        List<IStudyData> list = loadCommand.getStudies();
        loadCommand.addToImageArea();
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }

    public int getIndexOfStudy(String string) {
        if (this.baseStudy.getKey().equals(string)) {
            return 0;
        }
        if (this.priors != null) {
            int n = 0;
            while (n < this.priors.length) {
                if (this.priors[n].study.getKey().equals(string)) {
                    return n + 1;
                }
                ++n;
            }
        }
        return -1;
    }

    public String getPreferredHangingID() {
        return this.preferedHanging;
    }

    public void cleanUp() {
        boolean bl = this.obtainWriteLock();
        try {
            this.priors = null;
            this.patient = null;
            super.cleanUp();
        }
        finally {
            if (bl) {
                this.lock.writeLock().unlock();
            }
        }
    }

    private boolean obtainWriteLock() {
        try {
            Lock lock = this.lock.writeLock();
            return lock.tryLock(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public synchronized void updateLoadedPriors(Set<String> set) {
        if (this.priors != null) {
            int n = 0;
            while (n < this.priors.length) {
                if (this.priors[n].loaded != null && !set.contains(this.priors[n].loaded.getKey())) {
                    this.priors[n].unloaded = true;
                    this.priors[n].loaded = null;
                }
                ++n;
            }
        }
    }

    public StudyType getStudyType(String string) {
        if (DATA_MANAGER.isStudyMerged(DATA_MANAGER.getStudy(string))) {
            return StudyType.MERGED;
        }
        return StudyType.getStudyType((int)this.getIndexOfStudy(string));
    }

    public boolean isStudyAgeCheckEnabled() {
        return this.isStudyAgeCheckEnabled;
    }

    public void disableStudyAgeCheck() {
        this.isStudyAgeCheckEnabled = false;
    }

    private static class Prior {
        public IStudyData loaded;
        public IStudyInfo study;
        private volatile boolean unloaded = false;

        public Prior(IStudyInfo iStudyInfo, IStudyData iStudyData) {
            this.loaded = iStudyData;
            this.study = iStudyInfo;
        }
    }
}

