/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.data.lw.datainfo.impl.RootInfo;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEFrameObjectData;
import com.agfa.pacs.impaxee.glue.data.RenderableDataInfo;
import com.tiani.base.data.IDataObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageInformation;
import com.tiani.base.data.ISeriesData;
import com.tiani.base.data.RawDataContainerTokenData;
import com.tiani.jvision.image.ImgView2;
import com.tiani.jvision.vis.VisData;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public class ImpaxEEVisObjectData
implements IDataObject {
    private VisData visData;
    private IFrameObjectData adapter;
    private boolean isSecondaryCapture = false;

    public ImpaxEEVisObjectData(VisData visData, boolean bl) {
        this.visData = visData;
        this.adapter = visData.getFrameData();
        this.isSecondaryCapture = bl;
    }

    public IDataObject getAdapter() {
        return this.adapter;
    }

    public VisData getVisData() {
        return this.visData;
    }

    public Attributes getDicomObject() {
        return this.adapter.getDicomObject();
    }

    public IDataInfo getQueryObject() {
        return this.adapter.getQueryObject();
    }

    public String getKey() {
        return this.adapter.getKey();
    }

    public ISeriesData getParent() {
        return this.adapter.getParent();
    }

    public void setDicomObject(Attributes attributes) {
        this.adapter.setDicomObject(attributes);
    }

    public String resolveString(int n) {
        return this.adapter.resolveString(n);
    }

    public Attributes resolveStringEnhanced(int[] nArray, int n) {
        return this.adapter.resolveStringEnhanced(nArray, n);
    }

    public String[] resolveStrings(int n) {
        return this.adapter.resolveStrings(n);
    }

    IObjectInfo createObjectInfo(boolean bl, Map<String, IDataInfo> map, Map<String, IDataInfo> map2, Map<String, IDataInfo> map3, Map<String, IDataInfo> map4) {
        IFrameObjectData iFrameObjectData = this.visData.getFrameData();
        if (!(iFrameObjectData instanceof ImpaxEEFrameObjectData)) {
            throw new IllegalArgumentException("Unknown type");
        }
        IObjectInfo iObjectInfo = ((ImpaxEEFrameObjectData)iFrameObjectData).getFullDataInfo();
        String string = String.valueOf(iObjectInfo.getKey()) + "_" + iFrameObjectData.getFrameNumber();
        if (map4.containsKey(string)) {
            iObjectInfo = null;
        } else {
            iObjectInfo = this.createObjectInfoImpl(iObjectInfo, bl, map, map2, map3);
            map3.get(iObjectInfo.getTreeParent().getKey()).addChild((IDataInfo)iObjectInfo);
            map4.put(iObjectInfo.getKey(), (IDataInfo)iObjectInfo);
        }
        return iObjectInfo;
    }

    private IObjectInfo createObjectInfoImpl(IObjectInfo iObjectInfo, boolean bl, Map<String, IDataInfo> map, Map<String, IDataInfo> map2, Map<String, IDataInfo> map3) {
        ImgView2 imgView2;
        RenderableDataInfo renderableDataInfo;
        String string;
        RootInfo rootInfo = new RootInfo("ROOT");
        if (!map3.containsKey(iObjectInfo.getTreeParent().getKey())) {
            string = iObjectInfo.getTreeParent().copy(true);
            map3.put(string.getKey(), (IDataInfo)string);
            if (!map2.containsKey(iObjectInfo.getTreeParent().getTreeParent().getKey())) {
                renderableDataInfo = iObjectInfo.getTreeParent().getTreeParent().copy(true);
                map2.put(renderableDataInfo.getKey(), (IDataInfo)renderableDataInfo);
                if (!map.containsKey(iObjectInfo.getTreeParent().getTreeParent().getTreeParent().getKey())) {
                    imgView2 = iObjectInfo.getTreeParent().getTreeParent().getTreeParent().copy(true);
                    map.put(imgView2.getKey(), (IDataInfo)imgView2);
                    rootInfo.addChild((IDataInfo)imgView2);
                }
                map.get(renderableDataInfo.getTreeParent().getKey()).addChild((IDataInfo)renderableDataInfo);
            }
            map2.get(string.getTreeParent().getKey()).addChild((IDataInfo)string);
        }
        if (UIDUtilities.isType((String)(string = iObjectInfo.getSOPClassUID()), (UIDType)UIDType.Video) || UIDUtilities.isType((String)string, (UIDType)UIDType.Waveform) || !bl && UIDUtilities.isType((String)string, (UIDType)UIDType.Composite)) {
            return iObjectInfo;
        }
        renderableDataInfo = new RenderableDataInfo(this.visData, iObjectInfo);
        if (this.isSecondaryCapture && this.visData.getView() instanceof ImgView2) {
            imgView2 = (ImgView2)this.visData.getView();
            RawDataContainerTokenData rawDataContainerTokenData = new RawDataContainerTokenData(this.adapter, imgView2.getRawDataContainer(), null);
            renderableDataInfo.setImage(rawDataContainerTokenData.recreateImage());
        }
        return renderableDataInfo;
    }

    public IImageInformation getImageInformation() {
        return this.adapter.getImageInformation();
    }

    public String getSOPClassUID() {
        return this.adapter.getSOPClassUID();
    }

    public String getSOPInstanceUID() {
        return this.adapter.getSOPInstanceUID();
    }

    public void restoreFromCache() {
    }

    public void storeToCache() {
    }

    public String getModality() {
        return this.adapter.getMainFrame().getModality();
    }

    public String getSeriesDescription() {
        return this.adapter.getMainFrame().getSeriesDescription();
    }
}

