/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.data;

import com.agfa.pacs.data.lw.datainfo.impl.ObjectInfo;
import com.agfa.pacs.data.shared.icon.IIconInfo;
import com.agfa.pacs.data.shared.icon.IIconProviderListener;
import com.agfa.pacs.data.shared.icon.IconException;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.impl.AbstractDataInfo;
import com.agfa.pacs.impaxee.cache.BufferedImageHolder;
import com.agfa.pacs.impaxee.cache.RGBBufferedImageHolder;
import com.agfa.pacs.impaxee.data.fetcher.IFetchable;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.dicomobjectrenderer.OrientationReader;
import com.agfa.pacs.impaxee.glue.dicomobjectrenderer.RendererEvaluableData;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.rendering.PresentationRenderContext;
import com.agfa.pacs.listtext.dicomobject.presentationstate.EmptyFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.renderer.IRenderableObject;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.gui.controls.hotregion.HotRegion;
import com.tiani.jvision.image.OutputDeviceMetric;
import com.tiani.jvision.image.View;
import com.tiani.jvision.image.fithandler.AreaFitHandler;
import com.tiani.jvision.image.fithandler.FullVisualFitHandler;
import com.tiani.jvision.image.fithandler.SpacingDef;
import com.tiani.jvision.image.fithandler.TrueSizeFitHandler;
import com.tiani.jvision.info.IImageState;
import com.tiani.jvision.info.IMutableImageState;
import com.tiani.jvision.overlay.Localizer;
import com.tiani.jvision.overlay.LocalizerHighlight;
import com.tiani.jvision.overlay.OrientationMapping;
import com.tiani.jvision.overlay.Overlay;
import com.tiani.jvision.overlay.OverlayBitmap;
import com.tiani.jvision.overlay.PresentationObject;
import com.tiani.jvision.overlay.RulerMapping;
import com.tiani.jvision.overlay.demographics.MappingFactory;
import com.tiani.jvision.overlay.demographics.QuadMapping;
import com.tiani.jvision.renderer.IRDCRenderer;
import com.tiani.jvision.renderer.IntermediateNode;
import com.tiani.jvision.renderer.Renderer;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisHRSet;
import com.tiani.util.expressions.EvaluationContext;
import com.tiani.util.expressions.IEvaluableData;
import com.tiani.util.expressions.IEvaluablePrivateData;
import com.tiani.util.expressions.IEvaluationContext;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;

public class RenderableDataInfo
extends ObjectInfo
implements IRenderableObject,
IIconInfo {
    private VisData visData;
    private Renderer renderer;
    private BufferedImage icon;
    private Boolean swapLR = Boolean.FALSE;
    private LocalizerHighlight localizerHighlight;

    public RenderableDataInfo(VisData visData, IObjectInfo iObjectInfo) {
        super(iObjectInfo.getTreeParent(), iObjectInfo.getAttributes(), iObjectInfo.getKey());
        this.setSource(iObjectInfo.getSource());
        this.setInstanceInfo(iObjectInfo.getInstanceInfo());
        this.visData = visData;
        this.renderer = visData.getView().getRenderer();
        this.icon = null;
        IFrameObjectData iFrameObjectData = visData.getFrameData();
        if (this.renderer == null) {
            do {
                DataManager.getInstance().getFetcher().fetchImmediatly((IFetchable)iFrameObjectData);
                this.renderer = visData.getView().getRenderer();
            } while (this.renderer == null);
        }
        this.key = String.valueOf(this.key) + "_" + iFrameObjectData.getFrameNumber();
    }

    public String getSOPInstanceUID() {
        return this.visData.getFrameData().getSOPInstanceUID();
    }

    public String getUID() {
        return this.visData.getFrameData().getSOPInstanceUID();
    }

    public IDataInfo copy(boolean bl) {
        RenderableDataInfo renderableDataInfo = new RenderableDataInfo(this.visData, (IObjectInfo)this);
        this.copyInternal((AbstractDataInfo)renderableDataInfo, bl);
        return renderableDataInfo;
    }

    public int getBitsPerPixel() {
        return this.visData.getView().getImageInformation().getHighBit() + 1;
    }

    public String getSOPClassUID() {
        return this.visData.getFrameData().getSOPClassUID();
    }

    public int getHeight() {
        return this.visData.getImageInformation().getRows();
    }

    public int getWidth() {
        return this.visData.getImageInformation().getColumns();
    }

    public boolean isRGB() {
        return this.visData.getImageInformation().getPhotometricInterpretation().isColor();
    }

    private Overlay prepareOverlay(Overlay overlay, PresentationRenderContext presentationRenderContext, RGBBufferedImageHolder rGBBufferedImageHolder, Dimension dimension, IMutableImageState iMutableImageState) {
        Object object;
        Overlay overlay2 = overlay;
        if (overlay instanceof OverlayBitmap && !presentationRenderContext.applyOverlays()) {
            return null;
        }
        if (overlay instanceof PresentationObject) {
            object = (PresentationObject)overlay;
            if (object.isROI() && !presentationRenderContext.applyGraphicAnnotations()) {
                return null;
            }
            if (object.isShutter() && !presentationRenderContext.applyShutter()) {
                return null;
            }
            overlay2 = object.cloneAll();
        }
        if (overlay instanceof QuadMapping) {
            return null;
        }
        if (overlay instanceof RulerMapping && dimension != null) {
            object = (RulerMapping)overlay.clone();
            overlay2 = object;
            object.setOwner((View)new DummyView(iMutableImageState));
            object.setMaxRulerLength(dimension.height / 15);
            object.setPositionL(this.swapLR == null ? false : this.swapLR == false);
        }
        if (overlay instanceof Localizer) {
            overlay2 = ((Localizer)overlay).clone();
            ((Localizer)overlay2).setPrinting(true);
            this.localizerHighlight = new LocalizerHighlight((Localizer)overlay2);
            ((Localizer)overlay2).setLocalizerHighlight(this.localizerHighlight);
        }
        if (overlay instanceof LocalizerHighlight) {
            overlay2 = this.localizerHighlight;
        }
        if (overlay instanceof OverlayBitmap || overlay instanceof OrientationMapping) {
            overlay2 = overlay.clone();
        }
        if (dimension != null) {
            object = new Rectangle(dimension.width, dimension.height);
            overlay2.setPrintFont((Graphics)rGBBufferedImageHolder.graphics, (Rectangle)object, presentationRenderContext.getDPI());
            overlay2.setSize(dimension.width, dimension.height, (IImageState)iMutableImageState);
        }
        return overlay2;
    }

    public void renderTo(PresentationRenderContext presentationRenderContext) {
        Object object;
        Object object22;
        Object object3;
        SpacingDef spacingDef;
        IRDCRenderer iRDCRenderer = null;
        RGBBufferedImageHolder rGBBufferedImageHolder = new RGBBufferedImageHolder(presentationRenderContext.getWidth(), presentationRenderContext.getHeight());
        Renderer renderer = this.renderer.clone();
        IMutableImageState iMutableImageState = renderer.getImageState();
        boolean bl = false;
        if (renderer instanceof IRDCRenderer) {
            iRDCRenderer = (IRDCRenderer)renderer;
            if (presentationRenderContext.shouldResetToFullSize()) {
                iRDCRenderer = iRDCRenderer.disableFreeRotation();
                renderer = (Renderer)iRDCRenderer;
            }
            if (iRDCRenderer.getActiveImageDef().getTransform().m00 < 0.0) {
                bl = true;
            }
            spacingDef = iRDCRenderer.getImageState().getCurrentSpacingDef();
            object3 = null;
            if (spacingDef.getSizeUnit().isMM()) {
                object3 = new double[]{spacingDef.getDataPixelSizeY(), spacingDef.getDataPixelSizeX()};
            }
            if (presentationRenderContext.getSizeMode() == PresentationSizeMode.TrueSize && object3 != null) {
                object22 = new TrueSizeFitHandler();
                object22.setOutputDevice(new OutputDeviceMetric(presentationRenderContext.getPixelSpacing()[0], presentationRenderContext.getPixelSpacing()[1]));
                iRDCRenderer.setAreaFitHandler((AreaFitHandler)object22);
                renderer.setGeometry(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height, rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.iline);
            } else if (presentationRenderContext.shouldResetToFullSize()) {
                object22 = new FullVisualFitHandler(OutputDeviceMetric.neutral);
                iRDCRenderer.setAreaFitHandler((AreaFitHandler)object22);
                iRDCRenderer.setGeometry(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height, rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.iline);
                iRDCRenderer.getAreaFitHandler().setViewportCenterAlignmentX(AreaFitHandler.ViewportCenterAlignmentX.CENTER);
                iRDCRenderer.getActiveImageDef().resetTransformedViewportCenter();
                iRDCRenderer.getAreaFitHandler().resetZoomFactor();
            } else {
                object22 = new FullVisualFitHandler(iRDCRenderer.getAreaFitHandler());
                object22.setOutputDevice(OutputDeviceMetric.neutral);
                iRDCRenderer.setAreaFitHandler((AreaFitHandler)object22);
                iRDCRenderer.setGeometry(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height, rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.iline);
            }
        }
        renderer.paint(rGBBufferedImageHolder, rGBBufferedImageHolder.width, rGBBufferedImageHolder.height, rGBBufferedImageHolder.iofs, rGBBufferedImageHolder.iline, false);
        renderer.invalidate();
        spacingDef = renderer.getImageState();
        spacingDef.updated();
        object3 = new Dimension(rGBBufferedImageHolder.width, rGBBufferedImageHolder.height);
        this.swapLR = OrientationReader.flipMappings(this.visData.getView().getFrameData().getDicomObject());
        if (bl && this.swapLR != null) {
            this.swapLR = this.swapLR == false;
        }
        for (Object object22 : this.visData.getView().getOverlays()) {
            object = this.prepareOverlay((Overlay)object22, presentationRenderContext, rGBBufferedImageHolder, (Dimension)object3, (IMutableImageState)spacingDef);
            if (object == null) continue;
            object.paint((BufferedImageHolder)rGBBufferedImageHolder);
        }
        if (presentationRenderContext.applyMapping()) {
            Object object4;
            object22 = null;
            try {
                object4 = renderer;
                if (!(object4 instanceof IRDCRenderer)) {
                    while (object4 instanceof IntermediateNode) {
                        object4 = (Renderer)((IntermediateNode)object4).getChildren().get(0);
                    }
                }
                object = new EvaluationContext((IEvaluableData)this.visData.getView().getFrameData(), (IEvaluablePrivateData)new RendererEvaluableData((IRDCRenderer)object4, presentationRenderContext));
                object22 = MappingFactory.getMapping((IEvaluationContext)object, (boolean)(this.swapLR == null ? false : this.swapLR));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (object22 != null) {
                object4 = object22.getSize();
                object = (AffineTransform)presentationRenderContext.getGraphics().getTransform().clone();
                if (presentationRenderContext.isDisplayedAreaMapping()) {
                    object22.setSize(presentationRenderContext.getWidth(), presentationRenderContext.getHeight(), null);
                } else {
                    presentationRenderContext.setWidth(presentationRenderContext.getGraphicsWidth());
                    presentationRenderContext.setHeight(presentationRenderContext.getGraphicsHeight());
                    object22.setSize(presentationRenderContext.getGraphicsWidth(), presentationRenderContext.getGraphicsHeight(), null);
                }
                object22.setPrintFont((Graphics)rGBBufferedImageHolder.graphics, new Rectangle(presentationRenderContext.getGraphicsWidth(), presentationRenderContext.getGraphicsHeight()), presentationRenderContext.getDPI());
                if (presentationRenderContext.isPreviewMode()) {
                    object22.setMinimumSize(1);
                }
                object22.paint((BufferedImageHolder)rGBBufferedImageHolder);
                object22.resetPrintFont();
                presentationRenderContext.getGraphics().setTransform((AffineTransform)object);
                object22.setSize(object4.width, object4.height, (IImageState)iMutableImageState);
                object22.resetMinimumSize();
            }
        }
        object22 = new ArrayList();
        if (this.visData.isLossy()) {
            object22.add(Vis2.ICON_JPEGLOSSY_ORIGINAL.getImage());
        }
        if (this.visData.isSecondaryCapture()) {
            object22.add(Vis2.ICON_SECONDARYCAPTURE_ORIGINAL.getImage());
        }
        if (presentationRenderContext.applyIndicators() && !object22.isEmpty()) {
            double d = 5.0;
            int n = 32;
            int n2 = 32;
            if (presentationRenderContext.getPixelSpacing() != null) {
                n = (int)(d / presentationRenderContext.getPixelSpacing()[0]);
                n2 = (int)(d / presentationRenderContext.getPixelSpacing()[1]);
            }
            int n3 = (presentationRenderContext.getGraphicsWidth() - object22.size() * n) / 2;
            int n4 = presentationRenderContext.getGraphicsHeight() - n2;
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                rGBBufferedImageHolder.graphics.drawImage(image, n3, n4, n, n2, null);
                n3 += n;
            }
        }
        presentationRenderContext.getGraphics().drawImage(rGBBufferedImageHolder.image, 0, 0, presentationRenderContext.getWidth(), presentationRenderContext.getHeight(), null);
        rGBBufferedImageHolder.release();
    }

    public void setPresentationState(IFramePresentationState iFramePresentationState) {
        if (this.renderer instanceof IRDCRenderer) {
            IRDCRenderer iRDCRenderer = (IRDCRenderer)this.renderer;
            if (iFramePresentationState == null && iRDCRenderer.getCurrentFramePresentationState() == null) {
                iFramePresentationState = new EmptyFramePresentationState();
            }
            if (iFramePresentationState != null) {
                iRDCRenderer.applyPresentationState(iFramePresentationState);
            }
        }
    }

    public BufferedImage getImage() throws IconException {
        if (this.icon == null) {
            this.icon = this.visData.getFrameData().getTokenData().getFinalImage();
        }
        return this.icon;
    }

    public BufferedImage getImageAsync(IIconProviderListener iIconProviderListener) throws IconException {
        return this.getImage();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.icon = bufferedImage;
    }

    public boolean isDefaultIcon() {
        return false;
    }

    public void release(BufferedImage bufferedImage) {
        bufferedImage.flush();
    }

    public int[] getContainedFrames() {
        return new int[]{this.visData.getFrameData().getFrameNumber()};
    }

    public boolean containsFrame(int n) {
        return n == this.visData.getFrameData().getFrameNumber();
    }

    public void screenToImage(double[] dArray, double[] dArray2) {
        throw new UnsupportedOperationException();
    }

    public void imageToScreen(double[] dArray, double[] dArray2) {
        throw new UnsupportedOperationException();
    }

    private static class DummyView
    extends View {
        private IMutableImageState imageState;

        public DummyView(IMutableImageState iMutableImageState) {
            this.imageState = iMutableImageState;
        }

        public void reset() {
        }

        public boolean isFunctional() {
            return false;
        }

        public IMutableImageState getImageState() {
            return this.imageState;
        }

        public String getVisualType() {
            return null;
        }

        public void onCanvasSizeChanged(boolean bl) {
        }

        public void paint(RGBBufferedImageHolder rGBBufferedImageHolder) {
        }

        public VisHRSet getHRSet(VisHRSet visHRSet, Vis2 vis2) {
            return null;
        }

        public void handleHotRegionPressed(HotRegion hotRegion, MouseEvent mouseEvent) {
        }

        public void handleHotRegionDragged(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2, int n3, int n4) {
        }

        public void handleHotRegionReleased(HotRegion hotRegion, MouseEvent mouseEvent, int n, int n2) {
        }
    }
}

