/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.datahandler;

import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.store.IStoreProvider;
import com.agfa.pacs.data.shared.store.StoreProviderFactory;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.impaxee.data.fetcher.IStore;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEDataObject;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEStudyData;
import com.agfa.pacs.impaxee.glue.datainfo.ImpaxEEInstanceInfo;
import com.agfa.pacs.impaxee.glue.datanode.ImpaxEEDataInfoNodeProvider;
import com.agfa.pacs.listtext.lta.util.DataInfoToAttributesTransformer;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IObjectData;
import com.tiani.base.data.IStudyData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.dcm4che3.data.Attributes;

public class DataStoreManager
implements IStore {
    private static final ALogger LOGGER = ALogger.getLogger(DataStoreManager.class);
    private static final int UID_CONCATENATION_ABORTION_LIMIT = 200;
    private static DataStoreManager instance = null;
    private IStoreProvider storeProvider = StoreProviderFactory.getInstance().getStoreProvider();

    private DataStoreManager() {
    }

    public void setStoreProvider(IStoreProvider iStoreProvider) {
        this.storeProvider = iStoreProvider;
    }

    public static synchronized DataStoreManager getInstance() {
        if (instance == null) {
            instance = new DataStoreManager();
        }
        return instance;
    }

    public Collection<IWorklistContext> getAvailableWorklistContexts() {
        return this.storeProvider.getAvailableWorklistContexts();
    }

    public IStoreHandler store(IObjectData iObjectData, IStudyData iStudyData, Collection<IWorklistContext> collection) {
        return this.store(Collections.singletonList(iObjectData), iStudyData, collection);
    }

    private static IObjectInfo createDataInfoWithUpdatedSource(IObjectData iObjectData) {
        Object object;
        ImpaxEEInstanceInfo impaxEEInstanceInfo = null;
        if (iObjectData instanceof ImpaxEEDataObject) {
            object = (ImpaxEEDataObject)iObjectData;
            impaxEEInstanceInfo = new ImpaxEEInstanceInfo((ImpaxEEDataObject)object);
        }
        if (CollectionUtils.isEmpty((Collection)(object = DataStoreManager.createDataInfo(iObjectData)))) {
            return null;
        }
        IObjectInfo iObjectInfo = (IObjectInfo)object.get(0);
        IInstanceInfo iInstanceInfo = iObjectInfo.getInstanceInfo();
        if (iInstanceInfo != null && !(iInstanceInfo instanceof ImpaxEEInstanceInfo)) {
            iObjectInfo.setInstanceInfo((IInstanceInfo)impaxEEInstanceInfo);
            iObjectInfo.setSource((IDataInfoSource)ImpaxEEDataInfoNodeProvider.getInstance());
        }
        return iObjectInfo;
    }

    public IStoreHandler store(Collection<IObjectData> collection, IStudyData iStudyData, Collection<IWorklistContext> collection2) {
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        for (IObjectData iObjectData : collection) {
            IObjectInfo iObjectInfo = DataStoreManager.createDataInfoWithUpdatedSource(iObjectData);
            if (iObjectInfo == null) continue;
            arrayList.add(iObjectInfo);
        }
        return this.storeDataInfos(arrayList, DataStoreManager.createStudyInfo(iStudyData), collection2);
    }

    public IStoreHandler storeDataInfos(Collection<IObjectInfo> collection, IStudyInfo iStudyInfo, Collection<IWorklistContext> collection2) {
        if (collection.isEmpty()) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            DataStoreManager.logStoreOperation(collection.size(), DataInfoToAttributesTransformer.iterator(collection));
        }
        return this.storeProvider.store(collection, iStudyInfo, collection2);
    }

    public boolean store(Attributes attributes, IStudyData iStudyData) {
        return this.store(DataStoreManager.findSource(iStudyData), attributes);
    }

    public boolean store(IDataInfoSource iDataInfoSource, Attributes ... attributesArray) {
        if (LOGGER.isDebugEnabled()) {
            DataStoreManager.logStoreOperation(attributesArray.length, (Iterator<Attributes>)IteratorUtils.arrayIterator((Object[])attributesArray));
        }
        return this.storeProvider.storeObjects(iDataInfoSource, attributesArray);
    }

    public boolean deleteInstances(List<IObjectInfo> list) {
        return this.storeProvider.deleteInstances(list);
    }

    private static List<IObjectInfo> createDataInfo(IObjectData iObjectData) {
        return DataInfoUtilities.getLevel(((ImpaxEEDataObject)iObjectData).getDataInfo(), IObjectInfo.class);
    }

    private static IDataInfoSource findSource(IStudyData iStudyData) {
        IStudyInfo iStudyInfo = DataStoreManager.createStudyInfo(iStudyData);
        if (iStudyInfo == null) {
            return null;
        }
        return iStudyInfo.getSource();
    }

    private static IStudyInfo createStudyInfo(IStudyData iStudyData) {
        if (iStudyData instanceof ImpaxEEStudyData) {
            return (IStudyInfo)((ImpaxEEStudyData)iStudyData).getDataInfo();
        }
        return null;
    }

    private static void logStoreOperation(int n, Iterator<Attributes> iterator) {
        if (n == 1) {
            LOGGER.debug("Storing data object: {}", (Object)iterator.next().getString(524312));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                int n2 = stringBuilder.length();
                if (n2 >= 200) {
                    stringBuilder.append(", ...");
                    break;
                }
                if (n2 != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(iterator.next().getString(524312));
            }
            LOGGER.debug("Storing {} data objects: {}", (Object)n, (Object)stringBuilder);
        }
    }
}

