/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.monitoring;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Dcm4cheUtils;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.glue.data.ImpaxEETokenData;
import com.agfa.pacs.impaxee.glue.monitoring.IModifiedSeries;
import com.agfa.pacs.impaxee.glue.monitoring.ModifiedSeriesState;
import com.agfa.pacs.impaxee.gui.DisplaySetLabelUtils;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.TokenData;
import com.tiani.base.data.TokenOwner;
import com.tiani.util.expressions.IEvaluableData;
import com.tiani.util.expressions.IEvaluablePrivateData;
import com.tiani.util.expressions.IEvaluationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import org.dcm4che3.data.Attributes;

class AdditionalSeries
implements IModifiedSeries {
    private static final ALogger LOGGER = ALogger.getLogger(AdditionalSeries.class);
    private final ISeriesInfo seriesInfo;

    private AdditionalSeries(ISeriesInfo iSeriesInfo) {
        this.seriesInfo = iSeriesInfo;
    }

    static List<AdditionalSeries> createList(List<IObjectInfo> list) {
        List list2 = DataInfoUtilities.getLevel(list, ISeriesInfo.class);
        ArrayList<AdditionalSeries> arrayList = new ArrayList<AdditionalSeries>(list2.size());
        for (ISeriesInfo iSeriesInfo : list2) {
            arrayList.add(new AdditionalSeries(iSeriesInfo));
        }
        Collections.sort(arrayList, new AdditionalSeriesComparator());
        return arrayList;
    }

    @Override
    public JComponent getIcon() {
        List list = DataInfoUtilities.getLevel((IDataInfo)this.seriesInfo, IObjectInfo.class);
        IObjectInfo iObjectInfo = Config.impaxee.jvision.SEQLABEL.UseFirstImagesForTokens.get() ? (IObjectInfo)list.get(0) : (IObjectInfo)list.get(list.size() / 2);
        return DisplaySetLabelUtils.getIcon((TokenOwner)new ObjectInfoTokenOwner(iObjectInfo), null, (DisplaySetLabelUtils.DisplaySetIconFlag[])new DisplaySetLabelUtils.DisplaySetIconFlag[0]);
    }

    @Override
    public Collection<ModifiedSeriesState> getStates() {
        return EnumSet.of(ModifiedSeriesState.ADDED);
    }

    @Override
    public String getDescription() {
        return DisplaySetLabelUtils.getLabel((IEvaluationContext)new SeriesEvaluationContext());
    }

    private static class AdditionalSeriesComparator
    implements Comparator<AdditionalSeries> {
        private AdditionalSeriesComparator() {
        }

        @Override
        public int compare(AdditionalSeries additionalSeries, AdditionalSeries additionalSeries2) {
            Date date;
            Date date2;
            String string;
            String string2 = additionalSeries.seriesInfo.getStudyUID();
            if (CompareUtils.equals((Object)string2, (Object)(string = additionalSeries2.seriesInfo.getStudyUID()))) {
                date2 = AdditionalSeriesComparator.getSeriesDateTime(additionalSeries.seriesInfo.getAttributes());
                date = AdditionalSeriesComparator.getSeriesDateTime(additionalSeries2.seriesInfo.getAttributes());
                string2 = additionalSeries.seriesInfo.getSeriesUID();
                string = additionalSeries2.seriesInfo.getSeriesUID();
            } else {
                date2 = DateTimeUtils.getStudyDateTime((Attributes)additionalSeries.seriesInfo.getStudy().getAttributes());
                date = DateTimeUtils.getStudyDateTime((Attributes)additionalSeries2.seriesInfo.getStudy().getAttributes());
            }
            int n = 0;
            if (date2 != null && date != null) {
                n = date.compareTo(date2);
            }
            if (n == 0) {
                n = CompareUtils.compareAdvanced((Comparable)((Object)string), (Comparable)((Object)string2));
            }
            return n;
        }

        private static Date getSeriesDateTime(Attributes attributes) {
            try {
                return attributes.getDate(2251941548130353L);
            }
            catch (Exception exception) {
                LOGGER.info("Parsing series date/time failed.", (Throwable)exception);
                return null;
            }
        }
    }

    private static class ObjectInfoTokenOwner
    implements TokenOwner {
        private final IObjectInfo objectInfo;

        ObjectInfoTokenOwner(IObjectInfo iObjectInfo) {
            this.objectInfo = iObjectInfo;
        }

        public TokenData getTokenData() {
            return new ImpaxEETokenData(this.objectInfo, 0);
        }
    }

    private class SeriesEvaluationContext
    implements IEvaluationContext,
    IEvaluableData {
        private SeriesEvaluationContext() {
        }

        public IEvaluableData getData() {
            return this;
        }

        public IEvaluablePrivateData getVisual() {
            return null;
        }

        public String resolveString(int n) {
            return AdditionalSeries.this.seriesInfo.getString(n);
        }

        public String[] resolveStrings(int n) {
            return AdditionalSeries.this.seriesInfo.getAttributes().getStrings(n);
        }

        public Attributes resolveStringEnhanced(int[] nArray, int n) {
            return Dcm4cheUtils.getNestedDataset((int[])nArray, (Attributes)AdditionalSeries.this.seriesInfo.getAttributes(), (boolean)false);
        }
    }
}

