/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.pix;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.pix.IPIXOptions;

public class ImpaxEEPIXOptions
implements IPIXOptions {
    private boolean usePIXProxy;
    private String proxyAddress;
    private int proxyPort;
    private String hostAddress;
    private int hostPort;
    private String hostApplication;
    private String hostFacility;
    private String homeApplication;
    private String homeFacility;
    private String universalID;
    private String targetDomain;
    private boolean useTLS;
    private boolean sendAuditLogForPIXQuery;
    private int connectionTimeout;
    private int requestTimeout;

    public ImpaxEEPIXOptions() {
        this.readConfiguration();
    }

    public boolean getUsePIXProxy() {
        return this.usePIXProxy;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public String getHostApplication() {
        return this.hostApplication;
    }

    public String getHostFacility() {
        return this.hostFacility;
    }

    public String getHomeApplication() {
        return this.homeApplication;
    }

    public String getHomeFacility() {
        return this.homeFacility;
    }

    public String getUniversalID() {
        return this.universalID;
    }

    public String getTargetDomain() {
        return this.targetDomain;
    }

    public boolean getUseTLS() {
        return this.useTLS;
    }

    public boolean getSendAuditLogForPIXQuery() {
        return this.sendAuditLogForPIXQuery;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    private void readConfiguration() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig();
        IConfigurationProvider iConfigurationProvider2 = iConfigurationProvider.getNode("listtext.lta.xdsi.pix");
        this.usePIXProxy = iConfigurationProvider2.getBoolean("usePIXProxy");
        this.proxyAddress = iConfigurationProvider2.getString("proxyAddress").trim();
        this.proxyPort = (int)iConfigurationProvider2.getLong("proxyPort");
        this.hostAddress = iConfigurationProvider2.getString("hostAddress").trim();
        this.hostPort = (int)iConfigurationProvider2.getLong("hostPort");
        this.hostApplication = iConfigurationProvider2.getString("hostApplication").trim();
        this.hostFacility = iConfigurationProvider2.getString("hostFacility").trim();
        this.homeApplication = iConfigurationProvider2.getString("homeApplication").trim();
        this.homeFacility = iConfigurationProvider2.getString("homeFacility").trim();
        this.universalID = ImpaxEEPIXOptions.toHL7Format(iConfigurationProvider2.getString("universalID").trim());
        this.targetDomain = iConfigurationProvider.getString("listtext.lta.xdsi.affinityDomain").trim();
        this.targetDomain = this.targetDomain.length() == 0 ? null : ImpaxEEPIXOptions.toHL7Format(this.targetDomain);
        this.useTLS = iConfigurationProvider2.getBoolean("useTLS");
        this.sendAuditLogForPIXQuery = iConfigurationProvider.getBoolean("listtext.lta.xdsi.audit.sendAuditLogForPIXQuery");
        this.connectionTimeout = (int)iConfigurationProvider.getLong("listtext.lta.xdsi.connectionTimeout");
        this.requestTimeout = (int)iConfigurationProvider.getLong("listtext.lta.xdsi.requestTimeout");
    }

    private static String toHL7Format(String string) {
        if (string.length() > 0) {
            boolean bl = string.charAt(0) == '&';
            boolean bl2 = false;
            if (string.length() >= 4) {
                bl2 = string.substring(string.length() - 4).equals("&ISO");
            }
            return String.valueOf(!bl ? "&" : "") + string + (!bl2 ? "&ISO" : "");
        }
        return "";
    }
}

