/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.retriever;

import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.hw.AbstractDicomRetriever;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataFramePixelDataInfo;
import com.agfa.pacs.impaxee.glue.data.ImpaxEEDataObject;
import com.agfa.pacs.impaxee.glue.datainfo.ImpaxEEInstanceInfo;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class ImpaxEEDicomRetriever
extends AbstractDicomRetriever {
    private static ALogger log = ALogger.getLogger(ImpaxEEDicomRetriever.class);

    protected void processImpl(IDicomDataRequest iDicomDataRequest) {
        IDicomDataRequest iDicomDataRequest2 = iDicomDataRequest;
        String string = iDicomDataRequest.getLoadableInfo().getUID();
        ImpaxEEInstanceInfo impaxEEInstanceInfo = (ImpaxEEInstanceInfo)iDicomDataRequest.getLoadableInfo().getInstanceInfo();
        Attributes attributes = new Attributes();
        ImpaxEEDataObject impaxEEDataObject = impaxEEInstanceInfo.getObjectData();
        attributes.addAll(impaxEEDataObject.getDicomObject());
        if (!attributes.containsValue(131088)) {
            attributes.setString(131088, VR.UI, "1.2.840.10008.1.2.1");
        }
        boolean bl = impaxEEDataObject instanceof IImageObjectData;
        iDicomDataRequest2.dicomDataAvailable(string, attributes, bl);
        if (bl) {
            IFrameObjectData[] iFrameObjectDataArray = ((IImageObjectData)impaxEEDataObject).frames();
            int n = iFrameObjectDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFrameObjectData iFrameObjectData = iFrameObjectDataArray[n2];
                try {
                    IPixelDataFrame iPixelDataFrame = iFrameObjectData.getRawDataContainer().getPixelDataFrame();
                    iDicomDataRequest2.pixelDataAvailable(string, (IPixelDataInfo)new PixelDataFramePixelDataInfo(iPixelDataFrame, attributes), iFrameObjectData.getFrameNumber());
                }
                catch (Exception exception) {
                    log.error("pixel data", (Throwable)exception);
                }
                ++n2;
            }
        }
        iDicomDataRequest2.dicomDataFinished(string, IDicomDataListener.Status.Success, null);
    }
}

