/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.script;

import com.agfa.pacs.impaxee.PerformanceProfiler;
import com.agfa.pacs.impaxee.glue.script.ImageAreaScriptUtil;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.WaitForImagesUtil;
import com.agfa.pacs.impaxee.hanging.impl.HangingCaseDisplay;
import com.agfa.pacs.listtext.lta.progress.IProgressStateManager;
import com.agfa.pacs.listtext.lta.progress.ProgressManagerFactory;
import com.agfa.pacs.listtext.lta.util.WaitingUtil;
import com.agfa.pacs.logging.ALogger;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.IDataSelectionListener;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.EventQueue;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AutoTestLatch {
    private static final ALogger log = ALogger.getLogger(AutoTestLatch.class);
    private static final AutoTestLatch INSTANCE = new AutoTestLatch();
    private HangingListener listener;

    private AutoTestLatch() {
    }

    public static AutoTestLatch getInstance() {
        return INSTANCE;
    }

    public void awaitBackgroundTasks(long l) {
        WaitingUtil.waitUntil((WaitingUtil.IWaitingHandler)WaitingUtil.IWaitingHandler.negate(() -> ((IProgressStateManager)ProgressManagerFactory.getManager()).hasRunningJobs()), (WaitingUtil.WaitingType)WaitingUtil.WaitingType.BACKGROUND_TASK, (long)l);
    }

    public void startHangingListener() {
        if (this.listener == null) {
            this.listener = new HangingListener();
            DataSelectionManager.getInstance().addListener((IDataSelectionListener)this.listener);
        }
    }

    public void stopHangingListener() {
        if (this.listener != null) {
            DataSelectionManager.getInstance().removeListener((IDataSelectionListener)this.listener);
            this.listener = null;
        }
    }

    public boolean awaitStudyLoad(String string, long l) {
        try {
            PerformanceProfiler.getInstance().awaitStudyLoad(string, l);
        }
        catch (InterruptedException interruptedException) {
            log.warn("Waiting for loaded study interrupted.", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        return WaitingUtil.waitUntil(() -> this.isStudyLoaded(string), (WaitingUtil.WaitingType)WaitingUtil.WaitingType.STUDY_LOAD, (long)l);
    }

    boolean isStudyLoaded(String string) {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation == null) {
            return false;
        }
        IStudyData iStudyData = iPatientRepresentation.getPatientData().getStudy(string);
        if (iStudyData == null) {
            return false;
        }
        return iStudyData.isStudyLoaded();
    }

    public void awaitCurrentAWTEvents(long l) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        EventQueue.invokeLater(countDownLatch::countDown);
        try {
            if (!countDownLatch.await(l, TimeUnit.MILLISECONDS)) {
                log.warn("Waiting for current AWT events timed out");
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean awaitPlugins(long l) {
        boolean bl = true;
        long l2 = System.currentTimeMillis();
        List list = JVision2.getMainFrame().getScreens();
        for (VisScreen2 visScreen2 : list) {
            List list2 = visScreen2.getDisplays();
            for (VisDisplay2 visDisplay2 : list2) {
                bl &= this.awaitPlugin(visDisplay2, WaitingUtil.getRemainingWaitingTime((long)l2, (long)l));
            }
        }
        return bl;
    }

    public boolean awaitPlugin(int n, long l) {
        return this.awaitPlugin((VisDisplay2)JVision2.getMainFrame().getDisplays().get(n), l);
    }

    private boolean awaitPlugin(VisDisplay2 visDisplay2, long l) {
        return WaitingUtil.waitUntil(() -> ImageAreaScriptUtil.isPluginReady(visDisplay2), (WaitingUtil.WaitingType)WaitingUtil.WaitingType.PLUGIN_INIT, (long)l);
    }

    public boolean awaitPatientHPEvaluation(long l) {
        return WaitingUtil.waitUntil(() -> {
            IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
            return iPatientRepresentation != null && !iPatientRepresentation.hasRunningHPEvaluation();
        }, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.HP_EVALUATION, (long)l);
    }

    public boolean awaitHPEvaluation(String string, long l) {
        if (string == null) {
            return true;
        }
        return WaitingUtil.waitUntil(() -> ImageAreaScriptUtil.findHanging(string) != null, (WaitingUtil.WaitingType)WaitingUtil.WaitingType.HP_EVALUATION, (long)l);
    }

    public boolean awaitHanging(String string, long l) {
        if (string == null) {
            return true;
        }
        long l2 = System.currentTimeMillis();
        HangingCaseDisplay.waitForHP((long)l);
        return WaitingUtil.waitUntil(() -> ImageAreaScriptUtil.isMatchingHanging(this.getActiveHanging(), string), (WaitingUtil.WaitingType)WaitingUtil.WaitingType.HANGING_APPLICATION, (long)WaitingUtil.getRemainingWaitingTime((long)l2, (long)l));
    }

    IHanging getActiveHanging() {
        if (this.listener == null) {
            return DataSelectionManager.getInstance().getActiveHanging();
        }
        return this.listener.getActiveHanging();
    }

    public void awaitImages(VisDisplay2 visDisplay2, long l) {
        WaitForImagesUtil.awaitImages((VisDisplay2)visDisplay2, (long)l);
    }

    public void awaitImages(long l) {
        WaitForImagesUtil.awaitImages((long)l);
    }

    public boolean awaitImage(int n, long l) {
        return WaitForImagesUtil.awaitImage((Vis2)ImageAreaScriptUtil.getActiveVisViewAt(n), (long)l);
    }

    private static class HangingListener
    extends DataSelectionListenerAdapter {
        private IHanging activeHanging = DataSelectionManager.getInstance().getActiveHanging();

        private HangingListener() {
        }

        public void newPatientSelected(DataSelectionManager dataSelectionManager, IPatientRepresentation iPatientRepresentation, IPatientRepresentation iPatientRepresentation2, IPatientRepresentation iPatientRepresentation3) {
            this.activeHanging = iPatientRepresentation2 == null ? null : iPatientRepresentation2.getActiveHanging();
        }

        public void newHangingCaseSelected(IPatientRepresentation iPatientRepresentation, IHanging iHanging, IHanging iHanging2, boolean bl) {
            this.activeHanging = iHanging2;
        }

        protected IHanging getActiveHanging() {
            return this.activeHanging;
        }
    }
}

