/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.script;

import com.agfa.integration.IScriptHelperCreator;
import com.agfa.integration.ObjectID;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.PAsynchronousAction;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.data.AbstractImageObjectData;
import com.agfa.pacs.impaxee.glue.script.AutoTestCapture;
import com.agfa.pacs.impaxee.glue.script.AutoTestLatch;
import com.agfa.pacs.impaxee.glue.script.ImageAreaScriptUtil;
import com.agfa.pacs.impaxee.glue.script.ScriptImage;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.IStudyContainer;
import com.agfa.pacs.impaxee.hanging.model.DisplayState;
import com.agfa.pacs.impaxee.hanging.model.IDisplayState;
import com.agfa.pacs.impaxee.hanging.model.enums.MainLayoutType;
import com.agfa.pacs.impaxee.hanging.model.enums.ThickMode;
import com.agfa.pacs.impaxee.plugin.IPlugin;
import com.agfa.pacs.impaxee.plugin.ManualPluginStarter;
import com.agfa.pacs.impaxee.plugin.PluginManager;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresets;
import com.agfa.pacs.impaxee.splitsort.model.ManualSplitAndSortPresetsType;
import com.agfa.pacs.impaxee.splitsort.model.xml.SplitAndSort;
import com.agfa.pacs.listtext.lta.deletion.DeletionUtils;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import com.agfa.pacs.tools.DoubleEquals;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IImageObjectData;
import com.tiani.base.data.IPatientData;
import com.tiani.base.data.IStudyData;
import com.tiani.base.data.Orientation;
import com.tiani.jvision.event.TEvent;
import com.tiani.jvision.event.TEventDispatch;
import com.tiani.jvision.event.ZoomParameter;
import com.tiani.jvision.image.WindowValue;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.main.MainFrame2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.toptoolbar.FilterActions;
import com.tiani.jvision.toptoolbar.PluginActions;
import com.tiani.jvision.vis.ActivationMode;
import com.tiani.jvision.vis.Vis2;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dcm4che3.data.Attributes;

public class ImageAreaScriptHelper
implements IScriptHelperCreator {
    private static final ALogger log = ALogger.getLogger(ImageAreaScriptHelper.class);

    public Object createHelper() {
        return this;
    }

    public ObjectID getSelectedStudy() {
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData == null) {
            return null;
        }
        IStudyData iStudyData = iFrameObjectData.getParent().getParent();
        IPatientData iPatientData = iStudyData.getParent();
        Attributes attributes = iStudyData.getDicomObject();
        Attributes attributes2 = iPatientData.getDicomObject();
        ObjectID objectID = ObjectID.forStudyUID((String)iStudyData.getStudyInstanceUID());
        objectID.setPatientID(attributes2.getString(0x100020));
        objectID.setIssuerOfPatientID(attributes2.getString(0x100021));
        objectID.setAccessionNr(attributes.getString(524368));
        objectID.setModalityInStudy(DicomUtils.getString((Attributes)attributes, (int)524385));
        return objectID;
    }

    public ObjectID getBaseStudy() {
        IStudyData iStudyData;
        ObjectID objectID = null;
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null && (iStudyData = iHanging.getStudyContainer().getBaseStudy()) != null) {
            objectID = ObjectID.forStudyUID((String)iStudyData.getStudyInstanceUID());
        }
        return objectID;
    }

    public ObjectID[] getPriorStudies() {
        ObjectID[] objectIDArray = new ObjectID[]{};
        IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
        if (iHanging != null) {
            IStudyContainer iStudyContainer = iHanging.getStudyContainer();
            int n = iStudyContainer.getRelevantPriorCount();
            objectIDArray = new ObjectID[n];
            int n2 = 0;
            while (n2 < n) {
                objectIDArray[n2] = ObjectID.forStudyUID((String)iStudyContainer.getPriorInfo(n2).getStudyUID());
                ++n2;
            }
        }
        return objectIDArray;
    }

    public String getSelectedSeries() {
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData == null) {
            return null;
        }
        return iFrameObjectData.getParent().getSeriesInstanceUID();
    }

    public IDicomNode getNodeOfSelectedData() {
        IDataProviderIdentifier iDataProviderIdentifier;
        IDataInfoSource iDataInfoSource;
        IImageObjectData iImageObjectData;
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData != null && (iImageObjectData = iFrameObjectData.getMainFrame()) instanceof AbstractImageObjectData && (iDataInfoSource = ((AbstractImageObjectData)iImageObjectData).getFullDataInfo().getSource()) != null && (iDataProviderIdentifier = iDataInfoSource.getIdentifier()) instanceof IDicomNode) {
            return (IDicomNode)iDataProviderIdentifier;
        }
        return null;
    }

    public String getDicomTagValue(int n) {
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData == null) {
            return null;
        }
        return iFrameObjectData.resolveString(n);
    }

    public String[] getDicomTagValues(int n) {
        IFrameObjectData iFrameObjectData = this.getSelectedData();
        if (iFrameObjectData == null) {
            return null;
        }
        return iFrameObjectData.resolveStrings(n);
    }

    public IFrameObjectData getSelectedData() {
        IDisplaySet iDisplaySet;
        VisDisplay2 visDisplay2 = JVision2.getMainFrame().getLastModifiedDisplay();
        if (visDisplay2 != null && (iDisplaySet = visDisplay2.getData().getDisplaySet()) != null) {
            return iDisplaySet.getOneObject();
        }
        return null;
    }

    public IFrameObjectData getCurrentImage() {
        VisData visData = VisData.getLastModified();
        if (visData != null) {
            return visData.getFrameData();
        }
        return null;
    }

    public ScriptImage getCurrentImage2() {
        VisData visData = VisData.getLastModified();
        if (visData == null) {
            return null;
        }
        return new ScriptImage(visData.getFrameData(), visData.getView());
    }

    public Attributes[] getSelectedImages(boolean bl) {
        VisDisplay2 visDisplay2 = JVision2.getMainFrame().getLastModifiedDisplay();
        if (visDisplay2 == null) {
            return null;
        }
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>(visDisplay2.getVisCount());
        for (VisData visData : visDisplay2.getVis()) {
            if (!visData.isSelected()) continue;
            Attributes attributes = visData.getFrameData().getDicomObject();
            if (bl) {
                attributes = new Attributes(attributes);
                visData.getFrameData().getRawDataContainer().storeToDicom(attributes);
            }
            arrayList.add(attributes);
        }
        return arrayList.toArray(new Attributes[arrayList.size()]);
    }

    public String getDisplaySetIdentifier(int n) {
        IDisplaySet iDisplaySet;
        VisDisplay2 visDisplay2 = (VisDisplay2)JVision2.getMainFrame().getDisplays().get(n);
        if (visDisplay2.hasData() && (iDisplaySet = visDisplay2.getData().getDisplaySet()) != null) {
            return this.getFirstSOPInstanceUID(iDisplaySet);
        }
        return null;
    }

    @Deprecated
    public void startHangingListener() {
        AutoTestLatch.getInstance().startHangingListener();
    }

    @Deprecated
    public void stopHangingListener() {
        AutoTestLatch.getInstance().stopHangingListener();
    }

    @Deprecated
    public boolean waitForLoadedStudy(String string, long l) {
        return AutoTestLatch.getInstance().awaitStudyLoad(string, l);
    }

    public boolean startPlugin(String string, long l) {
        this.performAction(this.getPluginActionID(string));
        if (AutoTestLatch.getInstance().awaitPlugin(this.getPositionOfLastModifiedDisplay(), l)) {
            return true;
        }
        this.performAction(this.getPluginActionID(null));
        return false;
    }

    public void startPlugin(String string, String string2, String string3, Double d) {
        DisplayState displayState = new DisplayState();
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            displayState.setPreferedOrientation(Orientation.valueOf((String)string2));
        }
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            displayState.setEMPRMode(ThickMode.valueOf((String)string3));
        }
        if (d != null && !DoubleEquals.equals((double)d, (double)0.0)) {
            displayState.setEMPRThickness(d);
        }
        IPlugin iPlugin = PluginManager.getPlugin((String)string);
        VisData visData = VisData.getLastModified();
        if (visData != null && iPlugin != null) {
            EventUtil.invoke(() -> ((ManualPluginStarter)new ManualPluginStarter(iPlugin, visData.getParent().getVisDisplay(), (IDisplayState)displayState)).start());
        }
    }

    private String getPluginActionID(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PluginActions.getPluginActionID((String)string));
        stringBuilder.append('@');
        stringBuilder.append(PDataScope.CurrentDisplay.name());
        return stringBuilder.toString();
    }

    private int getPositionOfLastModifiedDisplay() {
        VisDisplay2 visDisplay2 = JVision2.getMainFrame().getLastModifiedDisplay();
        if (visDisplay2 != null) {
            List list = JVision2.getMainFrame().getDisplays();
            int n = 0;
            while (n < list.size()) {
                if (visDisplay2.equals(list.get(n))) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    @Deprecated
    public void waitForAllInitializedPlugins(long l) {
        AutoTestLatch.getInstance().awaitPlugins(l);
    }

    @Deprecated
    public boolean waitForInitializedPlugin(int n, long l) {
        return AutoTestLatch.getInstance().awaitPlugin(n, l);
    }

    public boolean isPluginReady(int n) {
        return ImageAreaScriptUtil.isPluginReady((VisDisplay2)JVision2.getMainFrame().getDisplays().get(n));
    }

    @Deprecated
    public boolean waitForActiveHanging(String string, long l) {
        return AutoTestLatch.getInstance().awaitHanging(string, l);
    }

    @Deprecated
    public void waitForAllAvailableImages(long l) {
        AutoTestLatch.getInstance().awaitImages(l);
    }

    @Deprecated
    public boolean waitForAvailableImage(int n, long l) {
        return AutoTestLatch.getInstance().awaitImage(n, l);
    }

    @Deprecated
    public Iterable<BufferedImage> createAllImages() {
        return AutoTestCapture.getInstance().createAllImages();
    }

    @Deprecated
    public BufferedImage createImage(int n) {
        return AutoTestCapture.getInstance().createImage(n);
    }

    @Deprecated
    public BufferedImage createCombinedImage() {
        return AutoTestCapture.getInstance().createCombinedImage();
    }

    @Deprecated
    public BufferedImage createSeriesThumbnails(int n) {
        return AutoTestCapture.getInstance().createSeriesThumbnails(n);
    }

    @Deprecated
    public String exportImageAreaToXml() {
        return AutoTestCapture.getInstance().exportImageAreaToXml();
    }

    @Deprecated
    public String exportMainFrameToXml() {
        return AutoTestCapture.getInstance().exportMainFrameToXml();
    }

    @Deprecated
    public String exportLoadedDataToXml() {
        return AutoTestCapture.getInstance().exportLoadedDataToXml();
    }

    @Deprecated
    public String exportActiveHangingToXml() {
        return AutoTestCapture.getInstance().exportActiveHangingToXml();
    }

    public void setDisplayLayout(int n, int n2) {
        JVision2.getMainFrame().setLytMode(MainLayoutType.variable, n, n2, true);
    }

    public void resetImages() {
        this.sendEventToAll(66, null);
    }

    public HangingProtocolActivationState setActiveHanging(String string) {
        Pair<IPatientRepresentation, IHanging> pair = ImageAreaScriptUtil.findHanging(string);
        if (pair == null) {
            log.warn("Hanging '{}' not found among available hangings.", (Object)string);
            return HangingProtocolActivationState.NOT_FOUND;
        }
        if (DataSelectionManager.getInstance().setActiveHanging((IPatientRepresentation)pair.getLeft(), (IHanging)pair.getRight(), true, false)) {
            return HangingProtocolActivationState.SELECTED_BEING_APPLIED;
        }
        return HangingProtocolActivationState.APPLIED;
    }

    public boolean setActivePatient(String string) {
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(string);
        if (iPatientRepresentation == null) {
            log.warn("Patient not found: " + string);
            return false;
        }
        return DataSelectionManager.getInstance().setCurrentPatient(iPatientRepresentation);
    }

    public void activateManualSplitAndSortPreset(String string, String string2) {
        this.activateManualSplitAndSortPreset(ManualSplitAndSortPresetsType.FULL, string, null, string2);
    }

    public void activateManualSplitAndSortPreset(ManualSplitAndSortPresetsType manualSplitAndSortPresetsType, String string, String string2, String string3) {
        IDisplaySet iDisplaySet = this.findDisplaySet(string, string2);
        if (iDisplaySet != null) {
            SplitAndSort splitAndSort = new ManualSplitAndSortPresets(manualSplitAndSortPresetsType).loadPreset(string3);
            EventUtil.invokeSynchronous(() -> manualSplitAndSortPresetsType.applyManualSplitAndSort(iDisplaySet, splitAndSort));
        }
    }

    public void filterImages(String string) {
        this.performAction(PActionRegistry.getDataAction((String)FilterActions.getFilterActionID((FilterActions.FilterType)FilterActions.FilterType.valueOf((String)string)), (PDataScope)PDataScope.CurrentDisplay), 0L);
    }

    public void windowImages(int n, int n2) {
        this.windowImages(n, n2, false);
    }

    public void windowImages(double d, double d2) {
        this.windowImages(d, d2, true);
    }

    private void windowImages(double d, double d2, boolean bl) {
        this.sendEventToAll(63, new WindowValue(d, d2, bl));
    }

    public void windowCurrentDisplay(int n, int n2) {
        this.windowCurrentDisplay(63, n, n2);
    }

    private void windowCurrentDisplay(int n, double d, double d2) {
        this.sendEventToCurrentDisplay(n, new WindowValue(d, d2, false));
    }

    public void windowCurrentDisplaySUV(double d, double d2) {
        this.windowCurrentDisplay(61, d, d2);
    }

    public void showDisplaySet(int n, String string) {
        IDisplaySet iDisplaySet = this.findDisplaySet(null, string);
        if (iDisplaySet == null) {
            return;
        }
        VisDisplay2 visDisplay2 = (VisDisplay2)JVision2.getMainFrame().getDisplays().get(n);
        EventUtil.invokeSynchronous(() -> visDisplay2.initVisDisplay(iDisplaySet, null, true, ActivationMode.MANUAL));
    }

    public boolean deleteImage(String string, String string2) {
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        for (IStudyData iStudyData : DataManager.getInstance().getAllStudies()) {
            IFrameObjectData[] iFrameObjectDataArray;
            if (!Objects.equals(iStudyData.getStudyInstanceUID(), string) || (iFrameObjectDataArray = DataManager.getInstance().getFrameObjectData(string2, DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey()))) == null) continue;
            arrayList.add((IObjectInfo)iFrameObjectDataArray[0].getMainFrame().getQueryObject());
        }
        if (!arrayList.isEmpty()) {
            return DeletionUtils.deleteInstances(arrayList);
        }
        log.error("Requested image not found, no image deleted");
        return false;
    }

    public boolean selectDisplaySet(int n) {
        Vis2 vis2;
        List list = JVision2.getMainFrame().getDisplays();
        if (list != null && n >= 0 && n < list.size() && (vis2 = ((VisDisplay2)list.get(n)).getVisView(0)) != null) {
            EventUtil.invokeSynchronous(() -> {
                vis2.makeTheLastModified();
                vis2.repaint();
            });
            return true;
        }
        return false;
    }

    private IDisplaySet findDisplaySet(String string, String string2) {
        IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
        if (iPatientRepresentation == null) {
            log.warn("No display set found: No patient loaded.");
            return null;
        }
        IDisplaySet[] iDisplaySetArray = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray[n2];
            if (CompareUtils.equals((Object)string, (Object)iDisplaySet.getStudyUID()) || CompareUtils.equals((Object)this.getFirstSOPInstanceUID(iDisplaySet), (Object)string2)) {
                return iDisplaySet;
            }
            ++n2;
        }
        log.warn("No display set found for study instance UID {} and/or for SOP instance UID {}.", (Object)string, (Object)string2);
        return null;
    }

    private String getFirstSOPInstanceUID(IDisplaySet iDisplaySet) {
        IFrameObjectData[] iFrameObjectDataArray = iDisplaySet.getObjects();
        if (iFrameObjectDataArray != null && iFrameObjectDataArray.length > 0) {
            return iFrameObjectDataArray[0].getSOPInstanceUID();
        }
        return null;
    }

    public void removeAllDisplaySetsOfStudy(String string) {
        IStudyData iStudyData = DataManager.getInstance().getStudy(string);
        if (iStudyData == null) {
            log.warn("Study with UID " + string + " not found.");
            return;
        }
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(iStudyData.getParent().getKey());
        if (iPatientRepresentation == null) {
            log.warn("No patient for study with UID " + string + '.');
            return;
        }
        ArrayList<IDisplaySet> arrayList = new ArrayList<IDisplaySet>();
        IDisplaySet[] iDisplaySetArray = iPatientRepresentation.getDecompositionRuntime().getDisplaySets();
        int n = iDisplaySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDisplaySet iDisplaySet = iDisplaySetArray[n2];
            if (iStudyData.getKey().equals(iDisplaySet.getStudy().getKey())) {
                arrayList.add(iDisplaySet);
            }
            ++n2;
        }
        DataManager.getInstance().removeDisplaySet(arrayList.toArray(new IDisplaySet[arrayList.size()]), SplitAndSortChangeType.MANUAL_REMOVAL, true, false);
    }

    public void performAction(String string) {
        this.performAction(string, null, 0L);
    }

    public void performAction(String string, int n) {
        this.performAction(string, n, 0L);
    }

    public void performAction(String string, Integer n, long l) {
        PAction pAction = PActionRegistry.getAction((String)string);
        if (n != null) {
            pAction = pAction.getSubactions()[n];
        }
        this.performAction(pAction, l);
    }

    public boolean isActionSelected(String string) {
        try {
            PAction pAction = PActionRegistry.getAction((String)string);
            if (pAction != null && pAction.isSelectable()) {
                return pAction.isSelected();
            }
        }
        catch (Exception exception) {
            log.warn("Determining selection status for action '" + string + "' failed.", (Throwable)exception);
        }
        return false;
    }

    private void performAction(PAction pAction, long l) {
        if (pAction == null || !pAction.isAvailable() || !pAction.isEnabled()) {
            if (log.isDebugEnabled()) {
                if (pAction == null) {
                    log.debug("No action given.");
                } else if (!pAction.isAvailable()) {
                    log.debug("Action is unavailable: " + pAction.getID());
                } else {
                    log.debug("Action is disabled: " + pAction.getID());
                }
            }
            return;
        }
        try {
            if (l > 0L && pAction instanceof PAsynchronousAction) {
                CountDownLatch countDownLatch = new CountDownLatch(1);
                EventUtil.invokeSynchronous(() -> {
                    boolean bl = ((PAsynchronousAction)pAction).perform(null, countDownLatch::countDown);
                });
                if (!countDownLatch.await(l, TimeUnit.MILLISECONDS)) {
                    log.warn("Waiting for asynchronous action failed: " + pAction.getID());
                }
            } else {
                pAction.performSynchronouslyOnAWT(null);
            }
        }
        catch (Exception exception) {
            log.error("Unknown", (Throwable)exception);
        }
    }

    private void sendEventToAll(int n, Object object2) {
        this.sendEvent(n, object2, (tEvent, object) -> TEventDispatch.sendEvent((TEvent)tEvent, (Object)object, (int)20), () -> ((MainFrame2)JVision2.getMainFrame()).getAllVis());
    }

    private void sendEventToCurrentDisplay(int n, Object object) {
        this.sendEvent(n, object, TEventDispatch::sendEvent, this::getLastModifiedVis);
    }

    private void sendEvent(int n, Object object, BiConsumer<TEvent, Object> biConsumer, Supplier<Iterable<Vis2>> supplier) {
        try {
            EventUtil.invokeSynchronous(() -> {
                biConsumer.accept(new TEvent(n), object);
                for (Vis2 vis2 : (Iterable)supplier.get()) {
                    vis2.repaint();
                }
            });
        }
        catch (Exception exception) {
            log.error("Sending event failed", (Throwable)exception);
        }
    }

    Iterable<Vis2> getLastModifiedVis() {
        VisData visData = VisData.getLastModified();
        List list = visData == null ? Collections.emptyList() : visData.getParent().getVisDisplay().getVisViews();
        return list;
    }

    public void zoomImages(double d) {
        this.sendEventToAll(2, ZoomParameter.absolute((double)(1.0 / d)));
    }

    public void trueSizeZoom() {
        PActionRegistry.getDataAction((String)"ZOOM_TRUE_SIZE", (PDataScope)PDataScope.CurrentDisplay).performSynchronouslyOnAWT(null);
    }

    public void navigateTo4DRun(int n) {
        Vis2 vis2 = VisData.getLastModified().getVisual();
        if (vis2.hasData() && vis2.is4D()) {
            vis2.perform4DNavigation(n - 1, true);
        }
    }

    public static enum HangingProtocolActivationState {
        APPLIED,
        SELECTED_BEING_APPLIED,
        NOT_FOUND;

    }
}

