/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.glue.setaside;

import com.agfa.pacs.base.data.action.DataActionFactory;
import com.agfa.pacs.base.data.action.IDataAction;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.cycling.ImpaxEECycleListProvider;
import com.agfa.pacs.impaxee.glue.cycling.Messages;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.setaside.SetAsideLoadedDataState;
import com.agfa.pacs.impaxee.setaside.SetAsidePatientState;
import com.agfa.pacs.impaxee.setaside.SetAsideStudyState;
import com.agfa.pacs.listtext.cycling.LoadContext;
import com.agfa.pacs.listtext.lta.util.query.DataInfoQuery;
import com.agfa.pacs.listtext.lta.util.query.DataInfoQueryItem;
import com.agfa.pacs.listtext.lta.util.query.IDataInfoQueryItem;
import com.agfa.pacs.listtext.setaside.ISetAsideData;
import com.agfa.pacs.listtext.setaside.ISetAsideHandler;
import com.agfa.pacs.listtext.setaside.SetAsideState;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.util.message.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ImpaxEESetAsideLoadHandler
implements ISetAsideHandler {
    private static final ALogger log = ALogger.getLogger(ImpaxEESetAsideLoadHandler.class);

    public ISetAsideData createEmptyDataContainer() {
        return null;
    }

    public void updateState(SetAsideState setAsideState) throws Exception {
    }

    public void applyState(SetAsideState setAsideState) throws Exception {
        SetAsideLoadedDataState setAsideLoadedDataState = (SetAsideLoadedDataState)setAsideState.getCustomData(SetAsideLoadedDataState.class);
        this.prepareApply(setAsideLoadedDataState);
        ArrayList arrayList = new ArrayList(setAsideLoadedDataState.getLoadedPatients());
        Collections.sort(arrayList, new PatientComparator());
        boolean bl = true;
        for (SetAsidePatientState setAsidePatientState : arrayList) {
            try {
                try {
                    if (!this.loadPatient(setAsidePatientState, bl)) {
                        Message.warning((String)Messages.getString("SetAside.UnresolvedDataWarningDialog.Title"), (Object)Messages.getString("SetAside.UnresolvedDataWarningDialog.Message"));
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    log.error("Applying set-aside state: Loading patient " + setAsidePatientState.getKey() + " failed!", (Throwable)exception);
                    Message.error((String)Messages.getString("SetAside.LoadPatientErrorDialog.Title"), (Object)Messages.getString("SetAside.LoadPatientErrorDialog.Message"));
                    ImpaxEECycleListProvider.getInstance().syncTextArea();
                    continue;
                }
            }
            catch (Throwable throwable) {
                ImpaxEECycleListProvider.getInstance().syncTextArea();
                throw throwable;
            }
            ImpaxEECycleListProvider.getInstance().syncTextArea();
        }
        this.cleanupApply();
    }

    public boolean isReadyToUse() {
        return true;
    }

    private void prepareApply(SetAsideLoadedDataState setAsideLoadedDataState) throws Exception {
        IDicomCache iDicomCache = DicomCacheFactory.getInstance().getDicomCache();
        for (SetAsidePatientState setAsidePatientState : setAsideLoadedDataState.getLoadedPatients()) {
            for (SetAsideStudyState setAsideStudyState : setAsidePatientState.getStudies()) {
                String string;
                if (!setAsideStudyState.hasSession() || (string = setAsideStudyState.getSource()) != null && !"DICOMCACHE".equals(string)) continue;
                iDicomCache.putDataset(setAsideStudyState.getKey(), setAsideStudyState.getSessionUID(), setAsideStudyState.getSession());
                setAsideStudyState.setSource("DICOMCACHE");
            }
        }
        Config.impaxee.jvision.SEQPANEL.LoadOnlyOnePatient.set((boolean)setAsideLoadedDataState.isSinglePatientBrowsingEnabled());
        DataManager.getInstance().removeAllPatients(true, false);
        DataSelectionManager.getInstance().setCurrentPatient(null);
        JVision2.getMainFrame().clearAllDisplays();
    }

    private void cleanupApply() throws Exception {
    }

    private boolean loadPatient(SetAsidePatientState setAsidePatientState, boolean bl) throws Exception {
        QueryResult queryResult = this.queryBaseStudies(setAsidePatientState);
        QueryResult queryResult2 = this.querySessionStudies(setAsidePatientState);
        QueryResult queryResult3 = null;
        List<IStudyInfo> list = queryResult.getStudies();
        List<IStudyInfo> list2 = queryResult2.getStudies();
        boolean bl2 = false;
        if (CollectionUtils.isNotEmpty(list)) {
            log.info("Applying set-aside state: Loading " + list.size() + " base-studie(s) for " + setAsidePatientState.getKey());
            bl2 = true;
            ImpaxEECycleListProvider.getInstance().addToCycleList(list, false, new LoadContext().setPreferredHP(setAsidePatientState.getActiveHangingId()));
        }
        if (bl2) {
            log.info("Applying set-aside state: Attempting to query/load prior-studie(s) for " + setAsidePatientState.getKey());
            for (IStudyInfo iStudyInfo : list) {
                log.debug("Applying set-aside state: Querying  prior-studie(s) for base-study " + iStudyInfo.getKey());
                queryResult3 = this.queryPriorStudies(setAsidePatientState, iStudyInfo);
                List<IStudyInfo> list3 = queryResult3.getStudies();
                if (CollectionUtils.isNotEmpty((Collection)list3)) {
                    log.debug("Applying set-aside state: Loading " + list3.size() + " prior-studie(s) for base-study " + iStudyInfo.getKey());
                    ImpaxEECycleListProvider.getInstance().addToCycleListAsPrior(iStudyInfo, (List<? extends IDataInfo>)list3);
                    continue;
                }
                log.debug("Applying set-aside state: No prior study found for base-study " + iStudyInfo.getKey());
            }
        }
        IPatientRepresentation iPatientRepresentation = DataManager.getInstance().getPatientRepresentation(setAsidePatientState.getKey());
        if (bl) {
            if (list2 != null && !list2.isEmpty()) {
                log.info("Applying set-aside state: Loading " + list2.size() + " session(s) for " + setAsidePatientState.getKey());
                for (IDataInfo iDataInfo : list2) {
                    iDataInfo.getAttributes().setProperty("SET_ASIDE_STATUS", (Object)true);
                }
                IDataAction iDataAction = DataActionFactory.getInstance().getActionForCode("OPEN_ALL_IMAGES");
                iDataAction.perform(null, new ArrayList<IStudyInfo>(list2));
            }
            DataSelectionManager.getInstance().setCurrentPatient(iPatientRepresentation);
        }
        return !queryResult.hasUnresolvedItems() && !queryResult2.hasUnresolvedItems() && (queryResult3 == null || !queryResult3.hasUnresolvedItems());
    }

    private QueryResult querySessionStudies(SetAsidePatientState setAsidePatientState) throws Exception {
        ArrayList<IDataInfoQueryItem> arrayList = new ArrayList<IDataInfoQueryItem>();
        for (SetAsideStudyState setAsideStudyState : setAsidePatientState.getStudies()) {
            if (!setAsideStudyState.hasSession()) continue;
            arrayList.add(this.createQueryItem(setAsideStudyState));
        }
        return this.query(arrayList);
    }

    private QueryResult queryBaseStudies(SetAsidePatientState setAsidePatientState) throws Exception {
        ArrayList<IDataInfoQueryItem> arrayList = new ArrayList<IDataInfoQueryItem>();
        for (SetAsideStudyState setAsideStudyState : setAsidePatientState.getStudies()) {
            if (setAsideStudyState.hasSession() || setAsideStudyState.isPrior()) continue;
            arrayList.add(this.createQueryItem(setAsideStudyState));
        }
        return this.query(arrayList);
    }

    private QueryResult queryPriorStudies(SetAsidePatientState setAsidePatientState, IStudyInfo iStudyInfo) throws Exception {
        ArrayList<IDataInfoQueryItem> arrayList = new ArrayList<IDataInfoQueryItem>();
        for (SetAsideStudyState setAsideStudyState : setAsidePatientState.getStudies()) {
            if (setAsideStudyState.hasSession() || !setAsideStudyState.isPrior() || !setAsideStudyState.getBaseStudyKey().equals(iStudyInfo.getKey())) continue;
            arrayList.add(this.createQueryItem(setAsideStudyState));
        }
        return this.query(arrayList);
    }

    private IDataInfoQueryItem createQueryItem(SetAsideStudyState setAsideStudyState) {
        return new DataInfoQueryItem(Level.Study, setAsideStudyState.getKey(), setAsideStudyState.getSource());
    }

    private QueryResult query(Collection<IDataInfoQueryItem> collection) throws Exception {
        DataInfoQuery dataInfoQuery = new DataInfoQuery();
        dataInfoQuery.setQuery(collection);
        dataInfoQuery.startQuery(false);
        return new QueryResult(dataInfoQuery.getQueryResult(), dataInfoQuery.getUnresolvedQueryItems());
    }

    private static class PatientComparator
    implements Comparator<SetAsidePatientState> {
        private PatientComparator() {
        }

        @Override
        public int compare(SetAsidePatientState setAsidePatientState, SetAsidePatientState setAsidePatientState2) {
            if (setAsidePatientState.isCurrentPatient()) {
                return -1;
            }
            if (setAsidePatientState2.isCurrentPatient()) {
                return 1;
            }
            return -1;
        }
    }

    private static class QueryResult {
        private final Collection<IDataInfo> result;
        private final Collection<IDataInfoQueryItem> unresolved;

        public QueryResult(Collection<IDataInfo> collection, Collection<IDataInfoQueryItem> collection2) {
            this.result = collection;
            this.unresolved = collection2;
        }

        public List<IStudyInfo> getStudies() {
            return DataInfoUtilities.getLevel(this.result, (Level)Level.Study);
        }

        public boolean hasUnresolvedItems() {
            return this.unresolved != null && !this.unresolved.isEmpty();
        }
    }
}

