/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.notifier;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.notifier.IListener;
import com.agfa.pacs.notifier.INotifier;
import com.agfa.pacs.tools.ExceptionDialogUtils;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class Notifier<PAYLOAD>
implements INotifier<PAYLOAD> {
    private static final ALogger log = ALogger.getLogger(Notifier.class);
    private final Set<IListener<PAYLOAD>> listeners = new CopyOnWriteArraySet<IListener<PAYLOAD>>();

    @Override
    public void register(IListener<PAYLOAD> iListener) {
        this.listeners.add(iListener);
    }

    @Override
    public void unregister(IListener<PAYLOAD> iListener) {
        this.listeners.remove(iListener);
    }

    public void notifyListeners(PAYLOAD PAYLOAD) {
        for (IListener<PAYLOAD> iListener : this.listeners) {
            try {
                iListener.notifyListener(PAYLOAD);
            }
            catch (RuntimeException runtimeException) {
                log.error("Exception when notifying listener '" + iListener + "'", (Throwable)runtimeException);
                ExceptionDialogUtils.displayExceptionToUser(runtimeException);
            }
        }
    }
}

