/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.scope;

import com.agfa.pacs.scope.IDisposableScopedObject;
import com.agfa.pacs.scope.IScope;
import com.agfa.pacs.scope.IScopedObject;
import com.agfa.pacs.scope.ScopeDisposedException;
import com.agfa.pacs.scope.ScopedObjectFactory;
import com.agfa.pacs.tools.SafeExecutor;
import com.agfa.pacs.tools.concurrent.IUsageSynchronizer;
import com.agfa.pacs.tools.concurrent.UsageDisposeSynchronizer;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Scope<S extends IScope<S>>
implements IScope<S> {
    private final UsageDisposeSynchronizer usageSynchronizer = new UsageDisposeSynchronizer();
    private final Map<ScopedObjectFactory<?, S>, IScopedObject<S>> scopedObjects = new ConcurrentHashMap();
    private final Map<ScopedObjectFactory<?, S>, IScopedObject<S>> disposableScopedObjects = new ConcurrentHashMap();

    @Override
    public <T extends IScopedObject<S>> T provideScopedObject(S s, ScopedObjectFactory<T, S> scopedObjectFactory) throws ScopeDisposedException {
        Objects.requireNonNull(s);
        Objects.requireNonNull(scopedObjectFactory);
        boolean bl = this.isDisposableScopedObject(scopedObjectFactory);
        if (bl && !this.usageSynchronizer.requestUsagePermit()) {
            throw new ScopeDisposedException((IScope<?>)s);
        }
        try {
            Map<ScopedObjectFactory<?, S>, IScopedObject<S>> map = bl ? this.disposableScopedObjects : this.scopedObjects;
            T t = Scope.getOrCreateScopedObject(s, scopedObjectFactory, map);
            return t;
        }
        finally {
            if (bl) {
                this.usageSynchronizer.releaseUsagePermit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S extends IScope<S>, T extends IScopedObject<S>> T getOrCreateScopedObject(S s, ScopedObjectFactory<T, S> scopedObjectFactory, Map<ScopedObjectFactory<?, S>, IScopedObject<S>> map) {
        IScopedObject<Object> iScopedObject = map.get(scopedObjectFactory);
        if (iScopedObject == null) {
            Map<ScopedObjectFactory<?, S>, IScopedObject<S>> map2 = map;
            synchronized (map2) {
                iScopedObject = map.get(scopedObjectFactory);
                if (iScopedObject == null) {
                    iScopedObject = scopedObjectFactory.create(s);
                    map.put(scopedObjectFactory, iScopedObject);
                }
            }
        }
        return (T)iScopedObject;
    }

    private <T extends IScopedObject<S>> boolean isDisposableScopedObject(ScopedObjectFactory<T, S> scopedObjectFactory) {
        return IDisposableScopedObject.class.isAssignableFrom(this.getScopedObjectTypeParameter(scopedObjectFactory));
    }

    private <T extends IScopedObject<S>> Class<?> getScopedObjectTypeParameter(ScopedObjectFactory<T, S> scopedObjectFactory) {
        Class clazz = (Class)((ParameterizedType)scopedObjectFactory.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (!IScopedObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Unexpected type parameter " + clazz);
        }
        return clazz;
    }

    @Override
    public IUsageSynchronizer getUsageSynchronizer() {
        return this.usageSynchronizer;
    }

    @Override
    public final void dispose() {
        if (!this.usageSynchronizer.requestDisposePermit()) {
            return;
        }
        for (IScopedObject<S> iScopedObject : this.disposableScopedObjects.values()) {
            IDisposableScopedObject iDisposableScopedObject = (IDisposableScopedObject)iScopedObject;
            SafeExecutor.getInstance().execute(iDisposableScopedObject::dispose);
        }
        this.disposableScopedObjects.clear();
        this.disposeScope();
    }

    protected void disposeScope() {
    }
}

