/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.services;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class AsyncTaskThreadPool
implements Executor {
    private static final AsyncTaskThreadPool instance = new AsyncTaskThreadPool();
    private final AtomicLong threadCount = new AtomicLong(1L);
    private final AtomicLong runningTaskCount = new AtomicLong(0L);
    private final ThreadPoolExecutor threadPool;
    private final ThreadPoolExecutor threadPoolUnchecked;

    public static AsyncTaskThreadPool getInstance() {
        return instance;
    }

    private AsyncTaskThreadPool() {
        ThreadFactory threadFactory = runnable -> {
            Thread thread = new Thread(runnable, "Async Task " + this.threadCount.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        };
        this.threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        this.threadPoolUnchecked = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    @Override
    public void execute(Runnable runnable) {
        this.runningTaskCount.incrementAndGet();
        this.threadPool.execute(() -> {
            try {
                runnable.run();
            }
            finally {
                this.runningTaskCount.decrementAndGet();
            }
        });
    }

    public <T> Future<T> submit(Callable<T> callable) {
        this.runningTaskCount.incrementAndGet();
        return this.threadPool.submit(() -> {
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                this.runningTaskCount.decrementAndGet();
            }
        });
    }

    public void executeUnchecked(Runnable runnable) {
        this.threadPoolUnchecked.execute(runnable);
    }

    public boolean isIdle() {
        return this.runningTaskCount.get() == 0L;
    }
}

