/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.ExceptionDialogUtils;
import java.util.concurrent.Executor;

public class SafeExecutor
implements Executor {
    private static final ALogger log = ALogger.getLogger(SafeExecutor.class);
    private static final SafeExecutor INSTANCE = new SafeExecutor();

    public static SafeExecutor getInstance() {
        return INSTANCE;
    }

    @Override
    public void execute(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            log.error("Ignoring exception in SafeExecutor", throwable);
            ExceptionDialogUtils.displayExceptionToUser(throwable);
        }
    }
}

