/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class CopyOnWriteListStore<E> {
    private volatile List<E> list = Collections.emptyList();

    public List<E> get() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(Consumer<List<E>> consumer) {
        CopyOnWriteListStore copyOnWriteListStore = this;
        synchronized (copyOnWriteListStore) {
            List<E> list = this.getModifiableCopy();
            consumer.accept(list);
            this.set(list);
        }
    }

    public List<E> getModifiableCopy() {
        return new ArrayList<E>(this.list);
    }

    public void set(List<E> list) {
        this.list = list == null || list == Collections.emptyList() ? Collections.emptyList() : Collections.unmodifiableList(list);
    }
}

