/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ImmutableListProvider<E> {
    @GuardedBy(value="this")
    private final List<E> internalWritableList;
    private volatile List<E> listSnapshot = Collections.emptyList();
    @GuardedBy(value="this")
    private volatile long writeTicket = 0L;
    @GuardedBy(value="this")
    private volatile long snapshotTicket = 0L;

    public ImmutableListProvider() {
        this.internalWritableList = new ArrayList();
    }

    public ImmutableListProvider(int n) {
        this.internalWritableList = new ArrayList(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> get() {
        if (this.snapshotTicket != this.writeTicket) {
            ImmutableListProvider immutableListProvider = this;
            synchronized (immutableListProvider) {
                if (this.snapshotTicket != this.writeTicket) {
                    this.listSnapshot = Collections.unmodifiableList(new ArrayList<E>(this.internalWritableList));
                    this.snapshotTicket = this.writeTicket;
                }
            }
        }
        return this.listSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(Consumer<List<E>> consumer) {
        ImmutableListProvider immutableListProvider = this;
        synchronized (immutableListProvider) {
            try {
                consumer.accept(this.internalWritableList);
            }
            finally {
                ++this.writeTicket;
            }
        }
    }
}

