/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools.concurrent;

import com.agfa.pacs.tools.DisposedException;
import com.agfa.pacs.tools.ThrowingRunnable;
import com.agfa.pacs.tools.TypedCallable;
import com.agfa.pacs.tools.concurrent.IUsageSynchronizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class UsageDisposeSynchronizer
implements IUsageSynchronizer {
    private static final int DISPOSED_COUNT = Integer.MIN_VALUE;
    private final AtomicInteger usagePermitCounter = new AtomicInteger(0);
    private final AtomicBoolean disposing = new AtomicBoolean(false);

    @Override
    public <V, E extends Exception> V use(TypedCallable<V, E> typedCallable) throws E, DisposedException {
        if (this.requestUsagePermit()) {
            try {
                V v = typedCallable.call();
                return v;
            }
            finally {
                this.releaseUsagePermit();
            }
        }
        throw new DisposedException();
    }

    @Override
    public <E extends Exception> void use(ThrowingRunnable<E> throwingRunnable) throws E, DisposedException {
        if (this.requestUsagePermit()) {
            try {
                throwingRunnable.run();
            }
            finally {
                this.releaseUsagePermit();
            }
        } else {
            throw new DisposedException();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean requestUsagePermit() {
        var1_1 = this.usagePermitCounter.get();
        if (var1_1 >= 0) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            var1_1 = this.usagePermitCounter.get();
            if (var1_1 >= 0) continue;
            return false;
lbl7:
            // 2 sources

            ** while (!this.usagePermitCounter.compareAndSet((int)var1_1, (int)(var1_1 + 1)))
        }
lbl8:
        // 1 sources

        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseUsagePermit() {
        int n = this.usagePermitCounter.decrementAndGet();
        if (n == 0 && this.disposing.get()) {
            UsageDisposeSynchronizer usageDisposeSynchronizer = this;
            synchronized (usageDisposeSynchronizer) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean requestDisposePermit() {
        if (!this.disposing.compareAndSet(false, true)) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        block5: while (!bl2 && !this.usagePermitCounter.compareAndSet(0, Integer.MIN_VALUE)) {
            UsageDisposeSynchronizer usageDisposeSynchronizer = this;
            synchronized (usageDisposeSynchronizer) {
                while (true) {
                    while (true) {
                        if (this.usagePermitCounter.compareAndSet(0, Integer.MIN_VALUE)) {
                            bl2 = true;
                            continue block5;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    @Override
    public boolean isDisposeRequested() {
        return this.disposing.get();
    }
}

