/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.jna.wintools;

import com.agfa.pacs.logging.ALogger;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;

public class TouchUtils {
    private static final ALogger log = ALogger.getLogger(TouchUtils.class);
    public static final int SM_MAXIMUMTOUCHES = 95;
    private static Boolean supportsTouchInput;

    public static synchronized boolean supportsTouchInput() {
        if (supportsTouchInput == null) {
            String string = System.getProperty("disableTouchSupport");
            if (string != null && Boolean.parseBoolean(string)) {
                supportsTouchInput = false;
                return supportsTouchInput;
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                User32 user32 = (User32)Native.loadLibrary((String)"user32", User32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                int n = user32.GetSystemMetrics(95);
                log.debug("Device supports {} simultaneous touches", (Object)n);
                supportsTouchInput = n > 1;
            } else {
                supportsTouchInput = Boolean.FALSE;
            }
        }
        return supportsTouchInput;
    }
}

