/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.jna.wintools;

import com.agfa.pacs.jna.wintools.IWinToolsComposition;
import com.agfa.pacs.jna.wintools.IWinToolsDPI;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

public class WindowsTools {
    private static final double VERSION_VISTA = 6.0;
    private static final double VERSION_WINDOWS_7 = 6.1;
    private static final double VERSION_WINDOWS_81 = 6.3;
    public static final int PROCESS_DPI_UNAWARE = 0;
    public static final int PROCESS_SYSTEM_DPI_AWARE = 1;
    public static final int PROCESS_PER_MONITOR_DPI_AWARE = 2;
    private static WindowsTools instance;
    private double osVersion = this.getOSVersion();
    private boolean isLinux = this.isLinux();

    private WindowsTools() {
    }

    public static synchronized WindowsTools getInstance() {
        if (instance == null) {
            instance = new WindowsTools();
        }
        return instance;
    }

    @SuppressWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="can be ignored because osVersion is not a real double (version number)")
    public int enableComposition(boolean bl) {
        if (!(this.isLinux || this.osVersion != 6.0 && this.osVersion != 6.1)) {
            return IWinToolsComposition.INSTANCE.DwmEnableComposition(bl ? 1 : 0);
        }
        return -1;
    }

    public void setPerMonitorDPIAwareness() {
        this.setDPIAwareness(2);
    }

    public int setDPIAwareness(int n) {
        if (!this.isLinux && this.osVersion >= 6.3) {
            return IWinToolsDPI.INSTANCE.SetProcessDpiAwareness(n);
        }
        return -1;
    }

    private double getOSVersion() {
        try {
            return Double.parseDouble(System.getProperty("os.version"));
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    private boolean isLinux() {
        try {
            return System.getProperty("os.name").equalsIgnoreCase("linux");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

