/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.osgi.logging;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationXMLHandler
extends DefaultHandler {
    private StringBuilder text;
    private Map<String, String> configuration = new HashMap<String, String>();
    private Map<String, String> instrumentation = new HashMap<String, String>();
    private Map<String, String> escalation = new HashMap<String, String>();
    private Map<String, String> current;
    private String id;

    public ConfigurationXMLHandler(File file) throws SAXException, IOException, ParserConfigurationException {
        if (file.exists()) {
            SAXParserFactory.newInstance().newSAXParser().parse(file, (DefaultHandler)this);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.text != null) {
            this.text.append(cArray, n, n2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.current != null) {
            this.current.put(this.id, this.text.toString());
            this.text = null;
            this.current = null;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("configuration")) {
            this.text = new StringBuilder();
            this.current = this.configuration;
            this.id = attributes.getValue("id");
        } else if (string3.equals("escalation")) {
            this.text = new StringBuilder();
            this.current = this.escalation;
            this.id = attributes.getValue("id");
        } else if (string3.equals("instrumentation")) {
            this.text = new StringBuilder();
            this.current = this.instrumentation;
            this.id = attributes.getValue("id");
        }
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> map) {
        this.configuration = map;
    }

    public Map<String, String> getInstrumentation() {
        return this.instrumentation;
    }

    public void setInstrumentation(Map<String, String> map) {
        this.instrumentation = map;
    }

    public Map<String, String> getEscalation() {
        return this.escalation;
    }

    public void setEscalation(Map<String, String> map) {
        this.escalation = map;
    }
}

