/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import java.util.ArrayList;

public class AnonymousItemStack {
    private static final ALogger LOGGER = ALogger.getLogger(AnonymousItemStack.class);
    private ArrayList<CacheItem> stack = new ArrayList();
    private final GlobalLRU globalLRU;

    public AnonymousItemStack(GlobalLRU globalLRU) {
        this.globalLRU = globalLRU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object popNonEmpty() {
        Object object;
        if (this.stack.isEmpty()) {
            return null;
        }
        AnonymousItemStack anonymousItemStack = this;
        synchronized (anonymousItemStack) {
            block6: {
                if (!this.stack.isEmpty()) break block6;
                return null;
            }
            do {
                CacheItem cacheItem = this.stack.remove(this.stack.size() - 1);
                object = cacheItem.claimItemSynced();
                this.globalLRU.removeAnonymousSynced(cacheItem);
            } while (object == null && !this.stack.isEmpty());
            this.notify();
        }
        return object;
    }

    public synchronized void pushSynced(CacheItem cacheItem) {
        this.stack.add(cacheItem);
    }

    public synchronized void dumpContent(boolean bl) {
        LOGGER.info("size:" + this.stack.size());
        if (bl) {
            for (CacheItem cacheItem : this.stack) {
                LOGGER.info("{}", (Object)cacheItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEmpty() {
        if (this.stack.isEmpty()) {
            return true;
        }
        AnonymousItemStack anonymousItemStack = this;
        synchronized (anonymousItemStack) {
            if (this.stack.isEmpty()) {
                return true;
            }
            do {
                CacheItem cacheItem;
                if ((cacheItem = this.stack.get(this.stack.size() - 1)).getItemUnsynced() != null) {
                    return false;
                }
                this.stack.remove(this.stack.size() - 1);
                this.globalLRU.removeAnonymousSynced(cacheItem);
            } while (!this.stack.isEmpty());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CacheItem cacheItem) {
        if (this.stack.isEmpty()) {
            return;
        }
        AnonymousItemStack anonymousItemStack = this;
        synchronized (anonymousItemStack) {
            this.stack.remove(cacheItem);
        }
    }
}

