/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.memcache.CacheParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayIO {
    private static final Logger LOGGER;
    public static final boolean useNativeIO;
    public static final long BLOCK_THRESHOLD = 0x400000L;
    public static final int BLOCK_SIZE = 0x200000;
    public static final String INCOMPLETE_FILE_EXTENSION = ".part";
    public static final long BAD_FILE_DESCRIPTOR = -1L;

    static {
        boolean bl;
        LOGGER = LoggerFactory.getLogger(ArrayIO.class);
        boolean bl2 = false;
        boolean bl3 = bl = System.getProperty("eclipse.application") != null;
        if (!bl || CacheParameters.useNativeDll() && !ArrayIO.useNIO()) {
            try {
                System.loadLibrary("nativeio");
                bl2 = true;
            }
            catch (Throwable throwable) {
                LOGGER.error("nativeio DLL Load failed, not using native IO");
            }
        }
        useNativeIO = bl2;
        if (LOGGER.isDebugEnabled()) {
            if (useNativeIO) {
                LOGGER.debug("Using native dll for I/O");
            } else {
                LOGGER.debug("Using NIO for I/O");
            }
        }
    }

    public static native void useBufferedIO(boolean var0);

    public static native long writeByteArray(byte[] var0, byte[] var1);

    public static native long readByteArray(byte[] var0, byte[] var1);

    public static native long writeShortArray(short[] var0, byte[] var1);

    public static native long openForWriting(byte[] var0);

    public static native long close(long var0);

    public static native long appendShortArray(short[] var0, int var1, int var2, long var3);

    public static native long appendByteArray(byte[] var0, int var1, int var2, long var3);

    public static native long readShortArray(short[] var0, byte[] var1);

    public static native long appendFloatArray(float[] var0, int var1, int var2, long var3);

    public static native long appendDoubleArray(double[] var0, int var1, int var2, long var3);

    public static native long writeIntArray(int[] var0, byte[] var1);

    public static native long readIntArray(int[] var0, byte[] var1);

    public static native long writeFloatArray(float[] var0, byte[] var1);

    public static native long readFloatArray(float[] var0, byte[] var1);

    public static native long writeDoubleArray(double[] var0, byte[] var1);

    public static native long readDoubleArray(double[] var0, byte[] var1);

    public static native long openForRW(byte[] var0);

    public static native long readShortArray(short[] var0, long var1, int var3, int var4, long var5);

    public static native long writeShortArray(short[] var0, long var1, int var3, int var4, long var5);

    public static native long readByteArray(byte[] var0, long var1, int var3, int var4, long var5);

    public static native long writeByteArray(byte[] var0, long var1, int var3, int var4, long var5);

    public static native String getErrorMessage(long var0);

    private static boolean useNIO() {
        String string = System.getProperty("cache.nio");
        boolean bl = false;
        if (string != null) {
            try {
                bl = Boolean.parseBoolean(string);
            }
            catch (Exception exception) {
                LOGGER.error("Parsing cache.nio property failed", (Throwable)exception);
            }
        }
        return bl;
    }

    private static void log(Object object) {
        LOGGER.info("ArrayIO: " + object);
    }
}

