/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CachedObjectGroup;
import com.agfa.pacs.memcache.DataCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.BitSet;

public abstract class BlockedFileGroup
extends CachedObjectGroup {
    private static final ALogger logger = ALogger.getLogger(BlockedFileGroup.class);
    protected long nativeFileHandle = -1L;
    protected RandomAccessFile df;
    private BitSet presence;
    private DataOutputStream dPresence;
    private volatile boolean prescenceInitialzed = false;
    private String commonFile;
    protected String dataFile;
    protected long length;

    public BlockedFileGroup(DataCache dataCache, String string, boolean bl, long l) {
        super(dataCache, bl);
        this.commonFile = string;
        this.dataFile = String.valueOf(dataCache.getParameters().getLocation()) + File.separatorChar + string + ".dat";
        this.setLength(l);
        File file = new File(this.dataFile);
        if (!file.getParentFile().mkdirs()) {
            logger.warn("failed creating directory: " + file.getParentFile().getAbsolutePath());
        }
    }

    protected void reOpen() {
        String string = String.valueOf(this.dataFile.substring(0, this.dataFile.length() - 4)) + ".nfo";
        if (!this.readInfoFile(string) && this.length >= 0L) {
            this.createInfoFile(string);
        }
    }

    public void setLength(long l) {
        this.length = l;
    }

    protected void createInfoFile(String string) {
        this.presence = new BitSet();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(Files.newOutputStream(Paths.get(string, new String[0]), new OpenOption[0]));
            dataOutputStream.writeLong(this.length);
            this.dPresence = dataOutputStream;
        }
        catch (IOException iOException) {
            logger.error("IO error creating info file", (Throwable)iOException);
        }
    }

    private boolean readInfoFile(String string) {
        File file;
        block4: {
            file = new File(string);
            if (file.exists()) break block4;
            return false;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(Files.newInputStream(Paths.get(string, new String[0]), new OpenOption[0]));
            this.setLength(dataInputStream.readLong());
            int n = (int)(file.length() / 4L - 2L);
            this.presence = new BitSet(n);
            int n2 = 0;
            while (n2 < n) {
                this.presence.set(dataInputStream.readInt());
                ++n2;
            }
            dataInputStream.close();
            this.dPresence = new DataOutputStream(Files.newOutputStream(Paths.get(string, new String[0]), StandardOpenOption.APPEND, StandardOpenOption.CREATE));
        }
        catch (IOException iOException) {
            this.presence = new BitSet();
        }
        return true;
    }

    @Override
    public void writePersistent(Object object, CacheID cacheID) throws IOException {
        if (this.length <= 0L) {
            this.setLength(this.getSizeEstimate(object));
            this.createInfoFile(String.valueOf(this.dataFile.substring(0, this.dataFile.length() - 3)) + "nfo");
        }
        if (!this.dataFileInitialized()) {
            this.initDataFile();
        }
        String string = cacheID.toString();
        int n = string.lastIndexOf(35);
        int n2 = Integer.parseInt(string.substring(n + 1));
        long l = (long)n2 * this.length;
        if (ArrayIO.useNativeIO) {
            this.writeNative(object, l);
        } else {
            this.writeNIO(object, l);
        }
        this.initPresenceAndDPresence();
        if (this.presence == null) {
            return;
        }
        this.presence.set(n2);
        if (this.dPresence != null) {
            this.dPresence.writeInt(n2);
        }
    }

    private void initDataFile() throws FileNotFoundException {
        logger.debug("OPENING VOLUME FILE " + this.dataFile);
        if (!ArrayIO.useNativeIO) {
            this.df = new RandomAccessFile(this.dataFile, "rw");
        } else {
            byte[] byArray = (String.valueOf(this.dataFile) + "\u0000").getBytes();
            do {
                this.nativeFileHandle = ArrayIO.openForRW(byArray);
                if (this.nativeFileHandle != -1L) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            } while (this.nativeFileHandle == -1L);
        }
    }

    private boolean dataFileInitialized() {
        return ArrayIO.useNativeIO ? this.nativeFileHandle != -1L : this.df != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        BlockedFileGroup blockedFileGroup = this;
        synchronized (blockedFileGroup) {
            try {
                this.initPresenceAndDPresence();
                if (this.dPresence != null) {
                    this.dPresence.flush();
                }
                if (ArrayIO.useNativeIO) {
                    logger.debug("FLUSH, CLOSING VOLUME FILE " + this.dataFile);
                    if (this.nativeFileHandle != -1L) {
                        long l = ArrayIO.close(this.nativeFileHandle);
                        this.nativeFileHandle = -1L;
                        if (l != 0L) {
                            logger.error("io error flushing: " + ArrayIO.getErrorMessage(l));
                        }
                    }
                } else {
                    this.df.close();
                    this.df = null;
                }
            }
            catch (IOException iOException) {
                logger.error("io error flushing", (Throwable)iOException);
            }
            super.flush();
        }
    }

    public abstract void writeNative(Object var1, long var2) throws IOException;

    public abstract void writeNIO(Object var1, long var2) throws IOException;

    public abstract void readNative(Object var1, long var2) throws IOException;

    public abstract void readNIO(Object var1, long var2) throws IOException;

    @Override
    public boolean persistentItemExists(CacheID cacheID) {
        String string = cacheID.toString();
        int n = string.lastIndexOf(35);
        int n2 = Integer.parseInt(string.substring(n + 1));
        this.initPresenceAndDPresence();
        if (this.presence == null) {
            this.reOpen();
        }
        return this.presence == null ? false : (n2 < this.presence.size() ? this.presence.get(n2) : false);
    }

    @Override
    public Object readPersistent(CacheID cacheID, Object object) throws IOException {
        if (this.length < 0L) {
            throw new IllegalStateException();
        }
        if (!this.dataFileInitialized()) {
            this.initDataFile();
        }
        String string = cacheID.toString();
        int n = string.lastIndexOf(35);
        int n2 = Integer.parseInt(string.substring(n + 1));
        this.initPresenceAndDPresence();
        if (this.presence == null || n2 >= this.presence.size() || !this.presence.get(n2)) {
            return null;
        }
        long l = (long)n2 * this.length;
        if (ArrayIO.useNativeIO) {
            this.readNative(object, l);
        } else {
            this.readNIO(object, l);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromDisk(CacheItem cacheItem, boolean bl) {
        String string = cacheItem.getID().toString();
        int n = string.lastIndexOf(35);
        int n2 = Integer.parseInt(string.substring(n + 1));
        this.dataCache.getOnDisk().removeFromList(cacheItem);
        BlockedFileGroup blockedFileGroup = this;
        synchronized (blockedFileGroup) {
            this.initPresenceAndDPresence();
            if (this.presence != null && n2 < this.presence.size()) {
                this.presence.clear(n2);
            }
            if (this.presence == null || this.presence.cardinality() == 0) {
                try {
                    logger.debug("ALL REMOVED, CLOSING VOLUME FILE " + this.dataFile);
                    if (this.df != null) {
                        this.df.close();
                    }
                    if (this.dPresence != null) {
                        this.dPresence.close();
                    }
                    if (this.nativeFileHandle != -1L) {
                        long l = ArrayIO.close(this.nativeFileHandle);
                        this.nativeFileHandle = -1L;
                        if (l != -1L) {
                            logger.error("IO error removing item from disk: " + ArrayIO.getErrorMessage(l));
                        }
                    }
                }
                catch (IOException iOException) {
                    logger.error("IO error removing item from disk", (Throwable)iOException);
                }
                this.dataCache.getOnDisk().setDeleteOccured();
                this.presence = null;
            }
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        return this.length;
    }

    @Override
    public void addPersistent(Object object, CacheID cacheID, int n) {
        if (this.length < 0L) {
            this.setLength(this.getSizeEstimate(object));
            this.createInfoFile(String.valueOf(this.dataFile.substring(0, this.dataFile.length() - 3)) + "nfo");
        }
        super.addPersistent(object, cacheID, n);
    }

    public abstract Object readItem(InputStream var1, long var2) throws IOException;

    public abstract void writeItem(DataOutputStream var1, Object var2) throws IOException;

    @Override
    public String getPersistentLocation(CacheID cacheID) {
        return this.dataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPresenceAndDPresence() {
        if (!this.prescenceInitialzed) {
            BlockedFileGroup blockedFileGroup = this;
            synchronized (blockedFileGroup) {
                if (!this.prescenceInitialzed) {
                    String string = String.valueOf(this.dataCache.getParameters().getLocation()) + File.separatorChar + this.commonFile + ".nfo";
                    if (!this.readInfoFile(string) && this.length >= 0L) {
                        this.createInfoFile(string);
                    }
                    this.prescenceInitialzed = true;
                }
            }
        }
    }

    protected BitSet getPresence() {
        this.initPresenceAndDPresence();
        return this.presence;
    }

    protected DataOutputStream getDPresence() {
        this.initPresenceAndDPresence();
        return this.dPresence;
    }
}

