/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public class CacheItem {
    private static final ALogger LOGGER = ALogger.getLogger(CacheItem.class);
    private static Reference DUMMY_REFERENCE = new SoftReferencedItem((Object)null);
    public static final ReferenceQueue<Object> collectedItems = new ReferenceQueue();
    private ItemState state;
    protected Object item;
    protected int referenceCount;
    private ICachedObjectGroup mgmtGroup;
    private ICachedObjectGroup persistGroup;
    private CacheID id;
    private int priority;

    public CacheItem(Object object, ICachedObjectGroup iCachedObjectGroup) {
        this.state = ItemState.ANONYMOUS;
        this.item = new WeakReferencedItem(object, collectedItems, this);
        this.mgmtGroup = iCachedObjectGroup;
        this.persistGroup = iCachedObjectGroup;
        this.priority = 15;
    }

    public CacheItem(Object object, CacheID cacheID, ItemState itemState, ICachedObjectGroup iCachedObjectGroup, int n) {
        this.state = itemState;
        if (itemState == ItemState.PERSISTENT) {
            this.item = object;
        } else if (itemState == ItemState.PERSONALIZED) {
            this.item = new SoftReferencedItem(object, collectedItems, this);
        } else {
            throw new IllegalArgumentException();
        }
        this.id = cacheID;
        this.mgmtGroup = iCachedObjectGroup;
        this.persistGroup = iCachedObjectGroup;
        this.priority = n;
    }

    public CacheItem(Object object, CacheID cacheID, ICachedObjectGroup iCachedObjectGroup, int n) {
        this.id = cacheID;
        this.item = object;
        this.priority = n;
        this.state = this.item == null ? ItemState.PERSONALIZED : ItemState.PERSISTENT;
        this.mgmtGroup = iCachedObjectGroup;
        this.persistGroup = iCachedObjectGroup;
    }

    public CacheItem(Object object, CacheID cacheID, ICachedObjectGroup iCachedObjectGroup, ICachedObjectGroup iCachedObjectGroup2, int n) {
        this(object, cacheID, iCachedObjectGroup2, n);
        if (object == null) {
            this.state = ItemState.PERSONALIZED;
            this.item = DUMMY_REFERENCE;
        }
        this.persistGroup = iCachedObjectGroup;
    }

    public Object getItemUnsynced() {
        if (this.item == null) {
            return null;
        }
        if (this.item instanceof WeakReferencedItem) {
            Object t = ((Reference)this.item).get();
            return t;
        }
        if (this.item instanceof SoftReferencedItem) {
            return ((Reference)this.item).get();
        }
        return this.item;
    }

    public boolean dataAvailableUnsynced() {
        if (this.item == null) {
            return false;
        }
        if (this.item instanceof Reference) {
            return ((Reference)this.item).get() != null;
        }
        return true;
    }

    public synchronized Object claimItemSynced() {
        if (this.item == null) {
            return null;
        }
        if (this.state == ItemState.ANONYMOUS) {
            Object t = ((Reference)this.item).get();
            this.setItemReference(null);
            return t;
        }
        if (this.state == ItemState.PERSONALIZED) {
            if (this.referenceCount > 0) {
                return null;
            }
            if (!(this.item instanceof Reference)) {
                LOGGER.warn("oops... this is a message from mem cache CacheItem");
            }
            Object t = ((Reference)this.item).get();
            this.setItemReference(null);
            return t;
        }
        return null;
    }

    public synchronized Object releaseReferenceAndClaimItemSynced() {
        --this.referenceCount;
        if (this.item == null) {
            return null;
        }
        if (this.state == ItemState.ANONYMOUS) {
            Object t = ((Reference)this.item).get();
            this.setItemReference(null);
            return t;
        }
        if (this.state == ItemState.PERSONALIZED) {
            if (this.referenceCount > 0) {
                return null;
            }
            Object t = ((Reference)this.item).get();
            this.setItemReference(null);
            return t;
        }
        return null;
    }

    public synchronized Object getItemReferenceSynced() {
        if (this.item == null) {
            return null;
        }
        if (this.item instanceof WeakReferencedItem) {
            throw new IllegalStateException();
        }
        if (this.item instanceof SoftReferencedItem) {
            Object t = ((Reference)this.item).get();
            if (t != null) {
                ++this.referenceCount;
            }
            return t;
        }
        Object object = this.item;
        ++this.referenceCount;
        return object;
    }

    public boolean isClaimableUnsynced() {
        return this.referenceCount == 0 && this.state.isClaimable();
    }

    public boolean isClaimableAndHasDataUnsynced() {
        if (this.referenceCount != 0 || !this.state.isClaimable()) {
            return false;
        }
        Object object = this.item;
        if (object instanceof Reference) {
            return ((Reference)object).get() != null;
        }
        return object != null;
    }

    public synchronized void releaseReferenceSynced() {
        --this.referenceCount;
        if (this.referenceCount < 0) {
            this.referenceCount = 0;
            throw new IllegalStateException("reference count underrun for " + this.id);
        }
        if (this.referenceCount == 0 && this.state == ItemState.DELETED) {
            this.removeUnsynced(false);
        }
    }

    public ItemState getUnsyncedState() {
        return this.state;
    }

    public ICachedObjectGroup getManagementGroup() {
        return this.mgmtGroup;
    }

    public ICachedObjectGroup getPersistenceGroup() {
        return this.persistGroup;
    }

    public void writePersistent() {
        if (this.persistGroup.isDestroyed()) {
            return;
        }
        this.persistGroup.writePersistent(this);
    }

    public synchronized void setStateSynced(ItemState itemState) {
        if (itemState == ItemState.WRITING && (this.item == null || this.item instanceof Reference)) {
            throw new Error("trying to write null item:" + this.toString());
        }
        if (this.state == ItemState.DELETED) {
            return;
        }
        this.state = itemState;
        if (itemState == ItemState.PERSONALIZED && !(this.item instanceof SoftReferencedItem)) {
            this.setItemReference(new SoftReferencedItem(this.getItemUnsynced(), collectedItems, this));
        }
        if (itemState == ItemState.ANONYMOUS && !(this.item instanceof WeakReferencedItem)) {
            this.setItemReference(new WeakReferencedItem(this.getItemUnsynced(), collectedItems, this));
        }
    }

    public void resurrect(Object object) {
        if (this.state != ItemState.DELETED) {
            throw new IllegalStateException();
        }
        this.state = ItemState.PERSISTENT;
        this.setItemReference(object);
    }

    public void setStateUnsynced(ItemState itemState) {
        if (itemState == ItemState.WRITING && (this.item == null || this.item instanceof Reference)) {
            throw new Error("trying to write null item:" + this.toString());
        }
        if (this.state == ItemState.DELETED) {
            return;
        }
        this.state = itemState;
        if (itemState == ItemState.PERSONALIZED && !(this.item instanceof SoftReferencedItem)) {
            this.setItemReference(new SoftReferencedItem(this.getItemUnsynced(), collectedItems, this));
        } else if (itemState == ItemState.ANONYMOUS && !(this.item instanceof WeakReferencedItem)) {
            this.setItemReference(new WeakReferencedItem(this.getItemUnsynced(), collectedItems, this));
        }
    }

    public CacheID getID() {
        return this.id;
    }

    public void setDataUnsynced(Object object) {
        assert (this.state == ItemState.READING);
        this.setItemReference(new SoftReferencedItem(object, collectedItems, this));
    }

    public boolean isReferencedUnsynced() {
        return this.referenceCount > 0;
    }

    public String toString() {
        if (this.state == ItemState.ANONYMOUS) {
            return "ANONYMOUS   :" + (this.item == null ? null : ((Reference)this.item).get());
        }
        if (this.state == ItemState.PERSONALIZED) {
            return "PERSONALIZED:" + this.id + " Refs:" + this.referenceCount + ":(R)" + (this.item == null ? null : ((Reference)this.item).get());
        }
        if (this.state == ItemState.PERSISTENT) {
            return "PERSISTENT:" + this.id + " Refs:" + this.referenceCount + ":" + this.item;
        }
        return (Object)((Object)this.state) + ":" + this.id + " Refs:" + this.referenceCount + ":" + this.item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnsynced(boolean bl) {
        boolean bl2;
        CacheItem cacheItem = this;
        synchronized (cacheItem) {
            boolean bl3 = bl2 = this.referenceCount == 0;
            if (bl2) {
                ++this.referenceCount;
            }
            this.setItemReference(null);
            this.state = ItemState.DELETED;
            this.persistGroup.removeFromDisk(this, bl);
        }
        if (bl2) {
            this.mgmtGroup.removeGlobally(this);
        }
    }

    public void removeFromGroupUnsynced() {
        this.mgmtGroup.removeItem(this);
    }

    public synchronized void updateAndReleaseReferenceSynced() {
        --this.referenceCount;
        if (this.referenceCount < 0) {
            throw new IllegalStateException("reference count underrun for " + this.id);
        }
        if (this.state == ItemState.DELETED) {
            if (this.referenceCount == 0) {
                this.removeUnsynced(false);
            }
            throw new IllegalStateException("modified deleted object of " + this.id);
        }
        if (this.state == ItemState.WRITING) {
            this.state = ItemState.MODIFIED;
        } else {
            this.setItemReference(this.getItemUnsynced());
            this.state = ItemState.PERSISTENT;
        }
    }

    public void touch() {
        this.mgmtGroup.touch(this, this.id);
    }

    public void addReferenceUnsynced() {
        ++this.referenceCount;
    }

    public void checkSanity() {
        if (this.item != null && !(this.item instanceof Reference) && this.referenceCount == 0 && this.state != ItemState.WRITING) {
            LOGGER.warn((Object)((Object)this.state) + " hard ref without referrers:" + this.id);
        }
    }

    public void setPriority(int n) {
        boolean bl;
        boolean bl2 = bl = this.priority != n;
        if (bl) {
            this.priority = n;
            this.mgmtGroup.priorityChanged(this);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    private void setItemReference(Object object) {
        if (this.item == object) {
            return;
        }
        if (this.item instanceof WeakReferencedItem) {
            ((WeakReferencedItem)this.item).clearReference();
        } else if (this.item instanceof SoftReferencedItem) {
            ((SoftReferencedItem)this.item).clearReference();
        }
        this.item = object;
    }

    public static void referenceDisposed(Reference<? extends Object> reference, GlobalLRU globalLRU) {
        CacheItem cacheItem = reference instanceof WeakReferencedItem ? ((WeakReferencedItem)reference).getCacheItem() : (reference instanceof SoftReferencedItem ? ((SoftReferencedItem)reference).getCacheItem() : null);
        if (cacheItem != null) {
            cacheItem.payloadClaimed(globalLRU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void payloadClaimed(GlobalLRU globalLRU) {
        if (this.id == null) {
            this.mgmtGroup.removeAnonymousItem(this);
        } else {
            boolean bl;
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                bl = this.referenceCount > 0;
            }
            if (!bl) {
                globalLRU.remove(this);
            }
        }
    }

    private static class SoftReferencedItem
    extends SoftReference<Object> {
        private CacheItem item;

        public SoftReferencedItem(Object object, ReferenceQueue<Object> referenceQueue, CacheItem cacheItem) {
            super(object, referenceQueue);
            this.item = cacheItem;
        }

        public SoftReferencedItem(Object object) {
            super(object);
            this.item = null;
        }

        public CacheItem getCacheItem() {
            return this.item;
        }

        void clearReference() {
            this.item = null;
        }
    }

    private static class WeakReferencedItem
    extends WeakReference<Object> {
        private CacheItem item;

        WeakReferencedItem(Object object, ReferenceQueue<Object> referenceQueue, CacheItem cacheItem) {
            super(object, referenceQueue);
            this.item = cacheItem;
        }

        CacheItem getCacheItem() {
            return this.item;
        }

        void clearReference() {
            this.item = null;
        }
    }
}

