/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.ICacheItemGroup;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CacheItemGroup
implements ICacheItemGroup {
    private static final ALogger LOGGER = ALogger.getLogger(CacheItemGroup.class);
    private final String groupName;
    private final DataCache dc;

    public CacheItemGroup(String string, DataCache dataCache) {
        this.groupName = string;
        this.dc = dataCache;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<CacheID> getItemIDs(Class<?> clazz) {
        ICachedObjectGroup iCachedObjectGroup = this.dc.getGroupFor(clazz, this.dc.createID(this.groupName, "", 1), 0L);
        String[] stringArray = iCachedObjectGroup.getItemMembers();
        if (stringArray != null) {
            ArrayList<CacheID> arrayList = new ArrayList<CacheID>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                arrayList.add(this.dc.createID(this.groupName, stringArray[n], 1));
                ++n;
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public long lastAccessed() {
        return 0L;
    }

    public String[] deleteAllItems() {
        String[] stringArray;
        ICachedObjectGroup iCachedObjectGroup;
        try {
            iCachedObjectGroup = this.dc.removeGroup(ByteArrayContainer.class, this.dc.createID(this.groupName, "", 1));
        }
        catch (RuntimeException runtimeException) {
            LOGGER.debug("State exception", (Throwable)runtimeException);
            return new String[0];
        }
        String[] stringArray2 = stringArray = iCachedObjectGroup.getItemMembers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.dc.remove(this.dc.createID(this.groupName, string, 1));
            ++n2;
        }
        iCachedObjectGroup.dispose();
        return stringArray;
    }
}

