/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.Messages;
import com.agfa.pacs.memcache.internal.MemoryManagementLink;
import com.agfa.pacs.tools.StringTools;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import javax.swing.JOptionPane;

public class CacheParameters
implements IConfigurationChangeListener {
    private static final IConfigurationProvider config = ConfigurationProviderFactory.getConfig();
    private static final String IMPAXEE_CACHE_DIR = "Cache";
    public static final String AGILITY_CACHE_SUBDIR = "unversioned";
    private static final String WORKSTATION_GROUP_CONFIG_NODE = "workstationGroup";
    private static final String USE_WORKSTATION_GROUP_SETTINGS_CONFIG_NODE = "UseWorkstationGroupSettings";
    private static final String USE_DISK_CONFIG_NODE = "UseDisk";
    private static final String KEEP_FOOTPRINT_SMALL_CONFIG_NODE = "KeepFootprintSmall";
    private static final String MINIMUM_FREE_PERCENTAGE_CONFIG_NODE = "MinimumFreePercentage";
    private static final String CLEAN_FREE_PERCENTAGE_CONFIG_NODE = "CleanFreePercentage";
    private static final String DISK_FREE_LIMIT_CONFIG_NODE = "DiskFreeLimit";
    private static final String DISK_SIZE_LIMIT_CONFIG_NODE = "DiskSizeLimit";
    private static final String PERSISTENT_CACHE_DIR_CONFIG_NODE = "PersistentCacheDir";
    private static final String SESSION_PERSISTENCE_CONFIG_NODE = "SessionPersistence";
    private static final String CONTINUOUS_CACHE_CLEANUP_CONFIG_NODE = "ContinuousCacheCleanup";
    private static final String SLOW_CACHE_WRITING_CONFIG_NODE = "SlowCacheWriting";
    private static final String USE_NATIVE_DLL_CONFIG_NODE = "UseNativeDLL";
    private static final String DO_NOT_WRITE_TO_DISK_IF_MORE_FREE_MEMORY_AVAILABLE = "BlockWritingWhenMoreAvailableGB";
    private static final String WORKSTATION_CONFIG_PATH = "com.agfa.memcache";
    private static final String LOCK_DIRECTORY_PREFIX = "locks";
    private static final ALogger LOGGER = ALogger.getLogger(CacheParameters.class);
    private static boolean forceSessionPersistence = false;
    private boolean usePersistentStorage;
    private boolean sessionPersistence;
    private boolean continuousCacheCleanup;
    private long topThreshold;
    private long cleanThreshold;
    private String baseLocation;
    private long writeToDiskThreshold = -1L;
    private double minFreePercentage = 0.15;
    private double cleanFreePercentage;
    private long usageThreshold;
    private long criticalUsageThreshold;
    private boolean keepFootprintSmall;
    private long diskSizeLimit;
    private long diskFreeLimit;
    private String lockDirectoryPath;
    private boolean slowCacheWriting = false;
    private final IConfigurationProvider workstationBaseConfig = config.getNode("com.agfa.memcache");
    private IConfigurationProvider workstationSharedConfig;

    public CacheParameters() {
        this.initSharedConfigProvider();
        this.readConfig();
        this.updateConfig();
        this.updateThresholds();
        if (ArrayIO.useNativeIO) {
            ArrayIO.useBufferedIO(!this.isPermanent());
        }
        config.registerConfigurationChangeListener(WORKSTATION_CONFIG_PATH, (IConfigurationChangeListener)this);
    }

    private void initSharedConfigProvider() {
        this.workstationSharedConfig = this.shouldUseWorkstationGroupSettings() ? this.workstationBaseConfig.getNode(WORKSTATION_GROUP_CONFIG_NODE) : this.workstationBaseConfig;
    }

    private boolean shouldUseWorkstationGroupSettings() {
        if (this.workstationBaseConfig.exists(USE_WORKSTATION_GROUP_SETTINGS_CONFIG_NODE) && this.workstationBaseConfig.getBoolean(USE_WORKSTATION_GROUP_SETTINGS_CONFIG_NODE)) {
            if (this.workstationBaseConfig.exists(WORKSTATION_GROUP_CONFIG_NODE)) {
                return true;
            }
            LOGGER.warn("It is configured to use the cache settings on workstation group level, but the required config node does not exist! Config entries on workstation level are used instead!");
            return false;
        }
        return false;
    }

    private void readConfig() {
        Object object;
        boolean bl;
        if (this.workstationSharedConfig.exists(PERSISTENT_CACHE_DIR_CONFIG_NODE)) {
            this.baseLocation = this.workstationSharedConfig.getString(PERSISTENT_CACHE_DIR_CONFIG_NODE);
        } else {
            this.baseLocation = this.workstationBaseConfig.getString(PERSISTENT_CACHE_DIR_CONFIG_NODE);
            LOGGER.warn("The config entry for the cache dir does not exist on workstation group level. Setting on workstation level will be used!");
        }
        if (System.getProperty("config.cache") != null) {
            this.baseLocation = System.getProperty("config.cache");
        }
        this.writeToDiskThreshold = this.workstationBaseConfig.getLong(DO_NOT_WRITE_TO_DISK_IF_MORE_FREE_MEMORY_AVAILABLE);
        if (this.writeToDiskThreshold > 0L) {
            this.writeToDiskThreshold = this.writeToDiskThreshold * 1024L * 1024L * 1024L;
        }
        if (bl = "TEMP".equalsIgnoreCase(this.baseLocation)) {
            this.baseLocation = this.getAgilityCachePathInTempDir();
        }
        if (this.readPersistentStorageFromConfig() && !this.isCacheWritable()) {
            object = this.baseLocation;
            this.baseLocation = CacheParameters.getDefaultCacheLocation();
            CacheParameters.requestCacheDirectoryReconfiguration((String)object, this.baseLocation);
        }
        if (this.baseLocation.endsWith("/")) {
            this.baseLocation = this.baseLocation.substring(0, this.baseLocation.length() - 1);
        }
        if (!this.baseLocation.endsWith(File.separator)) {
            this.baseLocation = String.valueOf(this.baseLocation) + File.separatorChar;
        }
        if (!bl) {
            this.baseLocation = String.valueOf(this.baseLocation) + IMPAXEE_CACHE_DIR + File.separator;
        }
        if (!((File)(object = new File(this.baseLocation))).mkdirs() && !((File)object).exists()) {
            LOGGER.warn("Couldn't create directory for cache in: " + this.baseLocation + ". The cache directory of the temp directory is used instead!");
            this.baseLocation = this.getAgilityCachePathInTempDir();
            File file = new File(this.baseLocation);
            if (!file.mkdirs() && !file.exists()) {
                LOGGER.error("Couldn't create directory for cache in temp directory: " + this.baseLocation);
            }
        }
        this.lockDirectoryPath = String.valueOf(this.baseLocation) + LOCK_DIRECTORY_PREFIX + File.separatorChar;
    }

    private String getAgilityCachePathInTempDir() {
        return new File(System.getProperty("java.io.tmpdir"), IMPAXEE_CACHE_DIR).getAbsolutePath();
    }

    private void updateConfig() {
        this.usePersistentStorage = this.readPersistentStorageFromConfig();
        this.sessionPersistence = this.getBooleanConfig(SESSION_PERSISTENCE_CONFIG_NODE, null);
        this.continuousCacheCleanup = this.getBooleanConfig(CONTINUOUS_CACHE_CLEANUP_CONFIG_NODE, true);
        if (this.workstationSharedConfig.exists(DISK_SIZE_LIMIT_CONFIG_NODE)) {
            this.diskSizeLimit = StringTools.parseMemoryAmount((String)this.workstationSharedConfig.getString(DISK_SIZE_LIMIT_CONFIG_NODE));
        } else {
            this.diskSizeLimit = StringTools.parseMemoryAmount((String)this.workstationBaseConfig.getString(DISK_SIZE_LIMIT_CONFIG_NODE));
            LOGGER.warn("The config entry for the disk size limit does not exist on workstation group level. Setting on workstation level will be used!");
        }
        this.diskFreeLimit = StringTools.parseMemoryAmount((String)this.workstationBaseConfig.getString(DISK_FREE_LIMIT_CONFIG_NODE));
        this.minFreePercentage = Double.parseDouble(this.workstationBaseConfig.getString(MINIMUM_FREE_PERCENTAGE_CONFIG_NODE));
        this.cleanFreePercentage = Double.parseDouble(this.workstationBaseConfig.getString(CLEAN_FREE_PERCENTAGE_CONFIG_NODE));
        this.slowCacheWriting = this.workstationBaseConfig.getBoolean(SLOW_CACHE_WRITING_CONFIG_NODE);
        this.keepFootprintSmall = this.workstationBaseConfig.getBoolean(KEEP_FOOTPRINT_SMALL_CONFIG_NODE);
    }

    private boolean readPersistentStorageFromConfig() {
        return this.workstationBaseConfig.getBoolean(USE_DISK_CONFIG_NODE);
    }

    private boolean getBooleanConfig(String string, Boolean bl) {
        boolean bl2;
        if (this.workstationSharedConfig.exists(string)) {
            bl2 = this.workstationSharedConfig.getBoolean(string);
        } else if (bl == null || this.workstationBaseConfig.exists(string)) {
            LOGGER.warn("The config entry for {} does not exist on workstation group level. Setting on workstation level will be used!", (Object)string);
            bl2 = this.workstationBaseConfig.getBoolean(string);
        } else {
            bl2 = bl;
        }
        return bl2;
    }

    private void updateThresholds() {
        try {
            long l = Runtime.getRuntime().maxMemory();
            this.topThreshold = (long)((double)l * this.minFreePercentage);
            this.cleanThreshold = (long)((double)l * this.cleanFreePercentage);
            long l2 = l;
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : list) {
                if (!"Tenured Gen".equals(memoryPoolMXBean.getName())) continue;
                l2 = memoryPoolMXBean.getUsage().getMax();
                break;
            }
            long l3 = (long)((double)l2 * this.minFreePercentage);
            long l4 = (long)((double)l2 * this.cleanFreePercentage);
            this.usageThreshold = (long)((double)l2 - (double)l4 * 1.1);
            this.criticalUsageThreshold = (long)((double)l2 - (double)l3 * 1.1);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.topThreshold = (long)((double)Runtime.getRuntime().totalMemory() * this.minFreePercentage);
            this.cleanThreshold = (long)((double)Runtime.getRuntime().totalMemory() * this.cleanFreePercentage);
            this.usageThreshold = (long)((double)Runtime.getRuntime().totalMemory() - (double)this.cleanThreshold * 1.1);
            this.criticalUsageThreshold = (long)((double)Runtime.getRuntime().totalMemory() - (double)this.topThreshold * 1.1);
        }
    }

    public boolean isAllocationAllowed(long l) {
        return this.getFreeMem() - l > this.topThreshold;
    }

    public boolean isFastCleanThresholdExceeded() {
        return this.getFreeMem() < this.cleanThreshold;
    }

    public boolean isWriteToDiskThresholdExceeded() {
        if (this.writeToDiskThreshold < 0L) {
            return true;
        }
        return this.getFreeMem() < this.writeToDiskThreshold;
    }

    public boolean isSlowCacheWriting() {
        return this.slowCacheWriting;
    }

    public boolean keepFootprintSmall() {
        return this.keepFootprintSmall;
    }

    public long getFreeMem() {
        try {
            return Math.max(0L, Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory() - MemoryManagementLink.getFreeMin());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return Runtime.getRuntime().freeMemory();
        }
    }

    public boolean usePersistentStorage() {
        return this.usePersistentStorage;
    }

    public String getLocation() {
        return this.baseLocation;
    }

    public boolean isPermanent() {
        return this.sessionPersistence || forceSessionPersistence || this.clearCacheOnShutdown();
    }

    public boolean clearCacheOnShutdown() {
        return !this.sessionPersistence && !this.continuousCacheCleanup;
    }

    public long getUsageThreshold() {
        return this.usageThreshold;
    }

    public long getCriticalUsageThreshold() {
        return this.criticalUsageThreshold;
    }

    public long toFreeOnCollectionThresholdNotif() {
        return (long)((double)(this.getCriticalUsageThreshold() - this.getUsageThreshold()) * 1.5);
    }

    public long getDiskSizeLimit() {
        return this.diskSizeLimit;
    }

    public long getMinimumFreeDisk() {
        return this.diskFreeLimit;
    }

    public String getLockDirectoryPath() {
        return this.lockDirectoryPath;
    }

    public void configurationChanged(String string) {
        this.initSharedConfigProvider();
        this.updateConfig();
        this.updateThresholds();
    }

    public static void forceSessionPersistence() {
        forceSessionPersistence = true;
        ArrayIO.useBufferedIO(false);
    }

    public static boolean useNativeDll() {
        return config.getNode(WORKSTATION_CONFIG_PATH).getBoolean(USE_NATIVE_DLL_CONFIG_NODE);
    }

    public void updateEdenSpace(long l) {
        double d = (double)l / (double)Runtime.getRuntime().maxMemory();
        if (d > 0.09) {
            this.minFreePercentage = d * 1.5;
            this.cleanFreePercentage += this.minFreePercentage;
        }
        this.updateThresholds();
    }

    private boolean isCacheWritable() {
        File file = new File(this.baseLocation);
        if (!file.exists() && !file.mkdirs()) {
            return false;
        }
        File file2 = new File(file, "TEMP");
        file2.deleteOnExit();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.warn("Closing stream failed.", (Throwable)iOException);
                }
            }
            if (!file2.delete()) {
                LOGGER.warn("Deleting temporary file failed: " + file2);
            }
        }
    }

    private static String getDefaultCacheLocation() {
        File file = new File("").getAbsoluteFile();
        if (file.getName().equalsIgnoreCase("LOG")) {
            file = file.getParentFile();
        }
        file = new File(file, IMPAXEE_CACHE_DIR);
        return file.getAbsolutePath();
    }

    private static void requestCacheDirectoryReconfiguration(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("The configured cache directory '");
        stringBuilder.append(string);
        stringBuilder.append("' is not writable, using fallback: ");
        stringBuilder.append(string2);
        LOGGER.error(stringBuilder.toString());
        if (!Boolean.parseBoolean(System.getProperty("java.awt.headless"))) {
            if (EventQueue.isDispatchThread()) {
                CacheParameters.notifyUserOfNonWritableCacheDirectory();
            } else {
                EventQueue.invokeLater(CacheParameters::notifyUserOfNonWritableCacheDirectory);
            }
        }
    }

    static void notifyUserOfNonWritableCacheDirectory() {
        JOptionPane.showMessageDialog(null, Messages.getString("CacheParameters.DirectoryNotWritable.Message"), Messages.getString("CacheParameters.DirectoryNotWritable.Title"), 0);
    }
}

