/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.AbstractCacheGroup;
import com.agfa.pacs.memcache.AnonymousItemStack;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.GroupLRU;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.IPersistenceQueue;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.PersistentGroupLRU;
import com.agfa.pacs.memcache.PersonalizedGroupLRU;
import com.agfa.pacs.memcache.internal.GlobalLRU;

public abstract class CachedObjectGroup
extends AbstractCacheGroup {
    private static final ALogger logger = ALogger.getLogger(CachedObjectGroup.class);
    protected AnonymousItemStack anonymous;
    protected GroupLRU personalized;
    protected GroupLRU persistent;
    protected GlobalLRU global;

    public CachedObjectGroup(DataCache dataCache, boolean bl) {
        super(dataCache);
        if (dataCache != null) {
            if (bl) {
                this.anonymous = new AnonymousItemStack(dataCache.getGlobalLRU());
            }
            this.personalized = new PersonalizedGroupLRU(dataCache.getGlobalLRU());
            this.persistent = new PersistentGroupLRU(dataCache.getGlobalLRU(), dataCache.getParameters());
            this.global = dataCache.getGlobalLRU();
        }
    }

    @Override
    public void putPersonalized(Object object, CacheID cacheID, int n) {
        CacheItem cacheItem = new CacheItem(object, cacheID, ItemState.PERSONALIZED, (ICachedObjectGroup)this, n);
        this.global.put(cacheID, cacheItem);
        this.personalized.addAtBottom(cacheItem, cacheItem.getPriority());
    }

    @Override
    public Object allocateObject(boolean bl, int n) {
        if (this.anonymous == null) {
            return this.allocateNew();
        }
        Object object = this.anonymous.popNonEmpty();
        if (object != null) {
            if (bl) {
                this.clear(object);
            }
            return object;
        }
        if (!this.dataCache.getParameters().keepFootprintSmall() && this.isAllocationAllowed()) {
            return this.allocateNew();
        }
        if (this.personalized.hasClaimableItemsUnsynced(n) && (object = this.personalized.claimNonEmpty(n)) != null) {
            if (bl) {
                this.clear(object);
            }
            return object;
        }
        if (this.persistent.hasClaimableItemsUnsynced(n) && (object = this.persistent.claimNonEmpty(n)) != null) {
            if (bl) {
                this.clear(object);
            }
            return object;
        }
        return this.allocateNew();
    }

    @Override
    public void addPersistent(Object object, CacheID cacheID, int n) {
        CacheItem cacheItem = this.addPersistentInternal(object, cacheID, n);
        if (cacheItem != null) {
            this.persistent.addAtBottom(cacheItem, cacheItem.getPriority());
        }
    }

    @Override
    public void free(Object object) {
        if (this.anonymous == null) {
            return;
        }
        CacheItem cacheItem = new CacheItem(object, this);
        this.anonymous.pushSynced(cacheItem);
        this.dataCache.getGlobalLRU().put(cacheItem);
    }

    @Override
    public void touch(CacheItem cacheItem, CacheID cacheID) {
        this.global.touch(cacheItem);
        this.touchLocally(cacheItem, cacheID);
    }

    @Override
    public void touchLocally(CacheItem cacheItem, CacheID cacheID) {
        this.persistent.addAtBottom(cacheItem, cacheItem.getPriority());
    }

    @Override
    public Object getPersistent(CacheItem cacheItem, CacheID cacheID) {
        this.persistent.addAtBottom(cacheItem, cacheItem.getPriority());
        return super.getPersistent(cacheItem, cacheID);
    }

    @Override
    public void removeItem(CacheItem cacheItem) {
        CacheID cacheID = cacheItem.getID();
        if (cacheID != null) {
            this.personalized.remove(cacheItem);
            this.persistent.remove(cacheItem);
        }
    }

    public void dumpContent(boolean bl) {
        logger.info("anonymous:");
        this.anonymous.dumpContent(bl);
        logger.info("personalized:");
        this.personalized.dumpContent(bl);
        logger.info("persistent:");
        this.persistent.dumpContent(bl);
        logger.info("global:");
        this.dataCache.getGlobalLRU().dumpContent(bl);
    }

    public abstract boolean isAllocationAllowed();

    @Override
    public void priorityChanged(CacheItem cacheItem) {
        IPersistenceQueue iPersistenceQueue = this.dataCache.getPersistenceQueue();
        iPersistenceQueue.updatePriority(cacheItem);
        this.global.touch(cacheItem);
        this.persistent.changePriority(cacheItem, cacheItem.getPriority(), true);
        this.personalized.changePriority(cacheItem, cacheItem.getPriority(), true);
    }

    @Override
    public boolean isEmpty() {
        return !(this.persistent != null && !this.persistent.isEmpty() || this.personalized != null && !this.personalized.isEmpty() || this.anonymous != null && !this.anonymous.isEmpty());
    }

    @Override
    public void addPersistent(CacheItem cacheItem) {
        this.persistent.addAtBottom(cacheItem, cacheItem.getPriority());
    }

    @Override
    public boolean usesPool() {
        return this.anonymous != null;
    }

    @Override
    public void removeAnonymousItem(CacheItem cacheItem) {
        if (this.anonymous == null) {
            throw new IllegalStateException("anonymous item managed by non anonymous group");
        }
        this.anonymous.remove(cacheItem);
        this.global.removeAnonymousSynced(cacheItem);
    }
}

