/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CachedObjectGroup;
import com.agfa.pacs.memcache.DataCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class CommonFileGroup
extends CachedObjectGroup {
    private static final ALogger LOGGER = ALogger.getLogger(CommonFileGroup.class);
    protected final String GROUP_STATE_ATTRIBUTE_NAME = "GroupState";
    protected final String GROUP_STATE_CREATED = "CREATED";
    protected static final long[] ADDED = new long[0];
    protected String dataFile;
    protected String indexFile;
    private volatile Map<String, long[]> index = null;
    protected Map<String, long[]> deleted;
    protected Map<String, long[]> toCommit;
    private long appendPos;
    protected boolean destroyed;
    protected FileGroupState groupState = FileGroupState.CLOSED;
    private Map<String, String> nonPersistentFileAttributes;
    protected boolean isEmpty = true;

    public CommonFileGroup(DataCache dataCache, String string, boolean bl) {
        super(dataCache, bl);
        if (string != null) {
            this.dataFile = String.valueOf(dataCache.getParameters().getLocation()) + File.separatorChar + string + ".dat";
            this.indexFile = String.valueOf(dataCache.getParameters().getLocation()) + File.separatorChar + string + ".idx";
            new File(this.indexFile).getParentFile().mkdirs();
            this.deleted = new HashMap<String, long[]>();
            this.toCommit = new HashMap<String, long[]>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemMembers() {
        String[] stringArray;
        Map<String, long[]> map;
        Map<String, long[]> map2 = map = this.getIndex();
        synchronized (map2) {
            stringArray = new String[map.size()];
            int n = 0;
            for (String string : map.keySet()) {
                stringArray[n++] = string;
            }
        }
        return stringArray;
    }

    private void initIndex() {
        this.index = Collections.synchronizedMap(new HashMap());
        File file = new File(this.indexFile);
        if (!file.exists()) {
            return;
        }
        try {
            String string;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
            this.appendPos = new File(this.dataFile).length();
            while ((string = dataInputStream.readLine()) != null) {
                this.index.put(string, new long[]{dataInputStream.readLong(), dataInputStream.readLong()});
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            file.delete();
            new File(this.dataFile).delete();
            this.index.clear();
            this.deleted.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIndexEntry(String string, long[] lArray) {
        Map<String, long[]> map;
        Map<String, long[]> map2 = map = this.getIndex();
        synchronized (map2) {
            if (this.groupState != FileGroupState.EMPTIED) {
                if (map.put(string, lArray) == null) {
                    this.deleted.put(string, map.remove(string));
                }
            } else {
                this.deleted.put(string, lArray);
            }
            this.toCommit.put(string, lArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean persistentItemExists(CacheID cacheID) {
        String string = this.getItemID(cacheID);
        Map<String, long[]> map = this.getIndex();
        Object object = map;
        synchronized (object) {
            if (map.containsKey(string)) {
                return true;
            }
        }
        object = this;
        synchronized (object) {
            Map<String, long[]> map2 = map;
            synchronized (map2) {
                if (map.containsKey(string)) {
                    return true;
                }
                if (this.groupState != FileGroupState.OPEN) {
                    try {
                        this.openGroup(true);
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Unable to open group", (Throwable)iOException);
                    }
                }
                return this.deleted.containsKey(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePersistent(Object object, CacheID cacheID) throws IOException {
        String string = this.getItemID(cacheID);
        if (this.groupState != FileGroupState.OPEN) {
            Map<String, long[]> map = this.getIndex();
            synchronized (map) {
                this.openGroup(false);
            }
        }
        long l = this.appendPos;
        long[] lArray = this.writeItem(object, l, cacheID);
        this.appendPos = lArray[1];
        this.addIndexEntry(string, lArray);
        if (this.groupState == FileGroupState.EMPTIED) {
            this.closeGroup(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readPersistent(CacheID cacheID, Object object) throws IOException {
        Object object2;
        if (this.groupState != FileGroupState.OPEN) {
            object2 = this.getIndex();
            synchronized (object2) {
                this.openGroup(true);
            }
        }
        object2 = this.getPosFromIndex(cacheID);
        Object object3 = object2[0];
        Object object4 = this.readItem((long)object3, (long)(object2[1] - object3));
        return object4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeGroup(boolean bl) throws IOException {
        Map<String, long[]> map = this.getIndex();
        synchronized (map) {
            if (bl && this.groupState != FileGroupState.EMPTIED) {
                return;
            }
            if (this.groupState != FileGroupState.CLOSED) {
                this.closeDataFile();
                this.commitIndex();
                if (this.groupState == FileGroupState.OPEN) {
                    this.groupState = FileGroupState.CLOSED;
                }
            }
        }
    }

    protected void openGroup(boolean bl) throws IOException {
        if (this.groupState != FileGroupState.OPEN) {
            File file = new File(this.indexFile);
            if (!file.exists()) {
                this.deleted.clear();
            }
            if (this.groupState == FileGroupState.CLOSED || this.groupState == FileGroupState.EMPTIED && !this.getIndex().isEmpty() || bl) {
                this.groupState = FileGroupState.OPEN;
            }
            this.appendPos = this.openDataFile();
        }
    }

    protected abstract long openDataFile() throws IOException;

    protected abstract void closeDataFile() throws IOException;

    private void commitIndex() throws IOException {
        DataOutputStream dataOutputStream;
        if (this.toCommit.isEmpty()) {
            return;
        }
        File file = new File(this.indexFile);
        try {
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND)));
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            file.getParentFile().mkdirs();
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND)));
        }
        for (Map.Entry<String, long[]> entry : this.toCommit.entrySet()) {
            dataOutputStream.writeBytes(String.valueOf(entry.getKey()) + "\n");
            long[] lArray = entry.getValue();
            dataOutputStream.writeLong(lArray[0]);
            dataOutputStream.writeLong(lArray[1]);
        }
        this.toCommit.clear();
        dataOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromDisk(CacheItem cacheItem, boolean bl) {
        Map<String, long[]> map;
        String string = cacheItem.getID().toString();
        int n = string.lastIndexOf(File.separatorChar);
        String string2 = n >= 0 ? string.substring(n + 1) : string;
        this.dataCache.getOnDisk().removeFromList(cacheItem);
        Map<String, long[]> map2 = map = this.getIndex();
        synchronized (map2) {
            long[] lArray = map.remove(string2);
            if (lArray != ADDED && lArray != null) {
                this.deleted.put(string2, lArray);
            }
        }
        if (map.size() == 0) {
            this.groupEmptied();
            this.dataCache.getOnDisk().setDeleteOccured();
        }
    }

    protected void groupEmptied() {
        this.groupState = FileGroupState.EMPTIED;
    }

    public abstract Object readItem(long var1, long var3) throws IOException;

    public abstract long[] writeItem(Object var1, long var2, CacheID var4) throws IOException;

    @Override
    public synchronized void dispose() {
        try {
            this.closeGroup(false);
        }
        catch (IOException iOException) {
            LOGGER.error("Unable to close group", (Throwable)iOException);
        }
        if (!this.dataCache.getParameters().isPermanent()) {
            File file = new File(this.dataFile);
            file.delete();
            new File(this.indexFile).delete();
            file.getParentFile().delete();
            this.deleted.clear();
            this.destroyed = true;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isEmpty() {
        return this.getIndex().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getPosFromIndex(CacheID cacheID) {
        long[] lArray;
        Map<String, long[]> map;
        String string = this.getItemID(cacheID);
        Map<String, long[]> map2 = map = this.getIndex();
        synchronized (map2) {
            lArray = map.get(string);
            if (lArray == null && (lArray = this.deleted.remove(string)) != null) {
                map.put(string, lArray);
            }
        }
        if (lArray == null) {
            throw new IllegalStateException("item " + cacheID + " not on disk");
        }
        return lArray;
    }

    protected String getItemID(CacheID cacheID) {
        String string = cacheID.toString();
        int n = string.lastIndexOf(File.separatorChar);
        return n >= 0 ? string.substring(n + 1) : string;
    }

    @Override
    public synchronized void flush() {
        if (this.getIndex() == null) {
            return;
        }
        super.flush();
        try {
            this.closeGroup(false);
        }
        catch (IOException iOException) {
            LOGGER.error("Unable to close group", (Throwable)iOException);
        }
    }

    @Override
    public String getPersistentLocation(CacheID cacheID) {
        return this.dataFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, long[]> getIndex() {
        if (this.indexFile == null) {
            return null;
        }
        if (this.index == null) {
            CommonFileGroup commonFileGroup = this;
            synchronized (commonFileGroup) {
                if (this.index == null) {
                    this.initIndex();
                }
            }
        }
        return this.index;
    }

    @Override
    public CacheItem createItem(Object object, CacheID cacheID, int n) {
        return super.createItem(object, cacheID, n);
    }

    protected synchronized void playbackTempFileAttributes() throws IOException {
        if (!this.dataCache.arePersistentGroupAttributesSupported()) {
            return;
        }
        Map<String, String> map = this.nonPersistentFileAttributes;
        this.nonPersistentFileAttributes = null;
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (string2 != null) {
                    this.setGroupAttribute(string, string2);
                    continue;
                }
                this.deleteGroupAttribute(string);
            }
        }
    }

    @Override
    public synchronized String getGroupAttribute(String string) throws IOException {
        UserDefinedFileAttributeView userDefinedFileAttributeView = this.getUserDefinedAttributesView(this.dataFile);
        if (userDefinedFileAttributeView != null) {
            int n = userDefinedFileAttributeView.size(string);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
            userDefinedFileAttributeView.read(string, byteBuffer);
            byteBuffer.flip();
            return Charset.defaultCharset().decode(byteBuffer).toString();
        }
        if (this.nonPersistentFileAttributes != null) {
            return this.nonPersistentFileAttributes.get(string);
        }
        return null;
    }

    @Override
    public synchronized void setGroupAttribute(String string, String string2) throws IOException {
        UserDefinedFileAttributeView userDefinedFileAttributeView = this.getUserDefinedAttributesView(this.dataFile);
        if (userDefinedFileAttributeView != null) {
            userDefinedFileAttributeView.write(string, Charset.defaultCharset().encode(string2));
        } else {
            if (this.nonPersistentFileAttributes == null) {
                this.nonPersistentFileAttributes = new HashMap<String, String>();
            }
            this.nonPersistentFileAttributes.put(string, string2);
        }
    }

    @Override
    public synchronized void deleteGroupAttribute(String string) throws IOException {
        UserDefinedFileAttributeView userDefinedFileAttributeView = this.getUserDefinedAttributesView(this.dataFile);
        if (userDefinedFileAttributeView != null) {
            userDefinedFileAttributeView.delete(string);
        } else {
            if (this.nonPersistentFileAttributes == null) {
                this.nonPersistentFileAttributes = new HashMap<String, String>();
            }
            this.nonPersistentFileAttributes.put(string, null);
        }
        if (string.equals("GroupState")) {
            this.isEmpty = true;
        }
    }

    private UserDefinedFileAttributeView getUserDefinedAttributesView(String string) throws IOException {
        if (!this.dataCache.arePersistentGroupAttributesSupported()) {
            return null;
        }
        Path path = Paths.get(string, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(this.dataFile);
        if (file.exists()) {
            stringBuffer.append("data file " + this.dataFile + " exists, size=" + file.length() + "\n");
        } else {
            stringBuffer.append("data file " + this.dataFile + " not on disk\n");
        }
        File file2 = new File(this.indexFile);
        if (file2.exists()) {
            stringBuffer.append("index file " + this.indexFile + " exists, size=" + file2.length() + "\n");
        } else {
            stringBuffer.append("index file " + this.indexFile + " not on disk\n");
        }
        stringBuffer.append("append position:" + this.appendPos + "\n");
        stringBuffer.append("destroyed=" + this.destroyed + "\n");
        stringBuffer.append("groupState=" + (Object)((Object)this.groupState) + "\n");
        stringBuffer.append("isEmpty=" + this.isEmpty + "\n");
        Map<String, long[]> map = this.getIndex();
        synchronized (map) {
            long[] lArray;
            stringBuffer.append("index map:\n");
            for (Map.Entry<String, long[]> entry : this.index.entrySet()) {
                lArray = entry.getValue();
                if (lArray == ADDED) {
                    stringBuffer.append(String.valueOf(entry.getKey()) + "->ADDED\n");
                    continue;
                }
                stringBuffer.append(String.valueOf(entry.getKey()) + "->" + lArray[0] + "," + lArray[1] + "\n");
            }
            stringBuffer.append("deleted map:\n");
            for (Map.Entry<String, long[]> entry : this.deleted.entrySet()) {
                lArray = entry.getValue();
                if (lArray == ADDED) {
                    stringBuffer.append(String.valueOf(entry.getKey()) + "->ADDED\n");
                    continue;
                }
                stringBuffer.append(String.valueOf(entry.getKey()) + "->" + lArray[0] + "," + lArray[1] + "\n");
            }
            stringBuffer.append("toCommit map:\n");
            for (Map.Entry<String, long[]> entry : this.toCommit.entrySet()) {
                lArray = entry.getValue();
                if (lArray == ADDED) {
                    stringBuffer.append(String.valueOf(entry.getKey()) + "->ADDED\n");
                    continue;
                }
                stringBuffer.append(String.valueOf(entry.getKey()) + "->" + lArray[0] + "," + lArray[1] + "\n");
            }
        }
        return stringBuffer.toString();
    }

    protected static enum FileGroupState {
        CLOSED,
        OPEN,
        EMPTIED;

    }
}

