/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.cache.BlockedShortArray;
import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.GrouplessID;
import com.agfa.pacs.cache.ICacheItemGroup;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.cache.MemoryAlertHandler;
import com.agfa.pacs.cache.NoHandlerForObjectException;
import com.agfa.pacs.cache.ShortArrayContainer;
import com.agfa.pacs.core.ExtensionRecord;
import com.agfa.pacs.instrumentation.IInstrumentor;
import com.agfa.pacs.instrumentation.InstrumentorFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CacheItemGroup;
import com.agfa.pacs.memcache.CacheParameters;
import com.agfa.pacs.memcache.CachedObjectHandlerFactory;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ICachedObjectHandler;
import com.agfa.pacs.memcache.IPersistenceQueue;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.blocked.BlockedShortArrayHandler;
import com.agfa.pacs.memcache.blocked.ByteArrayContainerHandler;
import com.agfa.pacs.memcache.blocked.ShortArrayContainerHandler;
import com.agfa.pacs.memcache.internal.ByteArrayHandler;
import com.agfa.pacs.memcache.internal.CachedByteGroup;
import com.agfa.pacs.memcache.internal.CachedShortGroup;
import com.agfa.pacs.memcache.internal.DiskItemsHash;
import com.agfa.pacs.memcache.internal.DoubleArrayHandler;
import com.agfa.pacs.memcache.internal.FloatArrayHandler;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import com.agfa.pacs.memcache.internal.GroupHash;
import com.agfa.pacs.memcache.internal.IntArrayHandler;
import com.agfa.pacs.memcache.internal.PoolGuard;
import com.agfa.pacs.memcache.internal.ShortArrayHandler;
import com.agfa.pacs.tools.ComputerName;
import gnu.java.util.WeakIdentityHashMap;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Level;

public class DataCache
implements IDataCacheProvider {
    private static final ALogger LOGGER = ALogger.getLogger(DataCache.class);
    private static final CacheID ANONYMOUS_ID = new CacheID("", -1);
    private final String tokenPrefix;
    private final AtomicLong personalizedToken = new AtomicLong();
    private final Map<Object, CacheID> itemsInside;
    private final Map<Object, CacheID> itemsOutside;
    private final HashMap<Object, Object> handlers = new HashMap<Object, Object>(){

        @Override
        public synchronized ICachedObjectHandler get(Object object) {
            Class clazz = (Class)object;
            ICachedObjectHandler iCachedObjectHandler = (ICachedObjectHandler)super.get(clazz);
            if (iCachedObjectHandler != null) {
                return iCachedObjectHandler;
            }
            ExtensionRecord extensionRecord = (ExtensionRecord)super.remove(clazz.getName());
            if (extensionRecord != null) {
                iCachedObjectHandler = (ICachedObjectHandler)extensionRecord.createExtension();
                iCachedObjectHandler.init(DataCache.this);
                super.put(clazz, iCachedObjectHandler);
                return iCachedObjectHandler;
            }
            return null;
        }
    };
    private final GroupHash groups = new GroupHash(this);
    private final GlobalLRU globalLRU = new GlobalLRU();
    private final IPersistenceQueue persistenceQueue = new ImpaxEEPersistenceQueue();
    private final DiskItemsHash onDisk;
    private final CacheParameters cacheParameters;
    private PoolGuard poolGuard;
    private OutputStream instanceFileLock;
    private final boolean arePersistentGroupAttributesSupported;

    public DataCache() {
        this.tokenPrefix = "@" + ComputerName.getComputerId() + "@" + System.currentTimeMillis() + "@";
        DataCache.persistenceModifiers[0] = String.valueOf(this.tokenPrefix) + persistenceModifiers[0];
        this.cacheParameters = new CacheParameters();
        if (this.cacheParameters.usePersistentStorage()) {
            File file = new File(this.cacheParameters.getLockDirectoryPath());
            if (!file.mkdirs() && !file.exists()) {
                LOGGER.error("Couldn't create directory for filelock: " + this.cacheParameters.getLockDirectoryPath());
            }
            try {
                this.instanceFileLock = Files.newOutputStream(Paths.get(file.getAbsolutePath(), this.tokenPrefix), new OpenOption[0]);
            }
            catch (IOException iOException) {
                LOGGER.error("cache readonly", (Throwable)iOException);
                throw new RuntimeException("CACHE READONLY");
            }
            boolean bl = false;
            try {
                FileStore fileStore = Files.getFileStore(Paths.get(this.cacheParameters.getLocation(), new String[0]));
                bl = fileStore.supportsFileAttributeView(UserDefinedFileAttributeView.class);
                if (!bl) {
                    LOGGER.warn("UserDefinedFileAttributeView is not supported on '{}'. CacheGroup attributes will not be persisted.", (Object)fileStore);
                }
            }
            catch (IOException iOException) {
                LOGGER.error("Error while trying to determine FileStore of DataCache directory", (Throwable)iOException);
            }
            this.arePersistentGroupAttributesSupported = bl;
        } else {
            this.arePersistentGroupAttributesSupported = false;
        }
        this.onDisk = new DiskItemsHash(this, this.tokenPrefix);
        this.handlers.put(byte[].class, new ByteArrayHandler(this));
        this.handlers.put(short[].class, new ShortArrayHandler(this));
        this.handlers.put(float[].class, new FloatArrayHandler(this));
        this.handlers.put(double[].class, new DoubleArrayHandler(this));
        this.handlers.put(int[].class, new IntArrayHandler(this));
        this.handlers.put(ShortArrayContainer.class, new ShortArrayContainerHandler(this));
        this.handlers.put(BlockedShortArray.class, new BlockedShortArrayHandler(this));
        this.handlers.put(ByteArrayContainer.class, new ByteArrayContainerHandler(this));
        this.registerHandlers();
        this.startPoolGuardThread();
        this.itemsInside = Collections.synchronizedMap(new WeakIdentityHashMap());
        this.itemsOutside = Collections.synchronizedMap(new WeakIdentityHashMap());
    }

    private void startPoolGuardThread() {
        this.poolGuard = new PoolGuard(this);
        if (!this.cacheParameters.isSlowCacheWriting()) {
            this.poolGuard.start();
        }
    }

    private void registerHandlers() {
        List<ExtensionRecord> list = CachedObjectHandlerFactory.getHandlers();
        for (ExtensionRecord extensionRecord : list) {
            this.handlers.put(extensionRecord.getAttribute("handledClass"), extensionRecord);
        }
    }

    public GlobalLRU getGlobalLRU() {
        return this.globalLRU;
    }

    public DiskItemsHash getOnDisk() {
        return this.onDisk;
    }

    public File getFile(CacheID cacheID, Class<?> clazz) {
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem == null) {
            cacheItem = this.onDisk.getItem(cacheID, clazz, this);
        }
        return cacheItem == null ? null : new File(cacheItem.getPersistenceGroup().getPersistentLocation(cacheID));
    }

    public CacheParameters getParameters() {
        return this.cacheParameters;
    }

    public boolean arePersistentGroupAttributesSupported() {
        return this.arePersistentGroupAttributesSupported;
    }

    public GrouplessID createID() {
        return new GrouplessID(String.valueOf(persistenceModifiers[0]) + File.separatorChar + Long.toString(this.personalizedToken.getAndIncrement()));
    }

    public GrouplessID createNewTemporaryCacheID() {
        return this.createID();
    }

    public CacheID createID(String string, String string2, int n) {
        if (string != null && string.indexOf(58) >= 0) {
            string = string.replace(':', '_');
        }
        if (n == 2) {
            return new CacheID(String.valueOf(persistenceModifiers[n]) + File.separatorChar + string + File.separatorChar + string2, 2);
        }
        if (n == 0) {
            string = String.valueOf(string) + "_temp";
        }
        if (this.cacheParameters.isPermanent()) {
            return new CacheID(String.valueOf(persistenceModifiers[n]) + File.separatorChar + string + File.separatorChar + string2, n);
        }
        if (n == 1) {
            n = 0;
        }
        StringBuilder stringBuilder = new StringBuilder(180);
        stringBuilder.append(persistenceModifiers[n]).append(File.separatorChar);
        stringBuilder.append(string).append(File.separatorChar);
        stringBuilder.append(string2);
        return new CacheID(stringBuilder.toString(), n);
    }

    public byte[] allocBytes(long l) {
        return this.allocBytes(l, 30);
    }

    public byte[] allocBytes(long l, int n) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getByteGroup(l);
        byte[] byArray = (byte[])iCachedObjectGroup.allocateObject(false, n);
        if (this.itemsOutside.put(byArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(byArray));
        }
        this.itemsInside.remove(byArray);
        return byArray;
    }

    public byte[] allocAndClearBytes(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getByteGroup(l);
        byte[] byArray = (byte[])iCachedObjectGroup.allocateObject(true, 30);
        if (this.itemsOutside.put(byArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(byArray));
        }
        this.itemsInside.remove(byArray);
        return byArray;
    }

    public void free(byte[] byArray) {
        this.itemsOutside.remove(byArray);
        if (this.itemsInside.put(byArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(byArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getByteGroup(byArray.length);
        iCachedObjectGroup.free(byArray);
    }

    public byte[] getContentBytes(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.consumeSynced(cacheID);
        if (cacheItem == null) {
            return null;
        }
        cacheItem.removeFromGroupUnsynced();
        byte[] byArray = (byte[])cacheItem.claimItemSynced();
        if (this.itemsOutside.remove(byArray) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.remove(byArray);
        return byArray;
    }

    public byte[] referencePersistentBytes(CacheID cacheID) {
        byte[] byArray;
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem != null) {
            byArray = (byte[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        } else {
            cacheItem = this.onDisk.getItem(cacheID, byte[].class, this);
            if (cacheItem == null) {
                throw new IllegalArgumentException("id not known to cache " + cacheID);
            }
            byArray = (byte[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        }
        CacheID cacheID2 = this.itemsOutside.put(byArray, cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.put(byArray, cacheID);
        return byArray;
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID) {
        this.putContentBytes(byArray, cacheID, 30);
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID, int n) {
        this.itemsOutside.remove(byArray);
        if (this.itemsInside.put(byArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getByteGroup(byArray.length);
        iCachedObjectGroup.putPersonalized(byArray, cacheID, n);
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID) {
        this.addPersistentBytes(byArray, cacheID, 30);
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID, int n) {
        CacheID cacheID2 = this.itemsOutside.remove(byArray);
        if (cacheID2 != null && cacheID2 != ANONYMOUS_ID && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + cacheID2 + " and not " + cacheID);
        }
        if (this.itemsInside.put(byArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getByteGroup(byArray.length);
        iCachedObjectGroup.addPersistent(byArray, cacheID, n);
    }

    public void releaseModifiedReference(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem == null) {
            throw new IllegalStateException("reference count underrun for " + cacheID);
        }
        this.itemsOutside.remove(cacheItem.getItemUnsynced());
        cacheItem.updateAndReleaseReferenceSynced();
        cacheItem.touch();
        this.persistenceQueue.addAtBottom(cacheItem);
    }

    public short[] allocShorts(long l) {
        return this.allocShorts(l, 30);
    }

    public short[] allocShorts(long l, int n) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getShortGroup(l);
        short[] sArray = (short[])iCachedObjectGroup.allocateObject(false, n);
        if (this.itemsOutside.put(sArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(sArray));
        }
        this.itemsInside.remove(sArray);
        return sArray;
    }

    public short[] allocAndClearShorts(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getShortGroup(l);
        short[] sArray = (short[])iCachedObjectGroup.allocateObject(true, 30);
        if (this.itemsOutside.put(sArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(sArray));
        }
        this.itemsInside.remove(sArray);
        return sArray;
    }

    public void free(short[] sArray) {
        this.itemsOutside.remove(sArray);
        if (this.itemsInside.put(sArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(sArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getShortGroup(sArray.length);
        iCachedObjectGroup.free(sArray);
    }

    public short[] getContentShorts(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.consumeSynced(cacheID);
        if (cacheItem == null) {
            return null;
        }
        cacheItem.removeFromGroupUnsynced();
        short[] sArray = (short[])cacheItem.claimItemSynced();
        if (this.itemsOutside.remove(sArray) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.remove(sArray);
        return sArray;
    }

    public short[] referencePersistentShorts(CacheID cacheID) {
        short[] sArray;
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem != null) {
            sArray = (short[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        } else {
            cacheItem = this.onDisk.getItem(cacheID, short[].class, this);
            if (cacheItem == null) {
                throw new IllegalArgumentException();
            }
            sArray = (short[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        }
        CacheID cacheID2 = this.itemsOutside.put(sArray, cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.put(sArray, cacheID);
        return sArray;
    }

    public void putContentShorts(short[] sArray, CacheID cacheID) {
        this.putContentShorts(sArray, cacheID, 30);
    }

    public void putContentShorts(short[] sArray, CacheID cacheID, int n) {
        this.itemsOutside.remove(sArray);
        if (this.itemsInside.put(sArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getShortGroup(sArray.length);
        iCachedObjectGroup.putPersonalized(sArray, cacheID, n);
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID) {
        this.addPersistentShorts(sArray, cacheID, 30);
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID, int n) {
        CacheID cacheID2 = this.itemsOutside.remove(sArray);
        if (cacheID2 != null && cacheID2 != ANONYMOUS_ID && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + cacheID2 + " and not " + cacheID);
        }
        if (this.itemsInside.put(sArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getShortGroup(sArray.length);
        iCachedObjectGroup.addPersistent(sArray, cacheID, n);
    }

    public int[] allocInts(long l) {
        return this.allocInts(l, 30);
    }

    public int[] allocInts(long l, int n) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getIntGroup(l);
        int[] nArray = (int[])iCachedObjectGroup.allocateObject(false, n);
        if (this.itemsOutside.put(nArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(nArray));
        }
        this.itemsInside.remove(nArray);
        return nArray;
    }

    public int[] allocAndClearInts(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getIntGroup(l);
        int[] nArray = (int[])iCachedObjectGroup.allocateObject(true, 30);
        if (this.itemsOutside.put(nArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(nArray));
        }
        this.itemsInside.remove(nArray);
        return nArray;
    }

    public void free(int[] nArray) {
        this.itemsOutside.remove(nArray);
        if (this.itemsInside.put(nArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(nArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getIntGroup(nArray.length);
        iCachedObjectGroup.free(nArray);
    }

    public int[] getContentInts(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.consumeSynced(cacheID);
        if (cacheItem == null) {
            return null;
        }
        cacheItem.removeFromGroupUnsynced();
        int[] nArray = (int[])cacheItem.claimItemSynced();
        if (this.itemsOutside.remove(nArray) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.remove(nArray);
        return nArray;
    }

    public int[] referencePersistentInts(CacheID cacheID) {
        int[] nArray;
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem != null) {
            nArray = (int[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        } else {
            cacheItem = this.onDisk.getItem(cacheID, int[].class, this);
            if (cacheItem == null) {
                throw new IllegalArgumentException();
            }
            nArray = (int[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        }
        CacheID cacheID2 = this.itemsOutside.put(nArray, cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.put(nArray, cacheID);
        return nArray;
    }

    public void putContentInts(int[] nArray, CacheID cacheID) {
        this.putContentInts(nArray, cacheID, 30);
    }

    public void putContentInts(int[] nArray, CacheID cacheID, int n) {
        this.itemsOutside.remove(nArray);
        if (this.itemsInside.put(nArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getIntGroup(nArray.length);
        iCachedObjectGroup.putPersonalized(nArray, cacheID, n);
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID) {
        this.addPersistentInts(nArray, cacheID, 30);
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID, int n) {
        CacheID cacheID2 = this.itemsOutside.remove(nArray);
        if (cacheID2 != null && cacheID2 != ANONYMOUS_ID && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + cacheID2 + " and not " + cacheID);
        }
        if (this.itemsInside.put(nArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getIntGroup(nArray.length);
        iCachedObjectGroup.addPersistent(nArray, cacheID, n);
    }

    public float[] allocFloats(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getFloatGroup(l);
        float[] fArray = (float[])iCachedObjectGroup.allocateObject(false, 30);
        if (this.itemsOutside.put(fArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(fArray));
        }
        this.itemsInside.remove(fArray);
        return fArray;
    }

    public float[] allocAndClearFloats(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getFloatGroup(l);
        float[] fArray = (float[])iCachedObjectGroup.allocateObject(true, 30);
        if (this.itemsOutside.put(fArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(fArray));
        }
        this.itemsInside.remove(fArray);
        return fArray;
    }

    public void free(float[] fArray) {
        this.itemsOutside.remove(fArray);
        if (this.itemsInside.put(fArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(fArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getFloatGroup(fArray.length);
        iCachedObjectGroup.free(fArray);
    }

    public float[] getContentFloats(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.consumeSynced(cacheID);
        if (cacheItem == null) {
            return null;
        }
        cacheItem.removeFromGroupUnsynced();
        float[] fArray = (float[])cacheItem.claimItemSynced();
        if (this.itemsOutside.remove(fArray) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.remove(fArray);
        return fArray;
    }

    public float[] referencePersistentFloats(CacheID cacheID) {
        float[] fArray;
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem != null) {
            fArray = (float[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        } else {
            cacheItem = this.onDisk.getItem(cacheID, float[].class, this);
            if (cacheItem == null) {
                throw new IllegalArgumentException();
            }
            fArray = (float[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        }
        CacheID cacheID2 = this.itemsOutside.put(fArray, cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.put(fArray, cacheID);
        return fArray;
    }

    public void putContentFloats(float[] fArray, CacheID cacheID) {
        this.itemsOutside.remove(fArray);
        if (this.itemsInside.put(fArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getFloatGroup(fArray.length);
        iCachedObjectGroup.putPersonalized(fArray, cacheID, 30);
    }

    public void addPersistentFloats(float[] fArray, CacheID cacheID) {
        CacheID cacheID2 = this.itemsOutside.remove(fArray);
        if (cacheID2 != null && cacheID2 != ANONYMOUS_ID && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + cacheID2 + " and not " + cacheID);
        }
        if (this.itemsInside.put(fArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getFloatGroup(fArray.length);
        iCachedObjectGroup.addPersistent(fArray, cacheID, 30);
    }

    public double[] allocDoubles(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getDoubleGroup(l);
        double[] dArray = (double[])iCachedObjectGroup.allocateObject(false, 30);
        if (this.itemsOutside.put(dArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(dArray));
        }
        this.itemsInside.remove(dArray);
        return dArray;
    }

    public double[] allocAndClearDoubles(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getDoubleGroup(l);
        double[] dArray = (double[])iCachedObjectGroup.allocateObject(true, 30);
        if (this.itemsOutside.put(dArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + System.identityHashCode(dArray));
        }
        this.itemsInside.remove(dArray);
        return dArray;
    }

    public void free(double[] dArray) {
        this.itemsOutside.remove(dArray);
        if (this.itemsInside.put(dArray, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + System.identityHashCode(dArray));
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getDoubleGroup(dArray.length);
        iCachedObjectGroup.free(dArray);
    }

    public double[] getContentDoubles(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.consumeSynced(cacheID);
        if (cacheItem == null) {
            return null;
        }
        cacheItem.removeFromGroupUnsynced();
        double[] dArray = (double[])cacheItem.claimItemSynced();
        if (this.itemsOutside.remove(dArray) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.remove(dArray);
        return dArray;
    }

    public double[] referencePersistentDoubles(CacheID cacheID) {
        double[] dArray;
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem != null) {
            dArray = (double[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        } else {
            cacheItem = this.onDisk.getItem(cacheID, double[].class, this);
            if (cacheItem == null) {
                throw new IllegalArgumentException();
            }
            dArray = (double[])cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        }
        CacheID cacheID2 = this.itemsOutside.put(dArray, cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.put(dArray, cacheID);
        return dArray;
    }

    public void putContentDoubles(double[] dArray, CacheID cacheID) {
        this.itemsOutside.remove(dArray);
        if (this.itemsInside.put(dArray, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getDoubleGroup(dArray.length);
        iCachedObjectGroup.putPersonalized(dArray, cacheID, 30);
    }

    public void addPersistentDoubles(double[] dArray, CacheID cacheID) {
        CacheID cacheID2 = this.itemsOutside.remove(dArray);
        if (cacheID2 != null && cacheID2 != ANONYMOUS_ID && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + cacheID2 + " and not " + cacheID);
        }
        if (this.itemsInside.put(dArray, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        ICachedObjectGroup iCachedObjectGroup = this.groups.getDoubleGroup(dArray.length);
        iCachedObjectGroup.addPersistent(dArray, cacheID, 30);
    }

    public Object allocObject(Class<?> clazz, Object[] objectArray) {
        return this.allocObjectInternal(clazz, objectArray, false);
    }

    public Object allocAndClearObject(Class<?> clazz, Object[] objectArray) {
        return this.allocObjectInternal(clazz, objectArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object allocObjectInternal(Class<?> clazz, Object[] objectArray, boolean bl) {
        ICachedObjectGroup iCachedObjectGroup;
        ICachedObjectHandler iCachedObjectHandler = this.findHandler(clazz);
        Object object = iCachedObjectHandler.getGroupID(objectArray);
        Object object2 = this.groups;
        synchronized (object2) {
            iCachedObjectGroup = (ICachedObjectGroup)this.groups.get(object);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = iCachedObjectHandler.createGroup(object, objectArray);
                this.groups.put(object, iCachedObjectGroup);
            }
        }
        object2 = iCachedObjectGroup.allocateObject(bl, objectArray, 30);
        if (this.itemsOutside.put(object2, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice " + object2);
        }
        this.itemsInside.remove(object2);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Object object) {
        ICachedObjectGroup iCachedObjectGroup;
        this.itemsOutside.remove(object);
        if (this.itemsInside.put(object, ANONYMOUS_ID) != null) {
            throw new IllegalStateException("returned object to cache multiple times: " + object);
        }
        ICachedObjectHandler iCachedObjectHandler = this.findHandler(object.getClass());
        Object object2 = iCachedObjectHandler.getGroupID(null, object);
        if (object2 == null) {
            return;
        }
        GroupHash groupHash = this.groups;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.groups.get(object2);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = iCachedObjectHandler.createGroup(object2, object);
                this.groups.put(object2, iCachedObjectGroup);
            }
        }
        iCachedObjectGroup.free(object);
    }

    ICachedObjectHandler findHandler(Class<?> clazz) {
        ICachedObjectHandler iCachedObjectHandler = (ICachedObjectHandler)this.handlers.get(clazz);
        if (iCachedObjectHandler != null) {
            return iCachedObjectHandler;
        }
        iCachedObjectHandler = this.findHandlerForInterfaces(clazz);
        if (iCachedObjectHandler != null) {
            return iCachedObjectHandler;
        }
        if ((clazz = clazz.getSuperclass()) != null) {
            return this.findHandler(clazz);
        }
        throw new NoHandlerForObjectException();
    }

    private ICachedObjectHandler findHandlerForInterfaces(Class<?> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz2 = classArray[n2];
            ICachedObjectHandler iCachedObjectHandler = (ICachedObjectHandler)this.handlers.get(clazz2);
            if (iCachedObjectHandler != null) {
                return iCachedObjectHandler;
            }
            iCachedObjectHandler = this.findHandlerForInterfaces(clazz2);
            if (iCachedObjectHandler != null) {
                return iCachedObjectHandler;
            }
            ++n2;
        }
        return null;
    }

    public Object getContentObject(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.consumeSynced(cacheID);
        if (cacheItem == null) {
            return null;
        }
        cacheItem.removeFromGroupUnsynced();
        Object object = cacheItem.claimItemSynced();
        if (this.itemsOutside.remove(object) != null) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.remove(object);
        return object;
    }

    public Object referencePersistentObject(CacheID cacheID, Class<?> clazz) {
        Object object;
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem != null) {
            object = cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        } else {
            cacheItem = this.onDisk.getItem(cacheID, clazz, this);
            if (cacheItem == null) {
                if (this.findHandler(clazz) == null) {
                    throw new NoHandlerForObjectException();
                }
                throw new IllegalArgumentException("Item " + cacheID + " of type " + clazz + " not found in memory or on disk!");
            }
            object = cacheItem.getPersistenceGroup().getPersistent(cacheItem, cacheID);
        }
        CacheID cacheID2 = this.itemsOutside.put(object, cacheID);
        if (cacheID2 != null && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("critical cache error: cache issued object twice; id = " + cacheID);
        }
        this.itemsInside.put(object, cacheID);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContentObject(Object object, CacheID cacheID) {
        ICachedObjectGroup iCachedObjectGroup;
        this.itemsOutside.remove(object);
        if (this.itemsInside.put(object, cacheID) != null) {
            throw new IllegalStateException("returned object to cache multiple times; id = " + cacheID);
        }
        ICachedObjectHandler iCachedObjectHandler = this.findHandler(object.getClass());
        Object object2 = iCachedObjectHandler.getGroupID(cacheID, object);
        if (object2 == null) {
            return;
        }
        GroupHash groupHash = this.groups;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.groups.get(object2);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = iCachedObjectHandler.createGroup(object2, object);
                this.groups.put(object2, iCachedObjectGroup);
            }
        }
        iCachedObjectGroup.putPersonalized(object, cacheID, 30);
    }

    public void addPersistentObject(Object object, CacheID cacheID) {
        this.addPersistentObject(object, object.getClass(), cacheID);
    }

    public void addPersistentObject(Object object, CacheID cacheID, int n) {
        this.addPersistentObject(object, object.getClass(), cacheID);
    }

    public void addPersistentObject(Object object, Class<?> clazz, CacheID cacheID) {
        this.addPersistentObject(object, clazz, cacheID, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPersistentObject(Object object, Class<?> clazz, CacheID cacheID, int n) {
        ICachedObjectGroup iCachedObjectGroup;
        CacheID cacheID2 = this.itemsOutside.remove(object);
        if (cacheID2 != null && cacheID2 != ANONYMOUS_ID && !cacheID2.equals((Object)cacheID)) {
            throw new IllegalStateException("object associated with id " + cacheID2 + " and not " + cacheID);
        }
        if (this.itemsInside.put(object, cacheID) != null) {
            throw new IllegalStateException("re-entering object into cache " + cacheID);
        }
        ICachedObjectHandler iCachedObjectHandler = this.findHandler(clazz);
        Object object2 = iCachedObjectHandler.getGroupID(cacheID, object);
        if (object2 == null) {
            return;
        }
        GroupHash groupHash = this.groups;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.groups.get(object2);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = iCachedObjectHandler.createGroup((Object)cacheID, object);
                this.groups.put(object2, iCachedObjectGroup);
            }
        }
        iCachedObjectGroup.addPersistent(object, cacheID, n);
    }

    public Iterator<ICacheItemGroup> listItemGroups() {
        List list = Collections.emptyList();
        this.globalLRU.lockForRead();
        try {
            Set<String> set = this.globalLRU.getGroupNames();
            set.addAll(Arrays.asList(this.onDisk.getGroupNames()));
            list = new ArrayList(set.size());
            for (String string : set) {
                list.add(new CacheItemGroup(string, this));
            }
        }
        finally {
            this.globalLRU.unlockForRead();
        }
        return list.iterator();
    }

    public void remove(CacheID cacheID) {
        this.globalLRU.runAsyncWithReadlock(new DelayedRemoveJob(cacheID));
    }

    public void remove(CacheID[] cacheIDArray) {
        this.globalLRU.runAsyncWithReadlock(new DelayedRemoveAllJob(cacheIDArray));
    }

    public void removeTemporary(GrouplessID grouplessID) {
        this.remove((CacheID)grouplessID);
    }

    public void flush(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem == null) {
            return;
        }
        cacheItem.writePersistent();
    }

    public void flushGroup(Class<?> clazz, CacheID cacheID) {
        ICachedObjectGroup iCachedObjectGroup = this.getGroupFor(clazz, cacheID, 0L, false);
        if (iCachedObjectGroup != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = iCachedObjectGroup.getItemMembers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                CacheItem cacheItem = this.globalLRU.get(this.createID(cacheID.getGroup(), string, cacheID.getType()));
                if (cacheItem != null) {
                    cacheItem.writePersistent();
                }
                ++n2;
            }
            iCachedObjectGroup.flush();
        }
    }

    public void releaseModifiedArrayReference(CacheID cacheID, long[] lArray, long[] lArray2) {
        this.releaseModifiedReference(cacheID);
    }

    public void ensureFreeMemory(long l) {
        this.globalLRU.dumpContent(false);
        if (l == -1L) {
            l = Long.MAX_VALUE;
        }
        if ((l -= this.cacheParameters.getFreeMem()) <= 0L) {
            return;
        }
        l = Math.max(2000000L, l);
        IInstrumentor iInstrumentor = InstrumentorFactory.getInstrumentor();
        String string = iInstrumentor.createTUID();
        iInstrumentor.recordStart(string, "ia_low_memory", "toFree=" + l, Level.WARN);
        try {
            l -= this.poolGuard.memoryAlert(l, false);
            if (l <= 0L) {
                return;
            }
            if ((l = MemoryAlertHandler.fireMemoryAlert((long)l, (boolean)false)) > 0L) {
                l = MemoryAlertHandler.fireMemoryAlert((long)l, (boolean)true);
            }
            if (l > 0L) {
                l = this.poolGuard.memoryAlert(l, true);
            }
        }
        finally {
            iInstrumentor.recordStop(string, "ia_low_memory", "toFree=" + l, Level.WARN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Class<?> clazz, CacheID cacheID) {
        boolean bl;
        if (cacheID == null) {
            return false;
        }
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem == null) {
            cacheItem = this.onDisk.getItem(cacheID, clazz, this);
        }
        boolean bl2 = bl = cacheItem != null;
        if (bl) {
            if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
                CacheItem cacheItem2 = cacheItem;
                synchronized (cacheItem2) {
                    block8: {
                        if (cacheItem.getUnsyncedState() != ItemState.DELETED) break block8;
                        cacheItem.removeUnsynced(false);
                        return false;
                    }
                    cacheItem.touch();
                }
            }
            cacheItem.touch();
        }
        return bl;
    }

    public boolean isInCache(Class<?> clazz, CacheID cacheID) {
        return this.exists(clazz, cacheID);
    }

    public boolean isInMemory(CacheID cacheID) {
        if (cacheID == null) {
            return false;
        }
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem == null) {
            return false;
        }
        return cacheItem.dataAvailableUnsynced();
    }

    public ICachedObjectGroup getGroupFor(Class<?> clazz, CacheID cacheID, long l) {
        return this.getGroupFor(clazz, cacheID, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICachedObjectGroup getGroupFor(Class<?> clazz, CacheID cacheID, long l, boolean bl) {
        ICachedObjectGroup iCachedObjectGroup;
        ICachedObjectHandler iCachedObjectHandler = this.findHandler(clazz);
        Object object = iCachedObjectHandler.getGroupID(cacheID, l);
        if (object == null) {
            return null;
        }
        GroupHash groupHash = this.groups;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.groups.get(object);
            if (iCachedObjectGroup == null && bl) {
                iCachedObjectGroup = iCachedObjectHandler.createGroup(cacheID, l);
                if (iCachedObjectGroup != null) {
                    this.groups.put(object, iCachedObjectGroup);
                }
            } else if (iCachedObjectGroup != null && iCachedObjectGroup.isDestroyed()) {
                throw new IllegalStateException();
            }
        }
        return iCachedObjectGroup;
    }

    public IPersistenceQueue getPersistenceQueue() {
        return this.persistenceQueue;
    }

    public void dumpByteGroup(long l, boolean bl) {
        ((CachedByteGroup)this.groups.get(Long.toString(Long.MIN_VALUE | l))).dumpContent(bl);
    }

    public void releaseReference(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem == null) {
            throw new IllegalStateException("reference count underrun " + cacheID);
        }
        this.itemsOutside.remove(cacheItem.getItemUnsynced());
        cacheItem.releaseReferenceSynced();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        this.poolGuard.writePersistentQueueContent(false);
        this.poolGuard.waitUntilPersistentFinished();
        GroupHash groupHash = this.groups;
        synchronized (groupHash) {
            for (ICachedObjectGroup iCachedObjectGroup : this.groups.values()) {
                iCachedObjectGroup.flush();
            }
        }
        this.onDisk.ensureDiskSize();
    }

    public void clearTempData() {
        this.onDisk.clearTempData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWriting() {
        this.poolGuard.shutdownWithoutWriting();
        GroupHash groupHash = this.groups;
        synchronized (groupHash) {
            for (ICachedObjectGroup iCachedObjectGroup : this.groups.values()) {
                iCachedObjectGroup.flush();
            }
        }
    }

    private void releaseCacheLock() {
        try {
            this.instanceFileLock.close();
        }
        catch (IOException iOException) {
            LOGGER.warn("Error while releasing the cache lock: ", (Throwable)iOException);
        }
    }

    public void deleteCache() {
        Object object;
        int n;
        this.releaseCacheLock();
        File file = new File(this.cacheParameters.getLockDirectoryPath());
        String[] stringArray = file.list();
        boolean bl = true;
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray2[n2];
                File file2 = new File(file, (String)object);
                bl = file2.delete();
                if (!bl) break;
                ++n2;
            }
        }
        if (bl) {
            StringBuilder stringBuilder;
            object = new File(this.cacheParameters.getLocation());
            n = DataCache.deleteDir((File)object, stringBuilder = new StringBuilder()) ? 1 : 0;
            if (n == 0) {
                LOGGER.warn("Some files / directories could not be deleted from the cache during application shutdown:\n" + stringBuilder.toString());
            } else {
                LOGGER.info("Cache was successfully deleted.");
            }
        } else {
            LOGGER.info("Cache was not deleted, because probably another instance of the Diagnostic Desktop is currently running!");
        }
    }

    private static boolean deleteDir(File file, StringBuilder stringBuilder) {
        boolean bl;
        File[] fileArray;
        boolean bl2 = true;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                boolean bl3 = DataCache.deleteDir(file2, stringBuilder);
                if (!bl3) {
                    bl2 = false;
                    DataCache.appendFailure(stringBuilder, file2);
                }
                ++n2;
            }
        }
        boolean bl4 = bl = !file.exists() || file.delete();
        if (!bl) {
            bl2 = false;
            DataCache.appendFailure(stringBuilder, file);
        }
        return bl2;
    }

    private static void appendFailure(StringBuilder stringBuilder, File file) {
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append(System.getProperty("line.separator"));
    }

    public CachedShortGroup getShortGroup(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getShortGroup(l);
        return (CachedShortGroup)iCachedObjectGroup;
    }

    public CachedByteGroup getByteGroup(long l) {
        ICachedObjectGroup iCachedObjectGroup = this.groups.getByteGroup(l);
        return (CachedByteGroup)iCachedObjectGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object;
        Object object2;
        ArrayList<CacheID> arrayList;
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("currently outside:\n");
        Map<Object, CacheID> map = this.itemsOutside;
        synchronized (map) {
            arrayList = new ArrayList<CacheID>(this.itemsOutside.values());
        }
        int n = 0;
        while (n < arrayList.size()) {
            object2 = this.globalLRU.get(arrayList.get(n));
            object = object2 != null ? ((CacheItem)object2).getItemUnsynced() : null;
            int n2 = 0;
            if (object instanceof short[]) {
                n2 = ((short[])object).length;
            } else if (object instanceof int[]) {
                n2 = ((int[])object).length;
            } else if (object instanceof byte[]) {
                n2 = ((byte[])object).length;
            }
            if (object2 != null) {
                stringBuilder.append("s:" + n2 + " " + ((CacheItem)object2).toString() + "\n");
            } else {
                stringBuilder.append("s:" + n2 + " unmanaged " + arrayList.get(n) + "\n");
            }
            ++n;
        }
        stringBuilder.append(String.valueOf(arrayList.size()) + " items\n");
        n = 0;
        this.globalLRU.lockForRead();
        try {
            object2 = this.globalLRU.getItemIterator(30);
            while (object2.hasNext()) {
                object = (CacheItem)object2.next();
                if (!((CacheItem)object).isReferencedUnsynced()) continue;
                ++n;
                stringBuilder.append("referenced " + ((CacheItem)object).toString() + "\n");
            }
        }
        finally {
            this.globalLRU.unlockForRead();
        }
        stringBuilder.append(String.valueOf(n) + " referenced items");
        return stringBuilder.toString();
    }

    public void setItemPriority(CacheID cacheID, int n) {
    }

    public int getItemPriority(CacheID cacheID) {
        CacheItem cacheItem = this.globalLRU.get(cacheID);
        if (cacheItem != null) {
            return cacheItem.getPriority();
        }
        cacheItem = this.onDisk.sniffItem(cacheID);
        if (cacheItem != null) {
            return cacheItem.getPriority();
        }
        return 0;
    }

    public long availableMemory(int n) {
        long l = this.cacheParameters.getFreeMem();
        this.globalLRU.lockForRead();
        try {
            Iterator<CacheItem> iterator = this.globalLRU.getItemIterator(n);
            while (iterator.hasNext()) {
                CacheItem cacheItem = iterator.next();
                if (!cacheItem.dataAvailableUnsynced()) continue;
                l += cacheItem.getManagementGroup().getSizeEstimate(null);
            }
        }
        finally {
            this.globalLRU.unlockForRead();
        }
        return l;
    }

    public long getFreeMemory() {
        return this.cacheParameters.getFreeMem();
    }

    public void removeFromOutside(Object object) {
        this.itemsOutside.remove(object);
    }

    public boolean startupComplete() {
        return this.onDisk.startupComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPoolActive(Object object, CacheID cacheID) {
        ICachedObjectGroup iCachedObjectGroup;
        ICachedObjectHandler iCachedObjectHandler = this.findHandler(object.getClass());
        Object object2 = iCachedObjectHandler.getGroupID(cacheID, object);
        if (object2 == null) {
            return false;
        }
        GroupHash groupHash = this.groups;
        synchronized (groupHash) {
            iCachedObjectGroup = (ICachedObjectGroup)this.groups.get(object2);
            if (iCachedObjectGroup == null) {
                iCachedObjectGroup = iCachedObjectHandler.createGroup((Object)cacheID, object);
                this.groups.put(object2, iCachedObjectGroup);
            }
        }
        return iCachedObjectGroup.usesPool();
    }

    public String getGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
        ICachedObjectGroup iCachedObjectGroup = this.getGroupFor(clazz, cacheID, 0L, true);
        if (iCachedObjectGroup != null) {
            try {
                return iCachedObjectGroup.getGroupAttribute(string);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public void setGroupAttribute(CacheID cacheID, Class<?> clazz, String string, String string2) {
        ICachedObjectGroup iCachedObjectGroup = this.getGroupFor(clazz, cacheID, 0L, true);
        try {
            iCachedObjectGroup.setGroupAttribute(string, string2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("failed to set group attribute: " + string + " to: " + string2, iOException);
        }
    }

    public void deleteGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
        ICachedObjectGroup iCachedObjectGroup = this.getGroupFor(clazz, cacheID, 0L, true);
        if (iCachedObjectGroup != null) {
            try {
                iCachedObjectGroup.deleteGroupAttribute(string);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("failed to delete group attribute: " + string, iOException);
            }
        }
    }

    public ICacheItemGroup getItemGroup(String string) {
        if (this.groups.containsKey(string)) {
            return new CacheItemGroup(string, this);
        }
        return null;
    }

    public String[] removeGroup(String string) {
        ICachedObjectGroup iCachedObjectGroup = this.removeGroup(ByteArrayContainer.class, this.createID(string, "", 1));
        if (iCachedObjectGroup != null) {
            String[] stringArray = iCachedObjectGroup.getItemMembers();
            CacheID[] cacheIDArray = new CacheID[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                cacheIDArray[n] = this.createID(string, stringArray[n], 1);
                ++n;
            }
            this.remove(cacheIDArray);
            iCachedObjectGroup.dispose();
            return stringArray;
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICachedObjectGroup removeGroup(Class<?> clazz, CacheID cacheID) {
        ICachedObjectGroup iCachedObjectGroup;
        ICachedObjectHandler iCachedObjectHandler = this.findHandler(clazz);
        Object object = iCachedObjectHandler.getGroupID(cacheID, 0L);
        if (object == null) {
            return null;
        }
        GroupHash groupHash = this.groups;
        synchronized (groupHash) {
            block6: {
                iCachedObjectGroup = (ICachedObjectGroup)this.groups.remove(object);
                if (iCachedObjectGroup != null) break block6;
                return null;
            }
            if (iCachedObjectGroup.isDestroyed()) {
                throw new IllegalStateException();
            }
        }
        return iCachedObjectGroup;
    }

    public void purgeEmptyGroups() {
        this.groups.purgeEmptyGroups();
    }

    private class DelayedRemoveAllJob
    extends GlobalLRU.DelayedWriteJob {
        private final CacheID[] ids;

        public DelayedRemoveAllJob(CacheID[] cacheIDArray) {
            this.ids = cacheIDArray;
        }

        @Override
        public void commit() {
            int n = 0;
            while (n < this.ids.length) {
                CacheItem cacheItem = DataCache.this.globalLRU.getUnsynced(this.ids[n]);
                if (cacheItem != null || (cacheItem = DataCache.this.onDisk.sniffItem(this.ids[n])) != null) {
                    cacheItem.removeUnsynced(false);
                }
                ++n;
            }
        }
    }

    private class DelayedRemoveJob
    extends GlobalLRU.DelayedWriteJob {
        private final CacheID id;

        public DelayedRemoveJob(CacheID cacheID) {
            this.id = cacheID;
        }

        @Override
        public void commit() {
            CacheItem cacheItem = DataCache.this.globalLRU.getUnsynced(this.id);
            if (cacheItem == null && (cacheItem = DataCache.this.onDisk.sniffItem(this.id)) == null) {
                return;
            }
            cacheItem.removeUnsynced(false);
        }
    }

    private class ImpaxEEPersistenceQueue
    extends LinkedBlockingDeque<CacheItem>
    implements IPersistenceQueue {
        ImpaxEEPersistenceQueue() {
        }

        @Override
        public void addAtBottom(CacheItem cacheItem) {
            if (DataCache.this.cacheParameters.usePersistentStorage()) {
                super.addLast(cacheItem);
            }
        }

        @Override
        public void addAtTop(CacheItem cacheItem) {
            if (DataCache.this.cacheParameters.usePersistentStorage()) {
                super.addFirst(cacheItem);
            }
        }

        @Override
        public void updatePriority(CacheItem cacheItem) {
        }
    }
}

