/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache;

import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CacheParameters;
import com.agfa.pacs.memcache.GroupLRU;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import java.util.HashMap;
import java.util.Iterator;

public class PersistentGroupLRU
extends GroupLRU {
    private CacheParameters cacheParameters;

    public PersistentGroupLRU(GlobalLRU globalLRU, CacheParameters cacheParameters) {
        super(globalLRU);
        this.cacheParameters = cacheParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object claimNonEmpty(int n) {
        Object object;
        CacheItem cacheItem;
        if (!this.hasClaimableItemsUnsynced(n) || !this.cacheParameters.usePersistentStorage()) {
            return null;
        }
        Object object2 = null;
        HashMap<CacheItem, CacheItem> hashMap = null;
        do {
            object = this;
            synchronized (object) {
                block17: {
                    if (this.hasClaimableItemsUnsynced(n)) break block17;
                    return null;
                }
                Iterator iterator = this.iterator(31);
                do {
                    if (!(cacheItem = (CacheItem)iterator.next()).isClaimableUnsynced() || hashMap != null && hashMap.containsKey(cacheItem)) continue;
                    if (cacheItem.getUnsyncedState() == ItemState.PERSONALIZED) {
                        object2 = cacheItem.claimItemSynced();
                        if (object2 == null) continue;
                        iterator.remove();
                        ((Object)((Object)this)).notify();
                        return object2;
                    }
                    object2 = cacheItem.getItemReferenceSynced();
                } while (object2 == null && iterator.hasNext());
            }
            if (object2 == null) {
                return null;
            }
            if (Runtime.getRuntime().freeMemory() > Math.max(10000000L, cacheItem.getManagementGroup().getSizeEstimate(null) * 5L)) {
                try {
                    object = cacheItem.getManagementGroup().allocateNew();
                    if (object != null) {
                        cacheItem.releaseReferenceSynced();
                        return object;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {}
            }
            cacheItem.writePersistent();
            if (cacheItem.getUnsyncedState() != ItemState.PERSISTENT) continue;
            if (hashMap == null) {
                hashMap = new HashMap<CacheItem, CacheItem>();
            }
            hashMap.put(cacheItem, cacheItem);
        } while ((object2 = cacheItem.releaseReferenceAndClaimItemSynced()) == null);
        object = this;
        synchronized (object) {
            this.removeAndGetUnsynced(cacheItem);
        }
        return object2;
    }
}

