/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.blocked;

import com.agfa.pacs.cache.AbstractArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CommonFileGroup;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.blocked.ArrayContainerCacheItem;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;

public abstract class AbstractArrayContainerGroup
extends CommonFileGroup {
    private static final ALogger LOGGER = ALogger.getLogger(AbstractArrayContainerGroup.class);
    protected long nativeFileHandle = -1L;
    protected RandomAccessFile df;
    protected int typeMultiplier = 1;

    public AbstractArrayContainerGroup(DataCache dataCache) {
        super(dataCache, null, false);
    }

    public AbstractArrayContainerGroup(DataCache dataCache, String string) {
        super(dataCache, string, true);
        this.dataCache = dataCache;
        this.global = dataCache.getGlobalLRU();
    }

    @Override
    public Object getPersistent(CacheItem cacheItem, CacheID cacheID) {
        ArrayContainerCacheItem arrayContainerCacheItem = (ArrayContainerCacheItem)cacheItem;
        arrayContainerCacheItem.touch();
        Object object = arrayContainerCacheItem.getRawReferenceSynced();
        if (object != null) {
            return object;
        }
        this.readPersistent(cacheItem);
        object = arrayContainerCacheItem.getRawReferenceSynced();
        arrayContainerCacheItem.releaseReferenceSynced();
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPersistent(Object object, CacheID cacheID, int n) {
        CacheItem cacheItem = this.addPersistentInternal(object, cacheID, n);
        if (cacheItem != null) {
            Map<String, long[]> map;
            AbstractArrayContainer abstractArrayContainer = (AbstractArrayContainer)object;
            this.dataCache.removeFromOutside(abstractArrayContainer.getData());
            ICachedObjectGroup iCachedObjectGroup = this.getArrayGroup(abstractArrayContainer.getArrayLength());
            iCachedObjectGroup.addPersistent(cacheItem);
            String string = this.getItemID(cacheID);
            Map<String, long[]> map2 = map = this.getIndex();
            synchronized (map2) {
                long[] lArray = (long[])this.deleted.remove(string);
                if (lArray != null) {
                    map.put(string, lArray);
                } else {
                    map.put(string, ADDED);
                }
            }
        }
    }

    @Override
    public void free(Object object) {
        AbstractArrayContainer abstractArrayContainer = (AbstractArrayContainer)object;
        this.dataCache.free(abstractArrayContainer.getData());
    }

    @Override
    public boolean isAllocationAllowed() {
        return this.dataCache.getParameters().isAllocationAllowed(1234567L);
    }

    @Override
    public Object allocateNew() {
        throw new IllegalStateException();
    }

    @Override
    public void clear(Object object) {
    }

    @Override
    public Object readItem(long l, long l2) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public synchronized void groupEmptied() {
        super.groupEmptied();
        super.dispose();
        this.notify();
    }

    @Override
    protected void closeDataFile() throws IOException {
        if (this.nativeFileHandle != -1L) {
            long l = ArrayIO.close(this.nativeFileHandle);
            this.nativeFileHandle = -1L;
            if (l != 0L) {
                throw new IOException(ArrayIO.getErrorMessage(l));
            }
        }
        if (this.df != null) {
            try {
                this.df.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to close file", (Throwable)iOException);
            }
            this.df = null;
        }
    }

    @Override
    protected long openDataFile() throws IOException {
        File file = new File(this.dataFile);
        if (ArrayIO.useNativeIO) {
            if (this.nativeFileHandle == -1L) {
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                byte[] byArray = (String.valueOf(this.dataFile) + "\u0000").getBytes();
                this.nativeFileHandle = ArrayIO.openForRW(byArray);
                if (this.nativeFileHandle == -1L) {
                    throw new IOException("failed to open file" + this.dataFile);
                }
            }
        } else if (this.df == null) {
            File file3 = file.getParentFile();
            if (!file3.exists()) {
                file3.mkdirs();
            }
            this.df = new RandomAccessFile(this.dataFile, "rw");
        }
        this.playbackTempFileAttributes();
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readPersistent(CacheItem cacheItem) {
        Object object = cacheItem;
        synchronized (object) {
            if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
                throw new IllegalArgumentException("id not known to cache " + cacheItem.getID());
            }
            cacheItem.addReferenceUnsynced();
            if (cacheItem.getUnsyncedState() == ItemState.READING) {
                while (cacheItem.getUnsyncedState() == ItemState.READING) {
                    try {
                        cacheItem.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            if (cacheItem.dataAvailableUnsynced()) {
                return;
            }
            cacheItem.setStateUnsynced(ItemState.READING);
            cacheItem.notify();
        }
        object = null;
        try {
            long[] lArray = this.getPosFromIndex(cacheItem.getID());
            long l = lArray[0];
            long l2 = (lArray[1] - l) / (long)this.typeMultiplier;
            int n = (int)cacheItem.getManagementGroup().getSizeEstimate(null);
            AbstractArrayContainer abstractArrayContainer = this.createArrayContainer(l2, n, cacheItem.getPriority());
            Object object2 = this;
            synchronized (object2) {
                if (this.groupState != CommonFileGroup.FileGroupState.OPEN) {
                    Map<String, long[]> map = this.getIndex();
                    synchronized (map) {
                        this.openGroup(true);
                    }
                }
                object = this.readItem(abstractArrayContainer, l, l2, cacheItem.getID());
                this.notifyAll();
            }
            object2 = cacheItem;
            synchronized (object2) {
                cacheItem.setDataUnsynced(object);
                cacheItem.setStateUnsynced(ItemState.PERSONALIZED);
                cacheItem.notifyAll();
            }
        }
        catch (Exception exception) {
            CacheItem cacheItem2 = cacheItem;
            synchronized (cacheItem2) {
                cacheItem.setDataUnsynced(null);
                if (cacheItem.getUnsyncedState() != ItemState.DELETED) {
                    cacheItem.setStateUnsynced(ItemState.PERSONALIZED);
                }
                cacheItem.releaseReferenceSynced();
                cacheItem.notifyAll();
            }
            if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
                throw new IllegalArgumentException();
            }
            log.error("Unable to read persistent cache item", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public CacheItem createItem(Object object, CacheID cacheID, int n) {
        if (object == null) {
            long[] lArray = this.getPosFromIndex(cacheID);
            if (lArray == ADDED) {
                return this.global.get(cacheID);
            }
            long l = lArray[1] - lArray[0];
            return new ArrayContainerCacheItem(null, cacheID, this, this.getArrayGroup(AbstractArrayContainer.roundUpSize((int)((int)l))), n);
        }
        long l = ((AbstractArrayContainer)object).getArrayLength();
        ArrayContainerCacheItem arrayContainerCacheItem = new ArrayContainerCacheItem(object, cacheID, this, this.getArrayGroup(l), n);
        return arrayContainerCacheItem;
    }

    @Override
    public long[] writeItem(Object object, long l, CacheID cacheID) throws IOException {
        AbstractArrayContainer abstractArrayContainer = (AbstractArrayContainer)object;
        if (ArrayIO.useNativeIO) {
            this.writeNative(abstractArrayContainer, l);
        } else {
            this.writeNIO(abstractArrayContainer, l);
        }
        return new long[]{l, l + (long)(abstractArrayContainer.getDataLength() * this.typeMultiplier)};
    }

    public Object readItem(AbstractArrayContainer abstractArrayContainer, long l, long l2, CacheID cacheID) throws IOException {
        if (ArrayIO.useNativeIO) {
            this.readNative(abstractArrayContainer, l);
        } else {
            this.readNIO(abstractArrayContainer, l);
        }
        return abstractArrayContainer;
    }

    protected abstract AbstractArrayContainer createArrayContainer(long var1, long var3, int var5);

    protected abstract ICachedObjectGroup getArrayGroup(long var1);

    protected abstract void writeNative(AbstractArrayContainer var1, long var2) throws IOException;

    protected abstract void writeNIO(AbstractArrayContainer var1, long var2) throws IOException;

    protected abstract void readNative(AbstractArrayContainer var1, long var2) throws IOException;

    protected abstract void readNIO(AbstractArrayContainer var1, long var2) throws IOException;
}

