/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.blocked;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.BlockedFileGroup;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.internal.CachedShortGroup;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.BitSet;

public class BlockedShortArrayGroup
extends BlockedFileGroup {
    private CachedShortGroup linkedShortGroup;

    public BlockedShortArrayGroup(DataCache dataCache, String string, boolean bl, long l) {
        super(dataCache, string, bl, l * 2L);
    }

    @Override
    public void setLength(long l) {
        super.setLength(l);
        if (l >= 0L) {
            this.linkedShortGroup = this.dataCache.getShortGroup(l / 2L);
        }
    }

    @Override
    public Object readItem(InputStream inputStream, long l) throws IOException {
        Object object;
        try (ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);){
            try {
                object = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
        }
        return object;
    }

    @Override
    public void writeItem(DataOutputStream dataOutputStream, Object object) throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean isAllocationAllowed() {
        return this.dataCache.getParameters().isAllocationAllowed(this.length);
    }

    @Override
    public Object allocateNew() {
        return this.linkedShortGroup.allocateNew();
    }

    @Override
    public void clear(Object object) {
    }

    @Override
    public void readNIO(Object object, long l) throws IOException {
        short[] sArray = (short[])object;
        MappedByteBuffer mappedByteBuffer = this.df.getChannel().map(FileChannel.MapMode.READ_ONLY, l, this.length);
        mappedByteBuffer.order(ByteOrder.nativeOrder());
        mappedByteBuffer.asShortBuffer().get(sArray);
    }

    @Override
    public void readNative(Object object, long l) throws IOException {
        short[] sArray = (short[])object;
        long l2 = ArrayIO.readShortArray(sArray, l, 0, sArray.length, this.nativeFileHandle);
        if (l2 != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l2));
        }
    }

    @Override
    public void writeNIO(Object object, long l) throws IOException {
        short[] sArray = (short[])object;
        FileChannel fileChannel = this.df.getChannel();
        if (sArray == null) {
            throw new NullPointerException();
        }
        if (fileChannel == null) {
            throw new NullPointerException();
        }
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l, this.length);
        mappedByteBuffer.order(ByteOrder.nativeOrder());
        mappedByteBuffer.asShortBuffer().put(sArray);
        if (this.dataCache.getParameters().isPermanent()) {
            mappedByteBuffer.force();
        }
    }

    @Override
    public void writeNative(Object object, long l) throws IOException {
        short[] sArray = (short[])object;
        long l2 = ArrayIO.writeShortArray(sArray, l, 0, sArray.length, this.nativeFileHandle);
        if (l2 != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l2));
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        return object != null ? (long)(((short[])object).length * 2) : this.length;
    }

    @Override
    public boolean isDestroyed() {
        BitSet bitSet = this.getPresence();
        return bitSet != null && bitSet.isEmpty();
    }

    @Override
    public CacheItem createItem(Object object, CacheID cacheID, int n) {
        return new CacheItem(object, cacheID, this, (ICachedObjectGroup)this.linkedShortGroup, n);
    }

    @Override
    public void addPersistent(Object object, CacheID cacheID, int n) {
        CacheItem cacheItem;
        if (this.length < 0L) {
            this.setLength(this.getSizeEstimate(object));
            this.createInfoFile(String.valueOf(this.dataFile.substring(0, this.dataFile.length() - 3)) + "nfo");
        }
        if ((cacheItem = this.addPersistentInternal(object, cacheID, n)) != null) {
            this.linkedShortGroup.addPersistent(cacheItem);
        }
    }

    @Override
    public Object getPersistent(CacheItem cacheItem, CacheID cacheID) {
        this.linkedShortGroup.touchLocally(cacheItem, cacheID);
        return this.getPersistentInternal(cacheItem, cacheID);
    }
}

