/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.blocked;

import com.agfa.pacs.cache.AbstractArrayContainer;
import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.blocked.AbstractArrayContainerGroup;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class ByteArrayContainerGroup
extends AbstractArrayContainerGroup {
    public ByteArrayContainerGroup(DataCache dataCache) {
        super(dataCache);
    }

    public ByteArrayContainerGroup(DataCache dataCache, String string) {
        super(dataCache, string);
    }

    @Override
    protected AbstractArrayContainer createArrayContainer(long l, long l2, int n) {
        return new ByteArrayContainer((byte[])this.dataCache.getByteGroup(l2).allocateObject(false, n), 0, (int)l);
    }

    @Override
    public ICachedObjectGroup getArrayGroup(long l) {
        return this.dataCache.getByteGroup(l);
    }

    @Override
    public Object allocateObject(boolean bl, int n) {
        return null;
    }

    @Override
    public Object allocateObject(boolean bl, Object[] objectArray, int n) {
        int n2 = ((Number)objectArray[0]).intValue();
        int n3 = AbstractArrayContainer.roundUpSize((int)n2);
        byte[] byArray = bl ? this.dataCache.allocAndClearBytes(n3) : this.dataCache.allocBytes(n3);
        return new ByteArrayContainer(byArray, 0, n2);
    }

    @Override
    public long getSizeEstimate(Object object) {
        return ((AbstractArrayContainer)object).getDataLength() + 8;
    }

    @Override
    protected void writeNative(AbstractArrayContainer abstractArrayContainer, long l) throws IOException {
        long l2 = ArrayIO.writeByteArray((byte[])abstractArrayContainer.getData(), l, abstractArrayContainer.getOffset(), abstractArrayContainer.getDataLength(), this.nativeFileHandle);
        if (l2 != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l2));
        }
    }

    @Override
    protected void writeNIO(AbstractArrayContainer abstractArrayContainer, long l) throws IOException {
        FileChannel fileChannel = this.df.getChannel();
        if (abstractArrayContainer == null) {
            throw new NullPointerException();
        }
        if (fileChannel == null) {
            throw new NullPointerException();
        }
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l, abstractArrayContainer.getDataLength());
        mappedByteBuffer.order(ByteOrder.nativeOrder());
        mappedByteBuffer.put((byte[])abstractArrayContainer.getData(), abstractArrayContainer.getOffset(), abstractArrayContainer.getDataLength());
        if (this.dataCache.getParameters().isPermanent()) {
            mappedByteBuffer.force();
        }
    }

    @Override
    protected void readNative(AbstractArrayContainer abstractArrayContainer, long l) throws IOException {
        long l2 = ArrayIO.readByteArray((byte[])abstractArrayContainer.getData(), l, abstractArrayContainer.getOffset(), abstractArrayContainer.getDataLength(), this.nativeFileHandle);
        if (l2 != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l2));
        }
    }

    @Override
    protected void readNIO(AbstractArrayContainer abstractArrayContainer, long l) throws IOException {
        MappedByteBuffer mappedByteBuffer = this.df.getChannel().map(FileChannel.MapMode.READ_ONLY, l, abstractArrayContainer.getDataLength());
        mappedByteBuffer.order(ByteOrder.nativeOrder());
        mappedByteBuffer.get((byte[])abstractArrayContainer.getData(), 0, abstractArrayContainer.getDataLength());
    }
}

