/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.blocked;

import com.agfa.pacs.cache.AbstractArrayContainer;
import com.agfa.pacs.cache.ShortArrayContainer;
import com.agfa.pacs.memcache.ArrayIO;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.blocked.AbstractArrayContainerGroup;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class ShortArrayContainerGroup
extends AbstractArrayContainerGroup {
    public ShortArrayContainerGroup(DataCache dataCache) {
        super(dataCache);
        this.typeMultiplier = 2;
    }

    public ShortArrayContainerGroup(DataCache dataCache, String string) {
        super(dataCache, string);
        this.typeMultiplier = 2;
    }

    @Override
    protected AbstractArrayContainer createArrayContainer(long l, long l2, int n) {
        return new ShortArrayContainer((short[])this.dataCache.getShortGroup(l2).allocateObject(false, n), 0, (int)l);
    }

    @Override
    public ICachedObjectGroup getArrayGroup(long l) {
        return this.dataCache.getShortGroup(l);
    }

    @Override
    public Object allocateObject(boolean bl, int n) {
        return null;
    }

    @Override
    public Object allocateObject(boolean bl, Object[] objectArray, int n) {
        int n2 = ((Number)objectArray[0]).intValue();
        int n3 = AbstractArrayContainer.roundUpSize((int)n2);
        short[] sArray = bl ? this.dataCache.allocAndClearShorts(n3) : this.dataCache.allocShorts(n3);
        return new ShortArrayContainer(sArray, 0, n2);
    }

    @Override
    public long getSizeEstimate(Object object) {
        return (((AbstractArrayContainer)object).getDataLength() + 8) * 2;
    }

    @Override
    protected void writeNative(AbstractArrayContainer abstractArrayContainer, long l) throws IOException {
        long l2 = ArrayIO.writeShortArray((short[])abstractArrayContainer.getData(), l, abstractArrayContainer.getOffset(), abstractArrayContainer.getDataLength(), this.nativeFileHandle);
        if (l2 != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l2));
        }
    }

    @Override
    protected void writeNIO(AbstractArrayContainer abstractArrayContainer, long l) throws IOException {
        FileChannel fileChannel = this.df.getChannel();
        if (abstractArrayContainer == null) {
            throw new NullPointerException();
        }
        if (fileChannel == null) {
            throw new NullPointerException();
        }
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, l, abstractArrayContainer.getDataLength() * 2);
        mappedByteBuffer.order(ByteOrder.nativeOrder());
        mappedByteBuffer.asShortBuffer().put((short[])abstractArrayContainer.getData(), abstractArrayContainer.getOffset(), abstractArrayContainer.getDataLength());
        if (this.dataCache.getParameters().isPermanent()) {
            mappedByteBuffer.force();
        }
    }

    @Override
    protected void readNative(AbstractArrayContainer abstractArrayContainer, long l) throws IOException {
        long l2 = ArrayIO.readShortArray((short[])abstractArrayContainer.getData(), l, abstractArrayContainer.getOffset(), abstractArrayContainer.getDataLength(), this.nativeFileHandle);
        if (l2 != 0L) {
            throw new IOException(ArrayIO.getErrorMessage(l2));
        }
    }

    @Override
    protected void readNIO(AbstractArrayContainer abstractArrayContainer, long l) throws IOException {
        MappedByteBuffer mappedByteBuffer = this.df.getChannel().map(FileChannel.MapMode.READ_ONLY, l, abstractArrayContainer.getDataLength() * 2);
        mappedByteBuffer.order(ByteOrder.nativeOrder());
        mappedByteBuffer.asShortBuffer().get((short[])abstractArrayContainer.getData(), 0, abstractArrayContainer.getDataLength());
    }
}

