/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.DistinctFileGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class CachedByteGroup
extends DistinctFileGroup {
    private static final ALogger LOGGER = ALogger.getLogger(CachedByteGroup.class);

    public CachedByteGroup(long l, DataCache dataCache) {
        super(l, dataCache);
    }

    @Override
    public void clear(Object object) {
        byte[] byArray = (byte[])object;
        Arrays.fill(byArray, (byte)0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object allocateNew() {
        try {
            return new byte[(int)this.length];
        }
        catch (OutOfMemoryError v0) {
            this.dataCache.ensureFreeMemory(this.length * 2L);
            try {
                return new byte[(int)this.length];
            }
            catch (OutOfMemoryError v1) {
                this.dataCache.ensureFreeMemory(-1L);
                try {
                    return new byte[(int)this.length];
                }
                catch (OutOfMemoryError var1_1) {
                    CachedByteGroup.LOGGER.warn("VERY low memory, repeating allocation attempt...");
                    var2_2 = 0;
                    ** while (var2_2 < 20)
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep((long)(300.0 * Math.random()));
                this.dataCache.ensureFreeMemory(-1L);
            }
            catch (InterruptedException v2) {}
            try {
                return new byte[(int)this.length];
            }
            catch (OutOfMemoryError v3) {
                ++var2_2;
            }
            continue;
        }
lbl25:
        // 1 sources

        CachedByteGroup.LOGGER.warn("allocation of " + this.length + " failed");
        throw var1_1;
    }

    @Override
    public void readNative(Object object, String string) throws IOException {
        this.readNativeBytes((byte[])object, string);
    }

    @Override
    public void readNIO(Object object, String string) throws IOException {
        byte[] byArray = (byte[])object;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");){
            randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, byArray.length).order(ByteOrder.nativeOrder());
            randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, byArray.length).get(byArray);
        }
    }

    @Override
    public void writeNative(Object object, String string) throws IOException {
        this.writeNativeBytes((byte[])object, string);
    }

    @Override
    public void writeNIO(Object object, String string) throws IOException {
        byte[] byArray = (byte[])object;
        try {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                new File(string).getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            try {
                randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, byArray.length).order(ByteOrder.nativeOrder());
                randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, byArray.length).put(byArray);
            }
            finally {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            new File(string).delete();
            throw iOException;
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        return object != null ? (long)((byte[])object).length : this.length;
    }
}

