/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.DistinctFileGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class CachedDoubleGroup
extends DistinctFileGroup {
    public CachedDoubleGroup(long l, DataCache dataCache) {
        super(l, dataCache);
    }

    @Override
    public void clear(Object object) {
        double[] dArray = (double[])object;
        Arrays.fill(dArray, 0.0);
    }

    @Override
    public Object allocateNew() {
        try {
            return new double[(int)this.length];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.dataCache.ensureFreeMemory(this.length * 12L);
            try {
                return new double[(int)this.length];
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                this.dataCache.ensureFreeMemory(-1L);
                return new double[(int)this.length];
            }
        }
    }

    @Override
    public void readNative(Object object, String string) throws IOException {
        this.readNativeDoubles((double[])object, string);
    }

    @Override
    public void readNIO(Object object, String string) throws IOException {
        double[] dArray = (double[])object;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");){
            MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, dArray.length * 8);
            mappedByteBuffer.order(ByteOrder.nativeOrder());
            mappedByteBuffer.asDoubleBuffer().get(dArray);
        }
    }

    @Override
    public void writeNative(Object object, String string) throws IOException {
        this.writeNativeDoubles((double[])object, string);
    }

    @Override
    public void writeNIO(Object object, String string) throws IOException {
        double[] dArray = (double[])object;
        try {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                new File(string).getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            try {
                MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, dArray.length * 8);
                mappedByteBuffer.order(ByteOrder.nativeOrder());
                mappedByteBuffer.asDoubleBuffer().put(dArray);
            }
            finally {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            new File(string).delete();
            throw iOException;
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        return object != null ? (long)(((double[])object).length * 8) : this.length * 8L;
    }
}

