/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.DistinctFileGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class CachedFloatGroup
extends DistinctFileGroup {
    public CachedFloatGroup(long l, DataCache dataCache) {
        super(l, dataCache);
    }

    @Override
    public void clear(Object object) {
        float[] fArray = (float[])object;
        Arrays.fill(fArray, 0.0f);
    }

    @Override
    public Object allocateNew() {
        try {
            return new float[(int)this.length];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.dataCache.ensureFreeMemory(this.length * 6L);
            try {
                return new float[(int)this.length];
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                this.dataCache.ensureFreeMemory(-1L);
                return new float[(int)this.length];
            }
        }
    }

    @Override
    public void readNative(Object object, String string) throws IOException {
        this.readNativeFloats((float[])object, string);
    }

    @Override
    public void readNIO(Object object, String string) throws IOException {
        float[] fArray = (float[])object;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");){
            MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fArray.length * 4);
            mappedByteBuffer.order(ByteOrder.nativeOrder());
            mappedByteBuffer.asFloatBuffer().get(fArray);
        }
    }

    @Override
    public void writeNative(Object object, String string) throws IOException {
        this.writeNativeFloats((float[])object, string);
    }

    @Override
    public void writeNIO(Object object, String string) throws IOException {
        float[] fArray = (float[])object;
        try {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                new File(string).getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            try {
                MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, fArray.length * 4);
                mappedByteBuffer.order(ByteOrder.nativeOrder());
                mappedByteBuffer.asFloatBuffer().put(fArray);
            }
            finally {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            new File(string).delete();
            throw iOException;
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        return object != null ? (long)(((float[])object).length * 4) : this.length * 4L;
    }
}

