/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.DistinctFileGroup;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;

public class CachedShortGroup
extends DistinctFileGroup {
    private static final ALogger LOGGER = ALogger.getLogger(CachedShortGroup.class);

    public CachedShortGroup(long l, DataCache dataCache) {
        super(l, dataCache);
    }

    @Override
    public void clear(Object object) {
        short[] sArray = (short[])object;
        Arrays.fill(sArray, (short)0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object allocateNew() {
        try {
            return new short[(int)this.length];
        }
        catch (OutOfMemoryError v0) {
            this.dataCache.ensureFreeMemory(this.length * 3L);
            try {
                return new short[(int)this.length];
            }
            catch (OutOfMemoryError v1) {
                this.dataCache.ensureFreeMemory(-1L);
                try {
                    return new short[(int)this.length];
                }
                catch (OutOfMemoryError var1_1) {
                    CachedShortGroup.LOGGER.info("VERY low memory, repeating allocation attempt...");
                    var2_2 = 0;
                    ** while (var2_2 < 20)
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep((long)(300.0 * Math.random()));
                this.dataCache.ensureFreeMemory(-1L);
            }
            catch (InterruptedException v2) {}
            try {
                return new short[(int)this.length];
            }
            catch (OutOfMemoryError v3) {
                ++var2_2;
            }
            continue;
        }
lbl25:
        // 1 sources

        CachedShortGroup.LOGGER.info("allocation of " + 2L * this.length + " failed");
        throw var1_1;
    }

    @Override
    public void readNative(Object object, String string) throws IOException {
        this.readNativeShorts((short[])object, string);
    }

    @Override
    public void readNIO(Object object, String string) throws IOException {
        short[] sArray = (short[])object;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");){
            MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, sArray.length * 2);
            mappedByteBuffer.order(ByteOrder.nativeOrder());
            mappedByteBuffer.asShortBuffer().get(sArray);
        }
    }

    @Override
    public void writeNative(Object object, String string) throws IOException {
        this.writeNativeShorts((short[])object, string);
    }

    @Override
    public void writeNIO(Object object, String string) throws IOException {
        short[] sArray = (short[])object;
        try {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            catch (FileNotFoundException fileNotFoundException) {
                new File(string).getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(string, "rw");
            }
            try {
                FileChannel fileChannel = randomAccessFile.getChannel();
                if (sArray == null) {
                    throw new NullPointerException();
                }
                if (fileChannel == null) {
                    throw new NullPointerException();
                }
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, sArray.length * 2);
                mappedByteBuffer.order(ByteOrder.nativeOrder());
                mappedByteBuffer.asShortBuffer().put(sArray);
            }
            finally {
                randomAccessFile.close();
            }
        }
        catch (IOException iOException) {
            new File(string).delete();
            throw iOException;
        }
    }

    @Override
    public long getSizeEstimate(Object object) {
        return object != null ? (long)(((short[])object).length * 2) : 2L * this.length;
    }
}

