/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.GrouplessID;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.CacheParameters;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import com.agfa.pacs.memcache.internal.PoolGuard;
import com.agfa.pacs.tools.FileUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class DiskItemsHash {
    private static final ALogger log = ALogger.getLogger(DiskItemsHash.class);
    Hashtable<CacheID, CacheItem> items;
    private final CacheParameters cacheParameters;
    private final String tokenPrefix;
    public long nonControllable;
    public long diskCacheSize;
    LinkedHashMap<String, String> groups;
    public static final String NOT_TOUCHED = "0";
    public static final String TOUCHED = "1";
    public static final String RESERVED = "2";
    private final DataCache cache;
    private boolean deleteOccured;
    private boolean startupComplete;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGroupNames() {
        String[] stringArray;
        int n = 0;
        LinkedHashMap<String, String> linkedHashMap = this.groups;
        synchronized (linkedHashMap) {
            stringArray = new String[this.groups.size()];
            for (String string : this.groups.keySet()) {
                stringArray[n++] = string;
            }
        }
        return stringArray;
    }

    public DiskItemsHash(DataCache dataCache, String string) {
        this.cache = dataCache;
        this.cacheParameters = dataCache.getParameters();
        this.tokenPrefix = string;
        this.items = new Hashtable();
        this.groups = new LinkedHashMap();
        if (this.cacheParameters.usePersistentStorage()) {
            new Thread((Runnable)new DiskCacheInitializer(new File(String.valueOf(this.cacheParameters.getLocation()) + "locks")), "DiskCacheInitializer").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheItem getItem(CacheID cacheID, Class<?> clazz, DataCache dataCache) {
        CacheItem cacheItem = this.items.get(cacheID);
        if (cacheItem != null) {
            GlobalLRU globalLRU = dataCache.getGlobalLRU();
            globalLRU.lockForWrite();
            try {
                CacheItem cacheItem2 = globalLRU.getUnsynced(cacheID);
                if (cacheItem2 == null) {
                    globalLRU.putUnsynced(cacheID, cacheItem);
                }
            }
            finally {
                globalLRU.unlockForWrite();
            }
            return cacheItem;
        }
        String string = cacheID.getGroup();
        if (string != null && this.cacheParameters.isPermanent()) {
            Object object;
            String string2;
            Object object2 = this.groups;
            synchronized (object2) {
                block32: {
                    string2 = (String)this.groups.remove(string);
                    if (string2 != null) break block32;
                    return null;
                }
                if (string2 == NOT_TOUCHED) {
                    this.groups.put(string, RESERVED);
                } else {
                    this.groups.put(string, string2);
                }
            }
            object2 = dataCache.getGroupFor(clazz, cacheID, -1L);
            if (object2 == null || object2.isDestroyed()) {
                object = new File(String.valueOf(this.cacheParameters.getLocation()) + File.separatorChar + cacheID);
                long l = ((File)object).length();
                object2 = dataCache.getGroupFor(clazz, cacheID, l);
            }
            if (object2.persistentItemExists(cacheID)) {
                object = dataCache.getGlobalLRU();
                ((GlobalLRU)object).lockForWrite();
                try {
                    cacheItem = ((GlobalLRU)object).getUnsynced(cacheID);
                    if (cacheItem == null) {
                        cacheItem = object2.createItem(null, cacheID, 30);
                        ((GlobalLRU)object).putUnsynced(cacheID, cacheItem);
                    }
                }
                finally {
                    ((GlobalLRU)object).unlockForWrite();
                }
                Serializable serializable = this.items;
                synchronized (serializable) {
                    if (!this.items.containsKey(cacheID)) {
                        this.items.put(cacheID, cacheItem);
                    }
                }
                if (string2 == NOT_TOUCHED) {
                    serializable = new File(String.valueOf(this.cacheParameters.getLocation()) + string);
                    ((File)serializable).setLastModified(System.currentTimeMillis());
                }
                serializable = this.groups;
                synchronized (serializable) {
                    this.groups.put(string, TOUCHED);
                }
                return cacheItem;
            }
            if (string2 == NOT_TOUCHED) {
                object = this.groups;
                synchronized (object) {
                    if (this.groups.put(string, NOT_TOUCHED) == TOUCHED) {
                        this.groups.put(string, TOUCHED);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeDiskSpace(long l) {
        if (this.groups.isEmpty()) {
            return;
        }
        long l2 = 0L;
        boolean bl = false;
        while (l2 < l && !this.groups.isEmpty()) {
            boolean bl2;
            String string;
            LinkedHashMap<String, String> linkedHashMap = this.groups;
            synchronized (linkedHashMap) {
                string = this.groups.keySet().iterator().next();
                boolean bl3 = bl2 = this.groups.get(string) != NOT_TOUCHED;
                if (!bl2) {
                    this.groups.remove(string);
                }
            }
            if (bl2) {
                if (this.deleteOccured) {
                    this.deleteOccured = false;
                    this.untouchUnusedGroups();
                    continue;
                }
                if (bl) {
                    return;
                }
                PoolGuard.requestPersistentAlert(2L * (this.diskCacheSize - this.cacheParameters.getDiskSizeLimit()));
                if (this.deleteOccured) {
                    this.untouchUnusedGroups();
                    this.deleteOccured = false;
                }
                bl = true;
                continue;
            }
            long l3 = 0L;
            File file = new File(String.valueOf(this.cacheParameters.getLocation()) + IDataCacheProvider.persistenceModifiers[1] + File.separatorChar + string);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray2[n2];
                    l3 += file2.length();
                    file2.delete();
                    ++n2;
                }
            }
            file.delete();
            l2 += l3;
            this.removeDataFromDisk(l3);
        }
    }

    public void ensureDiskSize() {
        this.freeDiskSpace(this.diskCacheSize - this.cacheParameters.getDiskSizeLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untouchUnusedGroups() {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        LinkedHashMap<String, String> object5 = this.groups;
        synchronized (object5) {
            hashMap = new HashMap<String, String>(this.groups);
        }
        Hashtable<CacheID, CacheItem> hashtable = this.items;
        synchronized (hashtable) {
            for (CacheID cacheID : this.items.keySet()) {
                Object object = cacheID.getGroup();
                if (object == null) {
                    object = cacheID.getID();
                    object = ((String)object).substring(((String)object).indexOf(File.separatorChar) + 1);
                }
                hashMap.remove(object);
                hashMap2.put((String)object, cacheID.getID());
            }
        }
        LinkedHashMap<String, String> linkedHashMap = this.groups;
        synchronized (linkedHashMap) {
            LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
            for (Map.Entry entry : this.groups.entrySet()) {
                if (hashMap.get(entry.getKey()) == null) {
                    linkedHashMap2.put((String)entry.getKey(), TOUCHED);
                    continue;
                }
                if (entry.getValue() != RESERVED) continue;
                linkedHashMap2.put((String)entry.getKey(), RESERVED);
            }
            this.groups.clear();
            for (String string : hashMap.keySet()) {
                this.groups.put(string, NOT_TOUCHED);
            }
            this.groups.putAll(linkedHashMap2);
        }
        if (log.isDebugEnabled()) {
            for (Map.Entry entry : hashMap2.entrySet()) {
                log.debug("not untouched " + (String)entry.getKey() + " becau1se of " + (String)entry.getValue());
            }
        }
    }

    private synchronized void addDataOnDisk(long l) {
        this.diskCacheSize += l;
    }

    private synchronized void removeDataFromDisk(long l) {
        this.diskCacheSize -= l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CacheItem cacheItem, long l) {
        Object object;
        if (cacheItem.getUnsyncedState() == ItemState.DELETED) {
            return;
        }
        this.addDataOnDisk(l);
        if (cacheItem.getID().getType() == 1) {
            object = cacheItem.getID().getGroup();
            if (object == null) {
                object = cacheItem.getID().toString();
                object = ((String)object).substring(((String)object).indexOf(File.separatorChar) + 1);
            }
            LinkedHashMap<String, String> linkedHashMap = this.groups;
            synchronized (linkedHashMap) {
                this.groups.remove(object);
                this.groups.put((String)object, TOUCHED);
            }
        }
        object = this.items;
        synchronized (object) {
            this.items.put(cacheItem.getID(), cacheItem);
        }
    }

    public synchronized CacheItem sniffItem(CacheID cacheID) {
        return this.items.get(cacheID);
    }

    @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
    public synchronized void deleteItem(CacheItem cacheItem, boolean bl) {
        File file;
        this.items.remove(cacheItem.getID());
        this.deleteOccured = true;
        if ((bl || cacheItem.getID() instanceof GrouplessID || !this.cacheParameters.isPermanent()) && !(file = new File(String.valueOf(this.cacheParameters.getLocation()) + cacheItem.getID())).delete() && file.exists() && !file.delete()) {
            int n = 0;
            while (!file.delete() && n < 100) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
                ++n;
            }
        }
    }

    public synchronized void removeFromList(CacheItem cacheItem) {
        this.items.remove(cacheItem.getID());
    }

    public boolean exists(CacheID cacheID) {
        CacheItem cacheItem = this.items.get(cacheID);
        if (cacheItem != null) {
            return true;
        }
        if (cacheID.getType() == 1 && this.cacheParameters.isPermanent()) {
            File file = new File(String.valueOf(this.cacheParameters.getLocation()) + cacheID);
            return file.exists();
        }
        return false;
    }

    public void clearTempData() {
        File file = new File(String.valueOf(this.cacheParameters.getLocation()) + File.separatorChar + IDataCacheProvider.persistenceModifiers[0]);
        FileUtil.remove((File)file);
    }

    public void setDeleteOccured() {
        this.deleteOccured = true;
    }

    public void ensureDiskSizeWithFree() {
        File file = new File(this.cache.getParameters().getLocation());
        long l = 4000000000L;
        try {
            l = file.getFreeSpace();
        }
        catch (NoSuchMethodError noSuchMethodError) {}
        long l2 = this.cacheParameters.getMinimumFreeDisk();
        if (l < l2) {
            l -= 500000000L;
        }
        this.freeDiskSpace(Math.max(l2 - l, this.diskCacheSize - this.cacheParameters.getDiskSizeLimit()));
    }

    public boolean startupComplete() {
        return this.startupComplete;
    }

    private class DiskCacheInitializer
    implements Runnable {
        Map<String, String> notEraseable;
        private final long startup;
        private final boolean DEBUG = DiskItemsHash.access$0().isDebugEnabled();

        private DiskCacheInitializer(File file) {
            this.startup = System.currentTimeMillis();
            long l = 0L;
            if (this.DEBUG) {
                l = System.nanoTime();
            }
            File[] fileArray = file.listFiles();
            this.notEraseable = new HashMap<String, String>();
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                if (!file2.delete()) {
                    this.notEraseable.put(file2.getName().toLowerCase(Locale.getDefault()), file2.getName());
                }
                ++n2;
            }
            if (this.DEBUG) {
                l = (System.nanoTime() - l) / 1000000L;
                log.debug("Setup of not erasable groups took " + l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object;
                File[] fileArray;
                int n;
                Object object2;
                Serializable serializable;
                Object object3;
                File[] fileArray2;
                Thread.currentThread().setPriority(1);
                String string = DiskItemsHash.this.tokenPrefix.substring(0, DiskItemsHash.this.tokenPrefix.indexOf(64, 1) + 1).toLowerCase(Locale.getDefault());
                StringBuilder stringBuilder = null;
                long l = 0L;
                if (this.DEBUG) {
                    stringBuilder = new StringBuilder("Initialization of cache took (cleanup/content registration/cache structures/disk space check) ");
                    l = System.nanoTime();
                }
                File file = new File(String.valueOf(DiskItemsHash.this.cacheParameters.getLocation()) + File.separatorChar);
                log.info("Cache Folder:" + file.getAbsolutePath());
                if (DiskItemsHash.this.cacheParameters.isPermanent()) {
                    log.info("Session persistence activated. (Cache will be cleared on shutdown: {})", (Object)DiskItemsHash.this.cacheParameters.clearCacheOnShutdown());
                }
                if (file.exists()) {
                    fileArray2 = file.listFiles();
                    object3 = fileArray2;
                    int n2 = fileArray2.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        serializable = object3[n3];
                        object2 = ((File)serializable).getName().toLowerCase(Locale.getDefault());
                        n = 0;
                        if (((String)object2).startsWith(string)) {
                            n = 1;
                        }
                        if ((!DiskItemsHash.this.cacheParameters.isPermanent() || DiskItemsHash.this.cacheParameters.clearCacheOnShutdown()) && ((String)object2).equals(IDataCacheProvider.persistenceModifiers[1])) {
                            n = 1;
                        }
                        if (n != 0 && (this.notEraseable.isEmpty() || !this.notEraseable.containsKey(((String)object2).substring(0, ((String)object2).lastIndexOf(64) + 1)))) {
                            fileArray = ((File)serializable).listFiles();
                            if (fileArray != null) {
                                File[] fileArray3 = fileArray;
                                int n4 = fileArray.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    File[] fileArray4;
                                    object = fileArray3[n5];
                                    if (((File)object).isDirectory() && (fileArray4 = ((File)object).listFiles()) != null) {
                                        File[] fileArray5 = fileArray4;
                                        int n6 = fileArray4.length;
                                        int n7 = 0;
                                        while (n7 < n6) {
                                            File file2 = fileArray5[n7];
                                            file2.delete();
                                            ++n7;
                                        }
                                    }
                                    ((File)object).delete();
                                    ++n5;
                                }
                            }
                            ((File)serializable).delete();
                        }
                        ++n3;
                    }
                } else {
                    file.mkdirs();
                }
                if (this.DEBUG) {
                    l = (System.nanoTime() - l) / 1000000L;
                    stringBuilder.append(l);
                    l = System.nanoTime();
                }
                if (!(file = new File(String.valueOf(DiskItemsHash.this.cacheParameters.getLocation()) + File.separatorChar + IDataCacheProvider.persistenceModifiers[1])).exists()) {
                    file.mkdirs();
                }
                fileArray2 = file.listFiles();
                serializable = new ArrayList();
                long l2 = 0L;
                if (fileArray2 != null) {
                    fileArray = fileArray2;
                    n = fileArray2.length;
                    int n8 = 0;
                    while (n8 < n) {
                        object3 = fileArray[n8];
                        if (((File)object3).isDirectory()) {
                            object = ((File)object3).listFiles();
                            if (((File[])object).length == 0 && ((File)object3).lastModified() < this.startup) {
                                ((File)object3).delete();
                            } else {
                                ((ArrayList)serializable).add(object3);
                                l2 += this.registerGroupContent((File[])object);
                            }
                        }
                        ++n8;
                    }
                }
                if (this.DEBUG) {
                    l = (System.nanoTime() - l) / 1000000L;
                    stringBuilder.append("/").append(l);
                    l = System.nanoTime();
                }
                Collections.sort(serializable, new FileModifiedOrder());
                object3 = DiskItemsHash.this.groups;
                synchronized (object3) {
                    Iterator iterator = ((ArrayList)serializable).iterator();
                    while (iterator.hasNext()) {
                        object2 = (File)iterator.next();
                        if (DiskItemsHash.this.groups.containsKey(((File)object2).getName())) continue;
                        DiskItemsHash.this.groups.put(((File)object2).getName(), DiskItemsHash.NOT_TOUCHED);
                    }
                }
                DiskItemsHash.this.addDataOnDisk(l2);
                if (this.DEBUG) {
                    l = (System.nanoTime() - l) / 1000000L;
                    stringBuilder.append("/").append(l);
                    l = System.nanoTime();
                }
                DiskItemsHash.this.ensureDiskSizeWithFree();
                if (this.DEBUG) {
                    l = (System.nanoTime() - l) / 1000000L;
                    stringBuilder.append("/").append(l);
                    log.debug(stringBuilder.toString());
                }
                log.info("data in persistent files:" + DiskItemsHash.this.diskCacheSize);
            }
            finally {
                DiskItemsHash.this.startupComplete = true;
            }
        }

        private long registerGroupContent(File[] fileArray) {
            long l = 0L;
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray2[n2];
                l += file.length();
                ++n2;
            }
            return l;
        }
    }

    private static class FileModifiedOrder
    implements Comparator<File> {
        private FileModifiedOrder() {
        }

        @Override
        public int compare(File file, File file2) {
            long l;
            long l2 = file.lastModified();
            if (l2 < (l = file2.lastModified())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
    }
}

