/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.GrouplessID;
import com.agfa.pacs.cache.ICacheItemGroup;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.cache.IMemoryAlertListener;
import com.agfa.pacs.cache.NoHandlerForObjectException;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.ICachedObjectHandler;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.Iterator;

public class DummyDataCache
implements IDataCacheProvider {
    Hashtable<CacheID, SoftReference<?>> personalized = new Hashtable();
    Hashtable<CacheID, Object> persistent = new Hashtable();
    Hashtable<Class<?>, ICachedObjectHandler> handlers = new Hashtable();
    int id;

    public void addHandler(Class<?> clazz, ICachedObjectHandler iCachedObjectHandler) {
        this.handlers.put(clazz, iCachedObjectHandler);
    }

    public synchronized GrouplessID createID() {
        ++this.id;
        return new GrouplessID(Integer.toString(this.id));
    }

    public GrouplessID createNewTemporaryCacheID() {
        return this.createID();
    }

    public synchronized CacheID createID(String string, String string2, int n) {
        ++this.id;
        return new GrouplessID(Integer.toString(this.id));
    }

    public byte[] allocBytes(long l) {
        return new byte[(int)l];
    }

    public byte[] allocAndClearBytes(long l) {
        return new byte[(int)l];
    }

    public void free(byte[] byArray) {
    }

    public byte[] getContentBytes(CacheID cacheID) {
        SoftReference<?> softReference = this.personalized.get(cacheID);
        if (softReference == null) {
            return null;
        }
        return (byte[])softReference.get();
    }

    public byte[] referencePersistentBytes(CacheID cacheID) {
        return (byte[])this.persistent.get(cacheID);
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID) {
        this.personalized.put(cacheID, new SoftReference<byte[]>(byArray));
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID) {
        this.persistent.put(cacheID, byArray);
    }

    public void releaseModifiedReference(CacheID cacheID) {
    }

    public void releaseModifiedArrayReference(CacheID cacheID, long[] lArray, long[] lArray2) {
    }

    public short[] allocShorts(long l) {
        return new short[(int)l];
    }

    public short[] allocAndClearShorts(long l) {
        return new short[(int)l];
    }

    public void free(short[] sArray) {
    }

    public short[] getContentShorts(CacheID cacheID) {
        SoftReference<?> softReference = this.personalized.get(cacheID);
        if (softReference == null) {
            return null;
        }
        return (short[])softReference.get();
    }

    public short[] referencePersistentShorts(CacheID cacheID) {
        return (short[])this.persistent.get(cacheID);
    }

    public void putContentShorts(short[] sArray, CacheID cacheID) {
        this.personalized.put(cacheID, new SoftReference<short[]>(sArray));
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID) {
        this.persistent.put(cacheID, sArray);
    }

    public int[] allocInts(long l) {
        return new int[(int)l];
    }

    public int[] allocAndClearInts(long l) {
        return new int[(int)l];
    }

    public void free(int[] nArray) {
    }

    public double[] allocDoubles(long l) {
        return new double[(int)l];
    }

    public double[] allocAndClearDoubles(long l) {
        return new double[(int)l];
    }

    public void free(double[] dArray) {
    }

    public float[] allocFloats(long l) {
        return new float[(int)l];
    }

    public float[] allocAndClearFloats(long l) {
        return new float[(int)l];
    }

    public void free(float[] fArray) {
    }

    public int[] getContentInts(CacheID cacheID) {
        SoftReference<?> softReference = this.personalized.get(cacheID);
        if (softReference == null) {
            return null;
        }
        return (int[])softReference.get();
    }

    public int[] referencePersistentInts(CacheID cacheID) {
        return (int[])this.persistent.get(cacheID);
    }

    public void putContentInts(int[] nArray, CacheID cacheID) {
        this.personalized.put(cacheID, new SoftReference<int[]>(nArray));
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID) {
        this.persistent.put(cacheID, nArray);
    }

    public float[] getContentFloats(CacheID cacheID) {
        SoftReference<?> softReference = this.personalized.get(cacheID);
        if (softReference == null) {
            return null;
        }
        return (float[])softReference.get();
    }

    public float[] referencePersistentFloats(CacheID cacheID) {
        return (float[])this.persistent.get(cacheID);
    }

    public void putContentFloats(float[] fArray, CacheID cacheID) {
        this.personalized.put(cacheID, new SoftReference<float[]>(fArray));
    }

    public void addPersistentFloats(float[] fArray, CacheID cacheID) {
        this.persistent.put(cacheID, fArray);
    }

    public double[] getContentDoubles(CacheID cacheID) {
        SoftReference<?> softReference = this.personalized.get(cacheID);
        if (softReference == null) {
            return null;
        }
        return (double[])softReference.get();
    }

    public double[] referencePersistentDoubles(CacheID cacheID) {
        return (double[])this.persistent.get(cacheID);
    }

    public void putContentDoubles(double[] dArray, CacheID cacheID) {
        this.personalized.put(cacheID, new SoftReference<double[]>(dArray));
    }

    public void addPersistentDoubles(double[] dArray, CacheID cacheID) {
        this.persistent.put(cacheID, dArray);
    }

    public Object allocObject(Class<?> clazz, Object[] objectArray) {
        return this.allocObjectInternal(clazz, objectArray, false);
    }

    public Object allocAndClearObject(Class<?> clazz, Object[] objectArray) {
        return this.allocObjectInternal(clazz, objectArray, true);
    }

    private Object allocObjectInternal(Class<?> clazz, Object[] objectArray, boolean bl) {
        ICachedObjectHandler iCachedObjectHandler = this.handlers.get(clazz);
        if (iCachedObjectHandler == null) {
            throw new NoHandlerForObjectException();
        }
        Object object = iCachedObjectHandler.getGroupID(objectArray);
        ICachedObjectGroup iCachedObjectGroup = iCachedObjectHandler.createGroup(object, objectArray);
        Object object2 = iCachedObjectGroup.allocateObject(bl, 0);
        return object2;
    }

    public void free(Object object) {
    }

    public Object getContentObject(CacheID cacheID) {
        SoftReference<?> softReference = this.personalized.get(cacheID);
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    public Object referencePersistentObject(CacheID cacheID, Class<?> clazz) {
        return this.persistent.get(cacheID);
    }

    public void putContentObject(Object object, CacheID cacheID) {
        this.personalized.put(cacheID, new SoftReference<Object>(object));
    }

    public void addPersistentObject(Object object, CacheID cacheID) {
        this.persistent.put(cacheID, object);
    }

    public Iterator<ICacheItemGroup> listItemGroups() {
        return null;
    }

    public boolean exists(Class<?> clazz, CacheID cacheID) {
        return false;
    }

    public boolean isInCache(Class<?> clazz, CacheID cacheID) {
        return this.exists(clazz, cacheID);
    }

    public void remove(CacheID cacheID) {
    }

    public void removeTemporary(GrouplessID grouplessID) {
    }

    public void flush(CacheID cacheID) {
    }

    public void flushGroup(Class<?> clazz, CacheID cacheID) {
    }

    public void addMemoryAlertListener(IMemoryAlertListener iMemoryAlertListener) {
    }

    public void ensureFreeMemory(long l) {
    }

    public void addPersistentMemoryAlertListener(IMemoryAlertListener iMemoryAlertListener) {
    }

    public void releaseReference(CacheID cacheID) {
    }

    public void erase(CacheID cacheID) {
    }

    public void flushAll() {
    }

    public boolean isInMemory(CacheID cacheID) {
        return true;
    }

    public void addPersistentObject(Object object, Class<?> clazz, CacheID cacheID) {
        this.persistent.put(cacheID, object);
    }

    public void setItemPriority(CacheID cacheID, int n) {
    }

    public int getItemPriority(CacheID cacheID) {
        return 0;
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID, int n) {
        this.putContentBytes(byArray, cacheID);
    }

    public void putContentInts(int[] nArray, CacheID cacheID, int n) {
        this.putContentInts(nArray, cacheID);
    }

    public void putContentShorts(short[] sArray, CacheID cacheID, int n) {
        this.putContentShorts(sArray, cacheID);
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID, int n) {
        this.addPersistentBytes(byArray, cacheID);
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID, int n) {
        this.addPersistentInts(nArray, cacheID);
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID, int n) {
        this.addPersistentShorts(sArray, cacheID);
    }

    public byte[] allocBytes(long l, int n) {
        return this.allocBytes(l);
    }

    public int[] allocInts(long l, int n) {
        return this.allocInts(l);
    }

    public short[] allocShorts(long l, int n) {
        return this.allocShorts(l);
    }

    public long availableMemory(int n) {
        return Runtime.getRuntime().freeMemory() + (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory());
    }

    public long getFreeMemory() {
        return this.availableMemory(30);
    }

    public void addPersistentObject(Object object, CacheID cacheID, int n) {
    }

    public boolean isPoolActive(Object object, CacheID cacheID) {
        Class<?> clazz = object.getClass();
        if (clazz.equals(Byte.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Double.TYPE)) {
            return false;
        }
        ICachedObjectHandler iCachedObjectHandler = this.handlers.get(object);
        if (iCachedObjectHandler == null) {
            return false;
        }
        ICachedObjectGroup iCachedObjectGroup = iCachedObjectHandler.createGroup((Object)cacheID, object);
        return iCachedObjectGroup.usesPool();
    }

    public File getFile(CacheID cacheID, Class<?> clazz) {
        return null;
    }

    public String getGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
        return null;
    }

    public void setGroupAttribute(CacheID cacheID, Class<?> clazz, String string, String string2) {
    }

    public void deleteGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
    }

    public ICacheItemGroup getItemGroup(String string) {
        throw new UnsupportedOperationException("not implemented for agility");
    }
}

