/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.tools.PriorityQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class GlobalLRU {
    private static final ALogger LOGGER = ALogger.getLogger(GlobalLRU.class);
    private Map<CacheID, CacheItem> id2item = new HashMap<CacheID, CacheItem>();
    private PriorityQueue<CacheItem> lru = new PriorityQueue(31, 31);
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private List<DelayedWriteJob> queuedWrites = new ArrayList<DelayedWriteJob>();
    private volatile boolean isPlayingBack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAsyncWithReadlock(DelayedWriteJob delayedWriteJob) {
        if (this.readLock.tryLock()) {
            boolean bl;
            try {
                delayedWriteJob.commit();
            }
            catch (Throwable throwable) {
                boolean bl2;
                this.readLock.unlock();
                List<DelayedWriteJob> list = this.queuedWrites;
                synchronized (list) {
                    bl2 = !this.queuedWrites.isEmpty();
                }
                if (bl2) {
                    this.lockForWrite();
                    this.unlockForWrite();
                }
                throw throwable;
            }
            this.readLock.unlock();
            List<DelayedWriteJob> list = this.queuedWrites;
            synchronized (list) {
                bl = !this.queuedWrites.isEmpty();
            }
            if (bl) {
                this.lockForWrite();
                this.unlockForWrite();
            }
        } else {
            boolean bl = false;
            List<DelayedWriteJob> list = this.queuedWrites;
            synchronized (list) {
                if (this.readLock.tryLock()) {
                    bl = true;
                } else {
                    this.queuedWrites.add(delayedWriteJob);
                }
            }
            if (bl) {
                boolean bl3;
                try {
                    delayedWriteJob.commit();
                }
                catch (Throwable throwable) {
                    boolean bl4;
                    this.readLock.unlock();
                    List<DelayedWriteJob> list2 = this.queuedWrites;
                    synchronized (list2) {
                        bl4 = !this.queuedWrites.isEmpty();
                    }
                    if (bl4) {
                        this.lockForWrite();
                        this.unlockForWrite();
                    }
                    throw throwable;
                }
                this.readLock.unlock();
                List<DelayedWriteJob> list3 = this.queuedWrites;
                synchronized (list3) {
                    bl3 = !this.queuedWrites.isEmpty();
                }
                if (bl3) {
                    this.lockForWrite();
                    this.unlockForWrite();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CacheItem cacheItem) {
        if (this.writeLock.tryLock()) {
            try {
                this.lru.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
            }
            finally {
                this.unlockForWrite();
            }
        }
        List<DelayedWriteJob> list = this.queuedWrites;
        synchronized (list) {
            if (this.writeLock.tryLock()) {
                try {
                    this.lru.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.queuedWrites.add(new DelayedPutJob(cacheItem));
            }
        }
    }

    public void put(CacheID cacheID, CacheItem cacheItem) {
        this.writeLock.lock();
        try {
            CacheItem cacheItem2 = this.id2item.remove(cacheID);
            if (cacheItem2 != null && cacheItem2.getManagementGroup() != cacheItem.getManagementGroup()) {
                LOGGER.debug("group change for " + cacheItem.getID());
                cacheItem2.getManagementGroup().removeItem(cacheItem2);
                this.lru.removeAndGetUnsynced((Object)cacheItem2);
            }
            this.id2item.put(cacheID, cacheItem);
            this.lru.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
        }
        finally {
            this.unlockForWrite();
        }
    }

    public void putUnsynced(CacheID cacheID, CacheItem cacheItem) {
        CacheItem cacheItem2 = this.id2item.remove(cacheID);
        if (cacheItem2 != null && cacheItem2.getManagementGroup() != cacheItem.getManagementGroup()) {
            LOGGER.debug("group change for " + cacheItem.getID());
            cacheItem2.getManagementGroup().removeItem(cacheItem2);
            this.lru.removeAndGetUnsynced((Object)cacheItem2);
        }
        this.id2item.put(cacheID, cacheItem);
        this.lru.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
    }

    public CacheItem get(CacheID cacheID) {
        this.readLock.lock();
        try {
            CacheItem cacheItem = this.id2item.get(cacheID);
            return cacheItem;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public CacheItem getUnsynced(CacheID cacheID) {
        return this.id2item.get(cacheID);
    }

    public boolean hasItem(CacheID cacheID) {
        this.readLock.lock();
        try {
            boolean bl = this.id2item.containsKey(cacheID);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(CacheItem cacheItem) {
        if (this.writeLock.tryLock()) {
            try {
                this.lru.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
            }
            finally {
                this.unlockForWrite();
            }
        }
        List<DelayedWriteJob> list = this.queuedWrites;
        synchronized (list) {
            if (this.writeLock.tryLock()) {
                try {
                    this.lru.addAtBottomUnsynced((Object)cacheItem, cacheItem.getPriority());
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.queuedWrites.add(new DelayedTouchJob(cacheItem));
            }
        }
    }

    public Set<String> getGroupNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (CacheID cacheID : this.id2item.keySet()) {
            hashSet.add(cacheID.getGroup());
        }
        return hashSet;
    }

    public Iterator<CacheItem> getItemIterator(int n) {
        return this.lru.iterator(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CacheItem cacheItem) {
        if (this.writeLock.tryLock()) {
            try {
                this.id2item.remove(cacheItem.getID());
                this.lru.removeAndGetUnsynced((Object)cacheItem);
            }
            finally {
                this.unlockForWrite();
            }
        }
        List<DelayedWriteJob> list = this.queuedWrites;
        synchronized (list) {
            if (this.writeLock.tryLock()) {
                try {
                    this.id2item.remove(cacheItem.getID());
                    this.lru.removeAndGetUnsynced((Object)cacheItem);
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.queuedWrites.add(new DelayedRemoveJob(cacheItem));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAll(List<CacheItem> list) {
        if (this.writeLock.tryLock()) {
            try {
                this.doRemoveAll(list);
            }
            finally {
                this.unlockForWrite();
            }
        }
        List<DelayedWriteJob> list2 = this.queuedWrites;
        synchronized (list2) {
            if (this.writeLock.tryLock()) {
                try {
                    this.doRemoveAll(list);
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.queuedWrites.add(new DelayedRemoveAllJob(list));
            }
        }
    }

    private void doRemoveAll(List<CacheItem> list) {
        int n = 0;
        while (n < list.size()) {
            CacheItem cacheItem = list.get(n);
            this.id2item.remove(cacheItem.getID());
            this.lru.removeAndGetUnsynced((Object)cacheItem);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnonymousSynced(CacheItem cacheItem) {
        if (this.writeLock.tryLock()) {
            try {
                this.lru.remove((Object)cacheItem);
            }
            finally {
                this.unlockForWrite();
            }
        }
        List<DelayedWriteJob> list = this.queuedWrites;
        synchronized (list) {
            if (this.writeLock.tryLock()) {
                try {
                    this.lru.remove((Object)cacheItem);
                }
                finally {
                    this.unlockForWrite();
                }
            } else {
                this.queuedWrites.add(new DelayedRemoveAnonymousJob(cacheItem));
            }
        }
    }

    public CacheItem consumeSynced(CacheID cacheID) {
        this.writeLock.lock();
        try {
            CacheItem cacheItem = this.id2item.remove(cacheID);
            this.lru.removeAndGetUnsynced((Object)cacheItem);
            CacheItem cacheItem2 = cacheItem;
            return cacheItem2;
        }
        finally {
            this.unlockForWrite();
        }
    }

    public void dumpContent(boolean bl) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        this.readLock.lock();
        try {
            if (!bl) {
                LOGGER.debug("size:" + this.id2item.size());
            } else {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (CacheItem cacheItem : this.id2item.values()) {
                    ItemState itemState = cacheItem.getUnsyncedState();
                    if (itemState == ItemState.ANONYMOUS) {
                        ++n;
                        continue;
                    }
                    if (itemState == ItemState.PERSONALIZED) {
                        if (cacheItem.dataAvailableUnsynced()) {
                            ++n3;
                            continue;
                        }
                        ++n2;
                        continue;
                    }
                    if (itemState != ItemState.PERSISTENT) continue;
                    ++n4;
                }
                LOGGER.debug("CACHE CONTENT: a=" + n + " pu=" + n2 + " pr=" + n3 + " pers=" + n4);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int size() {
        return this.id2item.size();
    }

    public void lockForWrite() {
        this.writeLock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void unlockForWrite() {
        block6: {
            if (this.isPlayingBack) break block6;
            this.isPlayingBack = true;
            var2_1 = 0;
            while (true) {
                var3_3 = this.queuedWrites;
                synchronized (var3_3) {
                    var1_2 = this.queuedWrites.size();
                    if (var1_2 == var2_1) {
                        this.writeLock.unlock();
                        this.queuedWrites.clear();
                        this.isPlayingBack = false;
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (true) ** GOTO lbl22
                }
                do {
                    var3_3 = this.queuedWrites.get(var2_1);
                    var3_3.commit();
                    ++var2_1;
lbl22:
                    // 2 sources

                } while (var2_1 < var1_2);
            }
        }
        this.writeLock.unlock();
    }

    public void lockForRead() {
        this.readLock.lock();
    }

    public void unlockForRead() {
        this.readLock.unlock();
    }

    private class DelayedPutJob
    extends DelayedWriteJob {
        private final CacheItem item;

        public DelayedPutJob(CacheItem cacheItem) {
            this.item = cacheItem;
        }

        @Override
        public void commit() {
            GlobalLRU.this.lru.addAtBottomUnsynced((Object)this.item, this.item.getPriority());
        }
    }

    private class DelayedRemoveAllJob
    extends DelayedWriteJob {
        private final List<CacheItem> items;

        public DelayedRemoveAllJob(List<CacheItem> list) {
            this.items = list;
        }

        @Override
        public void commit() {
            GlobalLRU.this.doRemoveAll(this.items);
        }
    }

    private class DelayedRemoveAnonymousJob
    extends DelayedWriteJob {
        private final CacheItem item;

        public DelayedRemoveAnonymousJob(CacheItem cacheItem) {
            this.item = cacheItem;
        }

        @Override
        public void commit() {
            GlobalLRU.this.lru.remove((Object)this.item);
        }
    }

    private class DelayedRemoveJob
    extends DelayedWriteJob {
        private final CacheItem item;

        public DelayedRemoveJob(CacheItem cacheItem) {
            this.item = cacheItem;
        }

        @Override
        public void commit() {
            GlobalLRU.this.id2item.remove(this.item.getID());
            GlobalLRU.this.lru.removeAndGetUnsynced((Object)this.item);
        }
    }

    private class DelayedTouchJob
    extends DelayedWriteJob {
        private final CacheItem item;

        public DelayedTouchJob(CacheItem cacheItem) {
            this.item = cacheItem;
        }

        @Override
        public void commit() {
            GlobalLRU.this.lru.addAtBottomUnsynced((Object)this.item, this.item.getPriority());
        }
    }

    public static abstract class DelayedWriteJob {
        public abstract void commit();
    }
}

