/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ICachedObjectGroup;
import com.agfa.pacs.memcache.internal.CachedByteGroup;
import com.agfa.pacs.memcache.internal.CachedDoubleGroup;
import com.agfa.pacs.memcache.internal.CachedFloatGroup;
import com.agfa.pacs.memcache.internal.CachedIntGroup;
import com.agfa.pacs.memcache.internal.CachedShortGroup;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class GroupHash
extends LinkedHashMap<Object, ICachedObjectGroup> {
    public static final long BYTE_PREFIX = Long.MIN_VALUE;
    public static final long SHORT_PREFIX = 0x4000000000000000L;
    public static final long INT_PREFIX = -4611686018427387904L;
    public static final long FLOAT_PREFIX = -2305843009213693952L;
    public static final long DOUBLE_PREFIX = -1152921504606846976L;
    private final transient DataCache cache;

    public GroupHash(DataCache dataCache) {
        super(331, 0.75f, true);
        this.cache = dataCache;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Object, ICachedObjectGroup> entry) {
        ICachedObjectGroup iCachedObjectGroup = entry.getValue();
        if (this.size() < 100) {
            return false;
        }
        if (iCachedObjectGroup.isEmpty()) {
            iCachedObjectGroup.dispose();
            return true;
        }
        this.get(entry.getKey());
        return false;
    }

    public synchronized ICachedObjectGroup getByteGroup(long l) {
        Long l2 = Long.MIN_VALUE | l;
        ICachedObjectGroup iCachedObjectGroup = (ICachedObjectGroup)this.get(l2);
        if (iCachedObjectGroup == null) {
            iCachedObjectGroup = new CachedByteGroup(l, this.cache);
            this.put(l2, iCachedObjectGroup);
        }
        return iCachedObjectGroup;
    }

    public synchronized ICachedObjectGroup getShortGroup(long l) {
        Long l2 = 0x4000000000000000L | l;
        ICachedObjectGroup iCachedObjectGroup = (ICachedObjectGroup)this.get(l2);
        if (iCachedObjectGroup == null) {
            iCachedObjectGroup = new CachedShortGroup(l, this.cache);
            this.put(l2, iCachedObjectGroup);
        }
        return iCachedObjectGroup;
    }

    public synchronized ICachedObjectGroup getIntGroup(long l) {
        Long l2 = 0xC000000000000000L | l;
        ICachedObjectGroup iCachedObjectGroup = (ICachedObjectGroup)this.get(l2);
        if (iCachedObjectGroup == null) {
            iCachedObjectGroup = new CachedIntGroup(l, this.cache);
            this.put(l2, iCachedObjectGroup);
        }
        return iCachedObjectGroup;
    }

    public synchronized ICachedObjectGroup getFloatGroup(long l) {
        Long l2 = 0xE000000000000000L | l;
        ICachedObjectGroup iCachedObjectGroup = (ICachedObjectGroup)this.get(l2);
        if (iCachedObjectGroup == null) {
            iCachedObjectGroup = new CachedFloatGroup(l, this.cache);
            this.put(l2, iCachedObjectGroup);
        }
        return iCachedObjectGroup;
    }

    public synchronized ICachedObjectGroup getDoubleGroup(long l) {
        Long l2 = 0xF000000000000000L | l;
        ICachedObjectGroup iCachedObjectGroup = (ICachedObjectGroup)this.get(l2);
        if (iCachedObjectGroup == null) {
            iCachedObjectGroup = new CachedDoubleGroup(l, this.cache);
            this.put(l2, iCachedObjectGroup);
        }
        return iCachedObjectGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeEmptyGroups() {
        HashMap<Object, ICachedObjectGroup> hashMap;
        Map.Entry<Object, ICachedObjectGroup> entry2 = this;
        synchronized (entry2) {
            hashMap = new HashMap<Object, ICachedObjectGroup>(this);
        }
        for (Map.Entry<Object, ICachedObjectGroup> entry2 : hashMap.entrySet()) {
            ICachedObjectGroup iCachedObjectGroup = (ICachedObjectGroup)entry2.getValue();
            if (!iCachedObjectGroup.isEmpty()) continue;
            GroupHash groupHash = this;
            synchronized (groupHash) {
                this.remove(entry2.getKey());
                iCachedObjectGroup.dispose();
            }
        }
    }
}

