/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.internal.PoolGuard;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class MemoryManagementLink {
    private static final ALogger LOGGER = ALogger.getLogger(MemoryManagementLink.class);
    private static long keepFreeMin;
    private static final boolean REGISTER_MEMORY_LINKS = false;

    public static long getFreeMin() {
        return keepFreeMin;
    }

    public static void init(DataCache dataCache, PoolGuard poolGuard) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)memoryMXBean);
        UsageThresholdListener usageThresholdListener = new UsageThresholdListener(dataCache, poolGuard);
        notificationEmitter.addNotificationListener(usageThresholdListener, null, null);
        List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : list) {
            if (!memoryPoolMXBean.getName().contains("Eden Space") || memoryPoolMXBean.getUsage().getMax() <= 0L) continue;
            keepFreeMin = memoryPoolMXBean.getUsage().getMax();
            dataCache.getParameters().updateEdenSpace(keepFreeMin);
        }
    }

    public static void dumpUsageInfo() {
        try {
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : list) {
                LOGGER.debug(String.valueOf(memoryPoolMXBean.getName()) + " usage:" + memoryPoolMXBean.getUsage());
            }
        }
        catch (Throwable throwable) {}
    }

    private static class UsageThresholdListener
    implements NotificationListener {
        private final PoolGuard guard;
        private final DataCache dataCache;
        private final long[] cleanupLengthTrack = new long[10];
        private final long[] cleanupTimeTrack = new long[10];
        private int trackIndex;

        private UsageThresholdListener(DataCache dataCache, PoolGuard poolGuard) {
            this.dataCache = dataCache;
            this.guard = poolGuard;
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            String string = notification.getType();
            if (string.equals("java.management.memory.threshold.exceeded")) {
                LOGGER.warn("mem threshold exceeded");
                this.cleanupTimeTrack[this.trackIndex] = System.currentTimeMillis();
                this.guard.writePersistentQueueContent(false);
                this.cleanupLengthTrack[this.trackIndex] = System.currentTimeMillis() - this.cleanupTimeTrack[this.trackIndex];
                long l = this.cleanupTimeTrack[this.trackIndex] + this.cleanupLengthTrack[this.trackIndex] - this.cleanupTimeTrack[(this.trackIndex + this.cleanupLengthTrack.length - 1) % this.cleanupLengthTrack.length];
                long l2 = 0L;
                int n = 0;
                while (n < this.cleanupLengthTrack.length) {
                    l2 += this.cleanupLengthTrack[n];
                    ++n;
                }
                if ((double)l2 > 0.8 * (double)l) {
                    IEvent iEvent = EventEngineFactory.getInstance().createInternalEvent(ApplicationManagement.APP_MEMORY_PANIC);
                    iEvent.setDestination(null, "application.management");
                    EventEngineFactory.getInstance().sendEvent(iEvent);
                }
                LOGGER.debug(String.valueOf(this.cleanupLengthTrack[this.trackIndex]) + "ms, total ratio " + (double)l2 / (double)l);
            } else if (string.equals("java.management.memory.collection.threshold.exceeded")) {
                this.guard.writePersistentQueueContent(false);
                long l = this.dataCache.getParameters().toFreeOnCollectionThresholdNotif();
                LOGGER.warn("mem collection threshold exceeded, free " + l);
                long l3 = System.currentTimeMillis();
                this.dataCache.ensureFreeMemory(l);
                LOGGER.debug(", " + (System.currentTimeMillis() - l3) + "ms");
            }
        }
    }
}

