/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.GrouplessID;
import com.agfa.pacs.cache.ICacheItemGroup;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.DataCache;
import java.io.File;
import java.util.Iterator;

public class PerformanceTrackingCache
implements IDataCacheProvider {
    private static long MAX_DURATION = 100L;
    private static ALogger logger = ALogger.getLogger(PerformanceTrackingCache.class);
    private final IDataCacheProvider delegate = new DataCache();

    public void addPersistentBytes(byte[] byArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentBytes(byArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID, int n) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentBytes(byArray, cacheID, n);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentDoubles(double[] dArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentDoubles(dArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentFloats(float[] fArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentFloats(fArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentInts(nArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID, int n) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentInts(nArray, cacheID, n);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentObject(Object object, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentObject(object, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentObject(Object object, CacheID cacheID, int n) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentObject(object, cacheID, n);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentObject(Object object, Class<?> clazz, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentObject(object, clazz, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentShorts(sArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID, int n) {
        long l = System.currentTimeMillis();
        this.delegate.addPersistentShorts(sArray, cacheID, n);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public byte[] allocAndClearBytes(long l) {
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.delegate.allocAndClearBytes(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return byArray;
    }

    public double[] allocAndClearDoubles(long l) {
        long l2 = System.currentTimeMillis();
        double[] dArray = this.delegate.allocAndClearDoubles(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return dArray;
    }

    public float[] allocAndClearFloats(long l) {
        long l2 = System.currentTimeMillis();
        float[] fArray = this.delegate.allocAndClearFloats(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return fArray;
    }

    public int[] allocAndClearInts(long l) {
        long l2 = System.currentTimeMillis();
        int[] nArray = this.delegate.allocAndClearInts(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return nArray;
    }

    public short[] allocAndClearShorts(long l) {
        long l2 = System.currentTimeMillis();
        short[] sArray = this.delegate.allocAndClearShorts(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return sArray;
    }

    public byte[] allocBytes(long l) {
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.delegate.allocBytes(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return byArray;
    }

    public byte[] allocBytes(long l, int n) {
        long l2 = System.currentTimeMillis();
        byte[] byArray = this.delegate.allocBytes(l, n);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return byArray;
    }

    public double[] allocDoubles(long l) {
        long l2 = System.currentTimeMillis();
        double[] dArray = this.delegate.allocDoubles(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return dArray;
    }

    public float[] allocFloats(long l) {
        long l2 = System.currentTimeMillis();
        float[] fArray = this.delegate.allocFloats(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return fArray;
    }

    public int[] allocInts(long l) {
        long l2 = System.currentTimeMillis();
        int[] nArray = this.delegate.allocInts(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return nArray;
    }

    public int[] allocInts(long l, int n) {
        long l2 = System.currentTimeMillis();
        int[] nArray = this.delegate.allocInts(l, n);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return nArray;
    }

    public Object allocObject(Class<?> clazz, Object[] objectArray) {
        long l = System.currentTimeMillis();
        Object object = this.delegate.allocObject(clazz, objectArray);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return object;
    }

    public Object allocAndClearObject(Class<?> clazz, Object[] objectArray) {
        long l = System.currentTimeMillis();
        Object object = this.delegate.allocAndClearObject(clazz, objectArray);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return object;
    }

    public short[] allocShorts(long l) {
        long l2 = System.currentTimeMillis();
        short[] sArray = this.delegate.allocShorts(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return sArray;
    }

    public short[] allocShorts(long l, int n) {
        long l2 = System.currentTimeMillis();
        short[] sArray = this.delegate.allocShorts(l, n);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return sArray;
    }

    public long availableMemory(int n) {
        long l = System.currentTimeMillis();
        long l2 = this.delegate.availableMemory(n);
        long l3 = System.currentTimeMillis();
        if (l3 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return l2;
    }

    public CacheID createID() {
        return this.delegate.createID();
    }

    public GrouplessID createNewTemporaryCacheID() {
        return this.delegate.createNewTemporaryCacheID();
    }

    public CacheID createID(String string, String string2, int n) {
        return this.delegate.createID(string, string2, n);
    }

    public void ensureFreeMemory(long l) {
        long l2 = System.currentTimeMillis();
        this.delegate.ensureFreeMemory(l);
        long l3 = System.currentTimeMillis();
        if (l3 - l2 > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l2) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public boolean exists(Class<?> clazz, CacheID cacheID) {
        long l = System.currentTimeMillis();
        boolean bl = this.delegate.exists(clazz, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return bl;
    }

    public void flush(CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.flush(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void flushGroup(Class<?> clazz, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.flushGroup(clazz, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void flushAll() {
        long l = System.currentTimeMillis();
        this.delegate.flushAll();
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void free(byte[] byArray) {
        long l = System.currentTimeMillis();
        this.delegate.free(byArray);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void free(short[] sArray) {
        long l = System.currentTimeMillis();
        this.delegate.free(sArray);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void free(int[] nArray) {
        long l = System.currentTimeMillis();
        this.delegate.free(nArray);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void free(float[] fArray) {
        long l = System.currentTimeMillis();
        this.delegate.free(fArray);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void free(double[] dArray) {
        long l = System.currentTimeMillis();
        this.delegate.free(dArray);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void free(Object object) {
        long l = System.currentTimeMillis();
        this.delegate.free(object);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public byte[] getContentBytes(CacheID cacheID) {
        long l = System.currentTimeMillis();
        byte[] byArray = this.delegate.getContentBytes(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return byArray;
    }

    public double[] getContentDoubles(CacheID cacheID) {
        long l = System.currentTimeMillis();
        double[] dArray = this.delegate.getContentDoubles(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return dArray;
    }

    public float[] getContentFloats(CacheID cacheID) {
        long l = System.currentTimeMillis();
        float[] fArray = this.delegate.getContentFloats(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return fArray;
    }

    public int[] getContentInts(CacheID cacheID) {
        long l = System.currentTimeMillis();
        int[] nArray = this.delegate.getContentInts(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return nArray;
    }

    public Object getContentObject(CacheID cacheID) {
        long l = System.currentTimeMillis();
        Object object = this.delegate.getContentObject(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return object;
    }

    public short[] getContentShorts(CacheID cacheID) {
        long l = System.currentTimeMillis();
        short[] sArray = this.delegate.getContentShorts(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return sArray;
    }

    public File getFile(CacheID cacheID, Class<?> clazz) {
        long l = System.currentTimeMillis();
        File file = this.delegate.getFile(cacheID, clazz);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return file;
    }

    public long getFreeMemory() {
        long l = System.currentTimeMillis();
        long l2 = this.delegate.getFreeMemory();
        long l3 = System.currentTimeMillis();
        if (l3 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l3 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return l2;
    }

    public int getItemPriority(CacheID cacheID) {
        long l = System.currentTimeMillis();
        int n = this.delegate.getItemPriority(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return n;
    }

    public boolean isInCache(Class<?> clazz, CacheID cacheID) {
        long l = System.currentTimeMillis();
        boolean bl = this.delegate.isInCache(clazz, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return bl;
    }

    public boolean isInMemory(CacheID cacheID) {
        long l = System.currentTimeMillis();
        boolean bl = this.delegate.isInMemory(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return bl;
    }

    public boolean isPoolActive(Object object, CacheID cacheID) {
        long l = System.currentTimeMillis();
        boolean bl = this.delegate.isPoolActive(object, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return bl;
    }

    public Iterator<ICacheItemGroup> listItemGroups() {
        long l = System.currentTimeMillis();
        Iterator iterator = this.delegate.listItemGroups();
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return iterator;
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.putContentBytes(byArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID, int n) {
        long l = System.currentTimeMillis();
        this.delegate.putContentBytes(byArray, cacheID, n);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void putContentDoubles(double[] dArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.putContentDoubles(dArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void putContentFloats(float[] fArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.putContentFloats(fArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void putContentInts(int[] nArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.putContentInts(nArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void putContentInts(int[] nArray, CacheID cacheID, int n) {
        long l = System.currentTimeMillis();
        this.delegate.putContentInts(nArray, cacheID, n);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void putContentObject(Object object, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.putContentObject(object, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void putContentShorts(short[] sArray, CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.putContentShorts(sArray, cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void putContentShorts(short[] sArray, CacheID cacheID, int n) {
        long l = System.currentTimeMillis();
        this.delegate.putContentShorts(sArray, cacheID, n);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public byte[] referencePersistentBytes(CacheID cacheID) {
        long l = System.currentTimeMillis();
        byte[] byArray = this.delegate.referencePersistentBytes(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return byArray;
    }

    public double[] referencePersistentDoubles(CacheID cacheID) {
        long l = System.currentTimeMillis();
        double[] dArray = this.delegate.referencePersistentDoubles(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return dArray;
    }

    public float[] referencePersistentFloats(CacheID cacheID) {
        long l = System.currentTimeMillis();
        float[] fArray = this.delegate.referencePersistentFloats(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return fArray;
    }

    public int[] referencePersistentInts(CacheID cacheID) {
        long l = System.currentTimeMillis();
        int[] nArray = this.delegate.referencePersistentInts(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return nArray;
    }

    public Object referencePersistentObject(CacheID cacheID, Class<?> clazz) {
        long l = System.currentTimeMillis();
        Object object = this.delegate.referencePersistentObject(cacheID, clazz);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return object;
    }

    public short[] referencePersistentShorts(CacheID cacheID) {
        long l = System.currentTimeMillis();
        short[] sArray = this.delegate.referencePersistentShorts(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return sArray;
    }

    public void releaseModifiedArrayReference(CacheID cacheID, long[] lArray, long[] lArray2) {
        long l = System.currentTimeMillis();
        this.delegate.releaseModifiedArrayReference(cacheID, lArray, lArray2);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void releaseModifiedReference(CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.releaseModifiedReference(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void releaseReference(CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.releaseReference(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void remove(CacheID cacheID) {
        long l = System.currentTimeMillis();
        this.delegate.remove(cacheID);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void removeTemporary(GrouplessID grouplessID) {
        this.remove((CacheID)grouplessID);
    }

    public void setItemPriority(CacheID cacheID, int n) {
        long l = System.currentTimeMillis();
        this.delegate.setItemPriority(cacheID, n);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public String getGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
        long l = System.currentTimeMillis();
        String string2 = this.delegate.getGroupAttribute(cacheID, clazz, string);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return string2;
    }

    public void setGroupAttribute(CacheID cacheID, Class<?> clazz, String string, String string2) {
        long l = System.currentTimeMillis();
        this.delegate.setGroupAttribute(cacheID, clazz, string, string2);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public void deleteGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
        long l = System.currentTimeMillis();
        this.delegate.deleteGroupAttribute(cacheID, clazz, string);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
    }

    public ICacheItemGroup getItemGroup(String string) {
        long l = System.currentTimeMillis();
        ICacheItemGroup iCacheItemGroup = this.delegate.getItemGroup(string);
        long l2 = System.currentTimeMillis();
        if (l2 - l > MAX_DURATION) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.fillInStackTrace();
            logger.warn("long call lasted " + (l2 - l) + "ms by " + Thread.currentThread().getName(), (Throwable)runtimeException);
        }
        return iCacheItemGroup;
    }
}

