/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.IMemoryAlertListener;
import com.agfa.pacs.cache.MemoryAlertHandler;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.CacheItem;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.IPersistenceQueue;
import com.agfa.pacs.memcache.ItemState;
import com.agfa.pacs.memcache.internal.GlobalLRU;
import com.agfa.pacs.memcache.internal.MemoryManagementLink;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PoolGuard
extends Thread
implements IMemoryAlertListener {
    private static final ALogger LOGGER = ALogger.getLogger(PoolGuard.class);
    private static long persistentAlertSize;
    private final DataCache dataCache;
    private AtomicInteger persistentOperation = new AtomicInteger();
    private volatile boolean shutdown = false;
    private Semaphore shutdownSemaphore = new Semaphore(0);
    int fcount = 0;

    public PoolGuard(DataCache dataCache) {
        super("PoolGuard");
        this.dataCache = dataCache;
        this.setDaemon(true);
        try {
            MemoryManagementLink.init(dataCache, this);
        }
        catch (Throwable throwable) {
            LOGGER.error("mem link init failed", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.runFinalization();
        int n = 0;
        ReferenceQueue<Object> referenceQueue = CacheItem.collectedItems;
        while (true) {
            if (this.shutdown) {
                this.shutdownSemaphore.release();
                return;
            }
            ++n;
            try {
                Reference<Object> reference = null;
                GlobalLRU globalLRU = this.dataCache.getGlobalLRU();
                do {
                    reference = referenceQueue.poll();
                    CacheItem.referenceDisposed(reference, globalLRU);
                } while (reference != null);
                if (n % 100 == 0) {
                    this.dataCache.purgeEmptyGroups();
                }
                if (persistentAlertSize > 0L && (persistentAlertSize = MemoryAlertHandler.firePersistentMemoryAlert((long)persistentAlertSize, (boolean)false)) < 1000000L) {
                    persistentAlertSize = 0L;
                }
                if (this.dataCache.getParameters().keepFootprintSmall()) {
                    IPersistenceQueue iPersistenceQueue;
                    IPersistenceQueue iPersistenceQueue2 = iPersistenceQueue = this.dataCache.getPersistenceQueue();
                    synchronized (iPersistenceQueue2) {
                        if (iPersistenceQueue.isEmpty()) {
                            iPersistenceQueue.wait();
                        } else {
                            this.setPriority(1);
                            this.writePersistentQueueContent(false);
                            this.setPriority(5);
                        }
                    }
                }
                long l = 0L;
                try {
                    Thread.sleep(Math.max(0L, 500L - l));
                }
                catch (InterruptedException interruptedException) {}
                l = System.currentTimeMillis();
                if (this.dataCache.getParameters().isWriteToDiskThresholdExceeded()) {
                    if (this.dataCache.getParameters().isFastCleanThresholdExceeded()) {
                        this.writePersistentQueueContent(true);
                    } else {
                        this.writePersistentQueueContent(false);
                    }
                }
                l = System.currentTimeMillis() - l;
                if (n % 100 != 0) continue;
                this.dataCache.getOnDisk().ensureDiskSizeWithFree();
                continue;
            }
            catch (ThreadDeath threadDeath) {
                this.shutdownSemaphore.release();
                return;
            }
            catch (Throwable throwable) {
                LOGGER.error("unknown error in pool guard!", throwable);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePersistentQueueContent(boolean bl) {
        IPersistenceQueue iPersistenceQueue = this.dataCache.getPersistenceQueue();
        if (iPersistenceQueue.isEmpty()) {
            return;
        }
        if (bl) {
            this.setPriority(10);
        }
        this.persistentOperation.incrementAndGet();
        try {
            while (!iPersistenceQueue.isEmpty()) {
                CacheItem cacheItem;
                IPersistenceQueue iPersistenceQueue2 = iPersistenceQueue;
                synchronized (iPersistenceQueue2) {
                    cacheItem = iPersistenceQueue.isEmpty() ? null : iPersistenceQueue.poll();
                }
                if (cacheItem == null) continue;
                cacheItem.writePersistent();
            }
        }
        finally {
            this.persistentOperation.decrementAndGet();
            if (bl) {
                this.setPriority(1);
            }
        }
    }

    public void waitUntilPersistentFinished() {
        while (this.persistentOperation.get() > 0) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void shutdownWithoutWriting() {
        this.shutdown = true;
        this.dataCache.getPersistenceQueue().clear();
        LOGGER.debug("Persistence queue cleared.");
        this.interrupt();
        try {
            boolean bl = this.shutdownSemaphore.tryAcquire(15L, TimeUnit.SECONDS);
            if (!bl) {
                LOGGER.warn("Shutdown semaphore could not be acquired within the waiting time.");
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.warn("Shutdown semaphore could not be acquired.");
        }
    }

    public long memoryAlert(long l, boolean bl) {
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        long l2 = this.freeMemory(l);
        return l - l2;
    }

    public long freeMemory(long l) {
        long l2;
        GlobalLRU globalLRU = this.dataCache.getGlobalLRU();
        if ((l = PoolGuard.claimAvailableItems(l, globalLRU, l2 = l)) <= 0L) {
            return l;
        }
        l = !this.dataCache.getParameters().usePersistentStorage() ? MemoryAlertHandler.firePersistentMemoryAlert((long)l, (boolean)true) : this.forceDataToDisk(l, globalLRU);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long forceDataToDisk(long l, GlobalLRU globalLRU) {
        CacheItem cacheItem;
        IPersistenceQueue iPersistenceQueue = this.dataCache.getPersistenceQueue();
        ArrayList<CacheItem> arrayList = null;
        do {
            IPersistenceQueue iPersistenceQueue2 = iPersistenceQueue;
            synchronized (iPersistenceQueue2) {
                cacheItem = iPersistenceQueue.isEmpty() ? null : iPersistenceQueue.poll();
                iPersistenceQueue.notify();
            }
            if (cacheItem == null) continue;
            globalLRU.lockForWrite();
            try {
                boolean bl = false;
                CacheItem cacheItem2 = cacheItem;
                synchronized (cacheItem2) {
                    if (cacheItem.getUnsyncedState() == ItemState.PERSISTENT && !cacheItem.isReferencedUnsynced()) {
                        cacheItem.addReferenceUnsynced();
                        bl = true;
                    }
                    cacheItem.notify();
                }
                if (bl) {
                    cacheItem.writePersistent();
                    cacheItem2 = cacheItem;
                    synchronized (cacheItem2) {
                        if (cacheItem.getUnsyncedState() == ItemState.PERSONALIZED) {
                            l -= cacheItem.getManagementGroup().getSizeEstimate(cacheItem.releaseReferenceAndClaimItemSynced());
                        }
                        continue;
                    }
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<CacheItem>();
                }
                arrayList.add(cacheItem);
            }
            finally {
                globalLRU.unlockForWrite();
            }
        } while (l > 0L && cacheItem != null);
        if (arrayList != null) {
            IPersistenceQueue iPersistenceQueue3 = iPersistenceQueue;
            synchronized (iPersistenceQueue3) {
                int n = 0;
                while (n < arrayList.size()) {
                    cacheItem = (CacheItem)arrayList.get(n);
                    iPersistenceQueue.addAtBottom(cacheItem);
                    ++n;
                }
            }
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long claimAvailableItems(long l, GlobalLRU globalLRU, long l2) {
        CacheItem cacheItem;
        ArrayList<CacheItem> arrayList = new ArrayList<CacheItem>(globalLRU.size());
        globalLRU.lockForRead();
        try {
            Iterator<CacheItem> iterator = globalLRU.getItemIterator(30);
            while (iterator.hasNext() && l2 > 0L) {
                cacheItem = iterator.next();
                if (!cacheItem.isClaimableAndHasDataUnsynced()) continue;
                arrayList.add(cacheItem);
                long l3 = cacheItem.getManagementGroup().getSizeEstimate(null);
                l2 -= l3;
            }
        }
        finally {
            globalLRU.unlockForRead();
        }
        int n = 0;
        while (n < arrayList.size()) {
            cacheItem = (CacheItem)arrayList.get(n);
            Object object = cacheItem.claimItemSynced();
            if (object != null) {
                globalLRU.remove(cacheItem);
                cacheItem.getManagementGroup().removeItem(cacheItem);
                l -= cacheItem.getManagementGroup().getSizeEstimate(null);
            }
            ++n;
        }
        return l;
    }

    public static void requestPersistentAlert(long l) {
        persistentAlertSize = l;
    }
}

