/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.memcache.CacheParameters;
import com.agfa.pacs.memcache.DataCache;

public class ShutdownHook
implements IEventListener {
    public boolean handleEvent(IEvent iEvent) {
        if (iEvent.getEventID() == ApplicationManagement.APP_SHUTDOWN) {
            DataCache dataCache = (DataCache)DataCacheProviderFactory.getCache();
            CacheParameters cacheParameters = dataCache.getParameters();
            if (cacheParameters.usePersistentStorage()) {
                dataCache.stopWriting();
                if (cacheParameters.isPermanent() && !cacheParameters.clearCacheOnShutdown()) {
                    dataCache.clearTempData();
                    dataCache.flushAll();
                } else {
                    dataCache.deleteCache();
                }
            }
            return true;
        }
        return false;
    }

    public IListenerSynchronization getSync() {
        return null;
    }
}

