/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.memcache.internal;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.GrouplessID;
import com.agfa.pacs.cache.ICacheItemGroup;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.DataCache;
import com.agfa.pacs.memcache.ItemState;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;

public class TrackingCache
implements IDataCacheProvider {
    private static final ALogger LOGGER = ALogger.getLogger(TrackingCache.class);
    private final IDataCacheProvider delegate;
    private final Hashtable<CacheID, CacheID> idCreationTracking = new Hashtable();
    private final Hashtable<CacheID, IssueRecord> issuedID2IR = new Hashtable();
    private final Hashtable<Object, IssueRecord> issuedObject2IR = new Hashtable();
    private final Hashtable<CacheID, IssueRecord> inCacheID2IR = new Hashtable();
    private final Hashtable<Object, IssueRecord> inCacheObject2IR = new Hashtable();

    public TrackingCache() {
        this.delegate = new DataCache();
    }

    public TrackingCache(IDataCacheProvider iDataCacheProvider) {
        this.delegate = iDataCacheProvider;
    }

    public CacheID createID() {
        CacheID cacheID = this.delegate.createID();
        if (this.idCreationTracking.contains(cacheID)) {
            throw new IllegalStateException("ID issued twice:" + cacheID);
        }
        this.idCreationTracking.put(cacheID, cacheID);
        return cacheID;
    }

    public GrouplessID createNewTemporaryCacheID() {
        GrouplessID grouplessID = this.delegate.createNewTemporaryCacheID();
        if (this.idCreationTracking.contains(grouplessID)) {
            throw new IllegalStateException("ID issued twice:" + grouplessID);
        }
        this.idCreationTracking.put((CacheID)grouplessID, (CacheID)grouplessID);
        return grouplessID;
    }

    public CacheID createID(String string, String string2, int n) {
        CacheID cacheID = this.delegate.createID(string, string2, n);
        if (this.idCreationTracking.contains(cacheID)) {
            throw new IllegalStateException("ID issued twice:" + cacheID);
        }
        this.idCreationTracking.put(cacheID, cacheID);
        return cacheID;
    }

    public byte[] allocBytes(long l) {
        byte[] byArray = this.delegate.allocBytes(l);
        this.allocCheck(byArray);
        return byArray;
    }

    private void allocCheck(Object object) {
        this.ensureNotOutside(object);
        IssueRecord issueRecord = this.inCacheObject2IR.remove(object);
        if (issueRecord != null) {
            this.inCacheID2IR.remove(issueRecord.getID());
            if (issueRecord.getType() == ItemState.PERSISTENT && issueRecord.getReferenceCount() > 0) {
                LOGGER.error(issueRecord.toString());
                throw new IllegalStateException("tried to reuse PERSISTENT object");
            }
        }
        IssueRecord issueRecord2 = new IssueRecord(new CacheID("anonymous", 0), object, ItemState.ANONYMOUS);
        this.issuedObject2IR.put(object, issueRecord2);
    }

    private void ensureNotOutside(Object object) {
        IssueRecord issueRecord = this.issuedObject2IR.get(object);
        if (issueRecord != null) {
            LOGGER.error(issueRecord.toString());
            throw new IllegalStateException("tried to return object already outside cache");
        }
    }

    public byte[] allocAndClearBytes(long l) {
        byte[] byArray = this.delegate.allocAndClearBytes(l);
        this.allocCheck(byArray);
        return byArray;
    }

    public void free(byte[] byArray) {
        this.freeCheck(byArray);
        this.delegate.free(byArray);
    }

    private void freeCheck(Object object) {
        IssueRecord issueRecord = this.issuedObject2IR.remove(object);
        if (issueRecord != null && issueRecord.getType().equals((Object)ItemState.PERSISTENT)) {
            LOGGER.error(issueRecord.toString());
            throw new IllegalStateException("free of PERSISTENT object");
        }
        IssueRecord issueRecord2 = this.inCacheObject2IR.remove(object);
        if (issueRecord2 != null) {
            LOGGER.error(issueRecord2.toString());
            throw new IllegalStateException("free of PERSISTENT object");
        }
    }

    public byte[] getContentBytes(CacheID cacheID) {
        byte[] byArray = this.delegate.getContentBytes(cacheID);
        this.checkGetContent(byArray, cacheID);
        return byArray;
    }

    private void checkGetContent(Object object, CacheID cacheID) {
        IssueRecord issueRecord = this.issuedObject2IR.get(object);
        if (issueRecord != null) {
            LOGGER.error(issueRecord.toString());
            throw new IllegalStateException("returned same object twice at getContent");
        }
        issueRecord = new IssueRecord(cacheID, object, ItemState.PERSONALIZED);
        this.issuedObject2IR.put(object, issueRecord);
        this.issuedID2IR.put(cacheID, issueRecord);
        this.inCacheID2IR.remove(cacheID);
        this.inCacheObject2IR.remove(object);
    }

    public byte[] referencePersistentBytes(CacheID cacheID) {
        byte[] byArray = this.delegate.referencePersistentBytes(cacheID);
        this.checkReferencePersistent(byArray, cacheID);
        return byArray;
    }

    private synchronized void checkReferencePersistent(Object object, CacheID cacheID) {
        IssueRecord issueRecord = this.issuedObject2IR.get(object);
        IssueRecord issueRecord2 = this.issuedID2IR.get(cacheID);
        IssueRecord issueRecord3 = this.inCacheObject2IR.get(object);
        IssueRecord issueRecord4 = this.inCacheID2IR.get(cacheID);
        if (issueRecord4 == null && issueRecord3 != null) {
            if (issueRecord3.getReferenceCount() > 0) {
                LOGGER.error("reusing referenced PERSISTENT object {}", (Object)issueRecord3);
                throw new IllegalStateException("reusing referenced PERSISTENT object");
            }
            this.inCacheObject2IR.remove(issueRecord3.getObject());
            this.inCacheID2IR.remove(issueRecord3.getID());
            issueRecord3 = null;
        }
        IssueRecord issueRecord5 = issueRecord4;
        if (issueRecord != null) {
            if (issueRecord2 == null || !issueRecord2.getObject().equals(object)) {
                LOGGER.error("returned different data for PERSISTENT object {}", (Object)issueRecord2);
                throw new IllegalStateException("returned different data for PERSISTENT object");
            }
            if (!issueRecord.getObject().equals(object)) {
                LOGGER.error("returned different data for PERSISTENT object {}", (Object)issueRecord);
                throw new IllegalStateException("returned different data for PERSISTENT object");
            }
            issueRecord.getReference();
        } else {
            if (issueRecord5 == null) {
                issueRecord5 = new IssueRecord(cacheID, object, ItemState.PERSISTENT);
                this.inCacheObject2IR.put(object, issueRecord5);
                this.inCacheID2IR.put(cacheID, issueRecord5);
            }
            this.issuedObject2IR.put(object, issueRecord5);
            this.issuedID2IR.put(cacheID, issueRecord5);
        }
        if (issueRecord3 != null && issueRecord5 != issueRecord3) {
            LOGGER.error("returned reused data for PERSISTENT object {}", (Object)issueRecord3);
            throw new IllegalStateException("returned reused data for PERSISTENT object");
        }
        if (issueRecord != null && issueRecord5 != issueRecord) {
            LOGGER.error("returned reused data for PERSISTENT object {}", (Object)issueRecord);
            throw new IllegalStateException("returned reused data for PERSISTENT object");
        }
        if (issueRecord4 != null && issueRecord5 != issueRecord4) {
            LOGGER.error("returned reused data for PERSISTENT object {}", (Object)issueRecord4);
            throw new IllegalStateException("returned reused data for PERSISTENT object");
        }
        if (issueRecord2 != null && issueRecord5 != issueRecord2) {
            LOGGER.error("returned reused data for PERSISTENT object {}", (Object)issueRecord2);
            throw new IllegalStateException("returned reused data for PERSISTENT object");
        }
        issueRecord5.getReference();
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID) {
        this.putPersistentCheck(byArray, cacheID);
        this.delegate.putContentBytes(byArray, cacheID);
    }

    private void putPersistentCheck(Object object, CacheID cacheID) {
        IssueRecord issueRecord = this.issuedObject2IR.remove(object);
        this.issuedID2IR.remove(cacheID);
        if (issueRecord != null && issueRecord.getType().equals((Object)ItemState.PERSISTENT)) {
            LOGGER.error(issueRecord.toString());
            throw new IllegalStateException("free of PERSISTENT object");
        }
        IssueRecord issueRecord2 = this.inCacheObject2IR.remove(object);
        if (issueRecord2 != null) {
            LOGGER.error(issueRecord2.toString());
            throw new IllegalStateException("free of PERSISTENT object");
        }
        IssueRecord issueRecord3 = this.inCacheID2IR.remove(cacheID);
        if (issueRecord3 != null) {
            LOGGER.warn("multiple PUT of PERSONALIZED content: {}", (Object)issueRecord3);
        }
        IssueRecord issueRecord4 = new IssueRecord(cacheID, object, ItemState.PERSONALIZED);
        this.inCacheID2IR.put(cacheID, issueRecord4);
        this.inCacheObject2IR.put(object, issueRecord4);
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID) {
        this.delegate.addPersistentBytes(byArray, cacheID);
        this.checkAddPersistent(byArray, cacheID);
    }

    private synchronized void checkAddPersistent(Object object, CacheID cacheID) {
        IssueRecord issueRecord = this.issuedID2IR.get(cacheID);
        IssueRecord issueRecord2 = this.inCacheObject2IR.get(object);
        IssueRecord issueRecord3 = this.inCacheID2IR.get(cacheID);
        if (issueRecord2 != null || issueRecord3 != null) {
            LOGGER.error("added PERSISTENT data twice {}", (Object)issueRecord);
            throw new IllegalStateException("added PERSISTENT data twice");
        }
        IssueRecord issueRecord4 = new IssueRecord(cacheID, object, ItemState.PERSISTENT);
        this.inCacheObject2IR.put(object, issueRecord4);
        this.inCacheID2IR.put(cacheID, issueRecord4);
        this.issuedObject2IR.remove(object);
        this.issuedID2IR.remove(cacheID);
    }

    public void releaseReference(CacheID cacheID) {
        this.delegate.releaseReference(cacheID);
        this.checkReleaseReference(cacheID);
    }

    private synchronized void checkReleaseReference(CacheID cacheID) {
        IssueRecord issueRecord = this.issuedID2IR.get(cacheID);
        IssueRecord issueRecord2 = this.inCacheID2IR.get(cacheID);
        if (issueRecord == null || issueRecord2 != issueRecord) {
            LOGGER.error("release PERSISTENT mismatch {}", (Object)issueRecord);
            throw new IllegalStateException("release PERSISTENT mismatch");
        }
        issueRecord.releaseReference();
        if (issueRecord.getReferenceCount() < 0) {
            LOGGER.error("PERSISTENT reference underrun {}", (Object)issueRecord);
            throw new IllegalStateException("PERSISTENT reference underrun");
        }
        if (issueRecord.getReferenceCount() == 0) {
            this.issuedID2IR.remove(cacheID);
            this.issuedObject2IR.remove(issueRecord.getObject());
        }
    }

    public void releaseModifiedReference(CacheID cacheID) {
        this.delegate.releaseModifiedReference(cacheID);
        this.checkReleaseReference(cacheID);
    }

    public void releaseModifiedArrayReference(CacheID cacheID, long[] lArray, long[] lArray2) {
        this.delegate.releaseModifiedArrayReference(cacheID, lArray, lArray2);
        this.checkReleaseReference(cacheID);
    }

    public short[] allocShorts(long l) {
        short[] sArray = this.delegate.allocShorts(l);
        this.allocCheck(sArray);
        return sArray;
    }

    public short[] allocAndClearShorts(long l) {
        short[] sArray = this.delegate.allocAndClearShorts(l);
        this.allocCheck(sArray);
        return sArray;
    }

    public void free(short[] sArray) {
        this.freeCheck(sArray);
        this.delegate.free(sArray);
    }

    public short[] getContentShorts(CacheID cacheID) {
        short[] sArray = this.delegate.getContentShorts(cacheID);
        this.checkGetContent(sArray, cacheID);
        return sArray;
    }

    public short[] referencePersistentShorts(CacheID cacheID) {
        short[] sArray = this.delegate.referencePersistentShorts(cacheID);
        this.checkReferencePersistent(sArray, cacheID);
        return sArray;
    }

    public void putContentShorts(short[] sArray, CacheID cacheID) {
        this.putPersistentCheck(sArray, cacheID);
        this.delegate.putContentShorts(sArray, cacheID);
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID) {
        this.delegate.addPersistentShorts(sArray, cacheID);
        this.checkAddPersistent(sArray, cacheID);
    }

    public int[] allocInts(long l) {
        int[] nArray = this.delegate.allocInts(l);
        this.allocCheck(nArray);
        return nArray;
    }

    public int[] allocAndClearInts(long l) {
        int[] nArray = this.delegate.allocAndClearInts(l);
        this.allocCheck(nArray);
        return nArray;
    }

    public void free(int[] nArray) {
        this.freeCheck(nArray);
        this.delegate.free(nArray);
    }

    public int[] getContentInts(CacheID cacheID) {
        int[] nArray = this.delegate.getContentInts(cacheID);
        this.checkGetContent(nArray, cacheID);
        return nArray;
    }

    public int[] referencePersistentInts(CacheID cacheID) {
        int[] nArray = this.delegate.referencePersistentInts(cacheID);
        this.checkReferencePersistent(nArray, cacheID);
        return nArray;
    }

    public void putContentInts(int[] nArray, CacheID cacheID) {
        this.putPersistentCheck(nArray, cacheID);
        this.delegate.putContentInts(nArray, cacheID);
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID) {
        this.delegate.addPersistentInts(nArray, cacheID);
        this.checkAddPersistent(nArray, cacheID);
    }

    public float[] allocFloats(long l) {
        float[] fArray = this.delegate.allocFloats(l);
        this.allocCheck(fArray);
        return fArray;
    }

    public float[] allocAndClearFloats(long l) {
        float[] fArray = this.delegate.allocAndClearFloats(l);
        this.allocCheck(fArray);
        return fArray;
    }

    public void free(float[] fArray) {
        this.freeCheck(fArray);
        this.delegate.free(fArray);
    }

    public float[] getContentFloats(CacheID cacheID) {
        float[] fArray = this.delegate.getContentFloats(cacheID);
        this.checkGetContent(fArray, cacheID);
        return fArray;
    }

    public float[] referencePersistentFloats(CacheID cacheID) {
        float[] fArray = this.delegate.referencePersistentFloats(cacheID);
        this.checkReferencePersistent(fArray, cacheID);
        return fArray;
    }

    public void putContentFloats(float[] fArray, CacheID cacheID) {
        this.putPersistentCheck(fArray, cacheID);
        this.delegate.putContentFloats(fArray, cacheID);
    }

    public void addPersistentFloats(float[] fArray, CacheID cacheID) {
        this.delegate.addPersistentFloats(fArray, cacheID);
        this.checkAddPersistent(fArray, cacheID);
    }

    public double[] allocDoubles(long l) {
        double[] dArray = this.delegate.allocDoubles(l);
        this.allocCheck(dArray);
        return dArray;
    }

    public double[] allocAndClearDoubles(long l) {
        double[] dArray = this.delegate.allocAndClearDoubles(l);
        this.allocCheck(dArray);
        return dArray;
    }

    public void free(double[] dArray) {
        this.freeCheck(dArray);
        this.delegate.free(dArray);
    }

    public double[] getContentDoubles(CacheID cacheID) {
        double[] dArray = this.delegate.getContentDoubles(cacheID);
        this.checkGetContent(dArray, cacheID);
        return dArray;
    }

    public double[] referencePersistentDoubles(CacheID cacheID) {
        double[] dArray = this.delegate.referencePersistentDoubles(cacheID);
        this.checkReferencePersistent(dArray, cacheID);
        return dArray;
    }

    public void putContentDoubles(double[] dArray, CacheID cacheID) {
        this.putPersistentCheck(dArray, cacheID);
        this.delegate.putContentDoubles(dArray, cacheID);
    }

    public void addPersistentDoubles(double[] dArray, CacheID cacheID) {
        this.delegate.addPersistentDoubles(dArray, cacheID);
        this.checkAddPersistent(dArray, cacheID);
    }

    public Object allocObject(Class<?> clazz, Object[] objectArray) {
        Object object = this.delegate.allocObject(clazz, objectArray);
        this.allocCheck(object);
        return object;
    }

    public Object allocAndClearObject(Class<?> clazz, Object[] objectArray) {
        Object object = this.delegate.allocAndClearObject(clazz, objectArray);
        this.allocCheck(object);
        return object;
    }

    public void free(Object object) {
        this.freeCheck(object);
        this.delegate.free(object);
    }

    public Object getContentObject(CacheID cacheID) {
        Object object = this.delegate.getContentObject(cacheID);
        this.checkGetContent(object, cacheID);
        return object;
    }

    public Object referencePersistentObject(CacheID cacheID, Class<?> clazz) {
        Object object = this.delegate.referencePersistentObject(cacheID, null);
        this.checkReferencePersistent(object, cacheID);
        return object;
    }

    public void putContentObject(Object object, CacheID cacheID) {
        this.putPersistentCheck(object, cacheID);
        this.delegate.putContentObject(object, cacheID);
    }

    public void addPersistentObject(Object object, CacheID cacheID) {
        this.delegate.addPersistentObject(object, cacheID);
        this.checkAddPersistent(object, cacheID);
    }

    public Iterator<ICacheItemGroup> listItemGroups() {
        return this.delegate.listItemGroups();
    }

    public boolean exists(Class<?> clazz, CacheID cacheID) {
        return this.delegate.exists(clazz, cacheID);
    }

    public boolean isInCache(Class<?> clazz, CacheID cacheID) {
        return this.exists(clazz, cacheID);
    }

    public void remove(CacheID cacheID) {
        this.delegate.remove(cacheID);
    }

    public void flush(CacheID cacheID) {
        this.delegate.flush(cacheID);
    }

    public void flushGroup(Class<?> clazz, CacheID cacheID) {
        this.delegate.flushGroup(clazz, cacheID);
    }

    public void ensureFreeMemory(long l) {
        this.delegate.ensureFreeMemory(l);
    }

    public void flushAll() {
        this.delegate.flushAll();
    }

    public boolean isInMemory(CacheID cacheID) {
        return this.delegate.isInMemory(cacheID);
    }

    public void addPersistentObject(Object object, Class<?> clazz, CacheID cacheID) {
        this.delegate.addPersistentObject(object, clazz, cacheID);
        this.checkAddPersistent(object, cacheID);
    }

    public void setItemPriority(CacheID cacheID, int n) {
        this.delegate.setItemPriority(cacheID, n);
    }

    public int getItemPriority(CacheID cacheID) {
        return this.delegate.getItemPriority(cacheID);
    }

    public void putContentBytes(byte[] byArray, CacheID cacheID, int n) {
        this.putPersistentCheck(byArray, cacheID);
        this.delegate.putContentBytes(byArray, cacheID, n);
    }

    public void putContentInts(int[] nArray, CacheID cacheID, int n) {
        this.putPersistentCheck(nArray, cacheID);
        this.delegate.putContentInts(nArray, cacheID, n);
    }

    public void putContentShorts(short[] sArray, CacheID cacheID, int n) {
        this.putPersistentCheck(sArray, cacheID);
        this.delegate.putContentShorts(sArray, cacheID, n);
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID, int n) {
        this.delegate.addPersistentBytes(byArray, cacheID, n);
        this.checkAddPersistent(byArray, cacheID);
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID, int n) {
        this.delegate.addPersistentInts(nArray, cacheID, n);
        this.checkAddPersistent(nArray, cacheID);
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID, int n) {
        this.delegate.addPersistentShorts(sArray, cacheID, n);
        this.checkAddPersistent(sArray, cacheID);
    }

    public byte[] allocBytes(long l, int n) {
        byte[] byArray = this.delegate.allocBytes(l, n);
        this.allocCheck(byArray);
        return byArray;
    }

    public int[] allocInts(long l, int n) {
        int[] nArray = this.delegate.allocInts(l, n);
        this.allocCheck(nArray);
        return nArray;
    }

    public short[] allocShorts(long l, int n) {
        short[] sArray = this.delegate.allocShorts(l, n);
        this.allocCheck(sArray);
        return sArray;
    }

    public long availableMemory(int n) {
        return this.delegate.availableMemory(n);
    }

    public long getFreeMemory() {
        return this.delegate.getFreeMemory();
    }

    public void addPersistentObject(Object object, CacheID cacheID, int n) {
        this.delegate.addPersistentObject(object, cacheID, n);
        this.checkAddPersistent(object, cacheID);
    }

    public boolean isPoolActive(Object object, CacheID cacheID) {
        return this.delegate.isPoolActive(object, cacheID);
    }

    public File getFile(CacheID cacheID, Class<?> clazz) {
        return this.delegate.getFile(cacheID, clazz);
    }

    public String getGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
        return this.delegate.getGroupAttribute(cacheID, clazz, string);
    }

    public void setGroupAttribute(CacheID cacheID, Class<?> clazz, String string, String string2) {
        this.delegate.setGroupAttribute(cacheID, clazz, string, string2);
    }

    public void deleteGroupAttribute(CacheID cacheID, Class<?> clazz, String string) {
        this.delegate.deleteGroupAttribute(cacheID, clazz, string);
    }

    public ICacheItemGroup getItemGroup(String string) {
        return this.delegate.getItemGroup(string);
    }

    public void removeTemporary(GrouplessID grouplessID) {
        this.delegate.removeTemporary(grouplessID);
    }

    private static class IssueRecord {
        private final StackTraceElement[] issueTrace;
        private final CacheID id;
        private final Object object;
        private final ItemState type;
        private int referenceCount;

        public IssueRecord(CacheID cacheID, Object object, ItemState itemState) {
            this.id = cacheID;
            this.object = object;
            this.type = itemState;
            this.issueTrace = Thread.currentThread().getStackTrace();
        }

        public void getReference() {
            ++this.referenceCount;
        }

        public void releaseReference() {
            --this.referenceCount;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }

        public CacheID getID() {
            return this.id;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("object ID:" + this.id + " o:" + this.object + "alloc at:\n");
            stringBuffer.append("type: " + (Object)((Object)this.type) + "\n");
            StackTraceElement[] stackTraceElementArray = this.issueTrace;
            int n = this.issueTrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                stringBuffer.append(stackTraceElement);
                stringBuffer.append("\n");
                ++n2;
            }
            return stringBuffer.toString();
        }

        public ItemState getType() {
            return this.type;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

