/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakIdentityHashMap
extends AbstractMap
implements Map {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Object NULL_KEY = new Object();
    private final ReferenceQueue queue;
    int size;
    private float loadFactor;
    private int threshold;
    int modCount;
    private final WeakEntrySet theEntrySet;
    WeakBucket[] buckets;

    public WeakIdentityHashMap() {
        this(11, 0.75f);
    }

    public WeakIdentityHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakIdentityHashMap(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
        this.theEntrySet = new WeakEntrySet();
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[n];
    }

    public WeakIdentityHashMap(Map map) {
        this(map.size(), 0.75f);
        this.putAll(map);
    }

    private int hash(Object object) {
        return Math.abs(System.identityHashCode(object) % this.buckets.length);
    }

    void cleanQueue() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.internalRemove((WeakBucket)reference);
            reference = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] weakBucketArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new WeakBucket[n];
        int n2 = 0;
        while (n2 < weakBucketArray.length) {
            WeakBucket weakBucket = weakBucketArray[n2];
            while (weakBucket != null) {
                WeakBucket weakBucket2 = weakBucket.next;
                Object t = weakBucket.get();
                if (t == null) {
                    weakBucket.slot = -1;
                    --this.size;
                } else {
                    int n3;
                    weakBucket.slot = n3 = this.hash(t);
                    weakBucket.next = this.buckets[n3];
                    this.buckets[n3] = weakBucket;
                }
                weakBucket = weakBucket2;
            }
            ++n2;
        }
    }

    private WeakBucket.WeakEntry internalGet(Object object) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = this.buckets[n];
        while (weakBucket != null) {
            WeakBucket.WeakEntry weakEntry = weakBucket.getEntry();
            if (weakEntry != null && object == weakEntry.key) {
                return weakEntry;
            }
            weakBucket = weakBucket.next;
        }
        return null;
    }

    private void internalAdd(Object object, Object object2) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = new WeakBucket(object, this.queue, object2, n);
        weakBucket.next = this.buckets[n];
        this.buckets[n] = weakBucket;
        ++this.size;
    }

    void internalRemove(WeakBucket weakBucket) {
        int n = weakBucket.slot;
        if (n == -1) {
            return;
        }
        weakBucket.slot = -1;
        WeakBucket weakBucket2 = null;
        WeakBucket weakBucket3 = this.buckets[n];
        while (weakBucket3 != weakBucket) {
            if (weakBucket3 == null) {
                throw new InternalError("WeakIdentityHashMap in inconsistent state");
            }
            weakBucket2 = weakBucket3;
            weakBucket3 = weakBucket2.next;
        }
        if (weakBucket2 == null) {
            this.buckets[n] = weakBucket.next;
        } else {
            weakBucket2.next = weakBucket.next;
        }
        --this.size;
    }

    @Override
    public int size() {
        this.cleanQueue();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        this.cleanQueue();
        return this.internalGet(object) != null;
    }

    public Object get(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        return weakEntry == null ? null : weakEntry.getValue();
    }

    public Object put(Object object, Object object2) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry != null) {
            return weakEntry.setValue(object2);
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(object, object2);
        return null;
    }

    public Object remove(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry == null) {
            return null;
        }
        ++this.modCount;
        this.internalRemove(weakEntry.getBucket());
        return weakEntry.getValue();
    }

    public Set entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean containsValue(Object object) {
        this.cleanQueue();
        return super.containsValue(object);
    }

    public Set keySet() {
        this.cleanQueue();
        return super.keySet();
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Collection values() {
        this.cleanQueue();
        return super.values();
    }

    private static class WeakBucket
    extends WeakReference {
        Object value;
        WeakBucket next;
        int slot;

        public WeakBucket(Object object, ReferenceQueue referenceQueue, Object object2, int n) {
            super(object, referenceQueue);
            this.value = object2;
            this.slot = n;
        }

        WeakEntry getEntry() {
            Object t = this.get();
            if (t == null) {
                return null;
            }
            return new WeakEntry(t);
        }

        class WeakEntry
        implements Map.Entry {
            Object key;

            public WeakEntry(Object object) {
                this.key = object;
            }

            public WeakBucket getBucket() {
                return WeakBucket.this;
            }

            public Object getKey() {
                return this.key == NULL_KEY ? null : this.key;
            }

            public Object getValue() {
                return WeakBucket.this.value;
            }

            public Object setValue(Object object) {
                Object object2 = WeakBucket.this.value;
                WeakBucket.this.value = object;
                return object2;
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this.key) ^ (WeakBucket.this.value == null ? 0 : WeakBucket.this.value.hashCode());
            }

            @Override
            public boolean equals(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return this.getKey() == entry.getKey() && (WeakBucket.this.value == null ? entry.getValue() == null : WeakBucket.this.value.equals(entry.getValue()));
                }
                return false;
            }

            public String toString() {
                return this.getKey() + "=" + WeakBucket.this.value;
            }
        }
    }

    private final class WeakEntrySet
    extends AbstractSet {
        WeakEntrySet() {
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size;
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                WeakBucket.WeakEntry lastEntry;
                WeakBucket.WeakEntry nextEntry = this.findNext(null);
                int knownMod;
                {
                    this.knownMod = ((WeakEntrySet)WeakEntrySet.this).WeakIdentityHashMap.this.modCount;
                }

                private void checkMod() {
                    WeakIdentityHashMap.this.cleanQueue();
                    if (this.knownMod != ((WeakEntrySet)WeakEntrySet.this).WeakIdentityHashMap.this.modCount) {
                        throw new ConcurrentModificationException(String.valueOf(this.knownMod) + " != " + ((WeakEntrySet)WeakEntrySet.this).WeakIdentityHashMap.this.modCount);
                    }
                }

                private WeakBucket.WeakEntry findNext(WeakBucket.WeakEntry weakEntry) {
                    int n;
                    WeakBucket weakBucket;
                    if (weakEntry != null) {
                        weakBucket = weakEntry.getBucket().next;
                        n = weakEntry.getBucket().slot;
                    } else {
                        weakBucket = ((WeakEntrySet)WeakEntrySet.this).WeakIdentityHashMap.this.buckets[0];
                        n = 0;
                    }
                    while (true) {
                        if (weakBucket != null) {
                            WeakBucket.WeakEntry weakEntry2 = weakBucket.getEntry();
                            if (weakEntry2 != null) {
                                return weakEntry2;
                            }
                            weakBucket = weakBucket.next;
                            continue;
                        }
                        if (++n == ((WeakEntrySet)WeakEntrySet.this).WeakIdentityHashMap.this.buckets.length) {
                            return null;
                        }
                        weakBucket = ((WeakEntrySet)WeakEntrySet.this).WeakIdentityHashMap.this.buckets[n];
                    }
                }

                @Override
                public boolean hasNext() {
                    this.checkMod();
                    return this.nextEntry != null;
                }

                public Object next() {
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                @Override
                public void remove() {
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    ++((WeakEntrySet)WeakEntrySet.this).WeakIdentityHashMap.this.modCount;
                    WeakIdentityHashMap.this.internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    ++this.knownMod;
                }
            };
        }
    }
}

