/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import java.util.ArrayList;
import java.util.List;

public class ImageBoxInfo
implements IImageBoxInfo {
    private IFramePresentationStateSource framePresentationStateSource;
    private IObjectInfo objectInfo;
    private int frameNumber;

    public ImageBoxInfo(IObjectInfo iObjectInfo, int n) {
        this.objectInfo = iObjectInfo;
        this.frameNumber = n;
    }

    @Override
    public IFramePresentationStateSource getFramePresentationStateSource() {
        return this.framePresentationStateSource;
    }

    @Override
    public IObjectInfo getObjectInfo() {
        return this.objectInfo;
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    public void setFramePresentationStateSource(IFramePresentationStateSource iFramePresentationStateSource) {
        this.framePresentationStateSource = iFramePresentationStateSource;
    }

    public static List<IObjectInfo> extractObjectInfos(List<IImageBoxInfo> list, boolean bl) {
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        for (IImageBoxInfo iImageBoxInfo : list) {
            IObjectInfo iObjectInfo;
            if (iImageBoxInfo == null || (iObjectInfo = iImageBoxInfo.getObjectInfo()) == null || bl && arrayList.contains(iObjectInfo)) continue;
            arrayList.add(iObjectInfo);
        }
        return arrayList;
    }

    public int hashCode() {
        return this.objectInfo.getKey().hashCode() ^ this.frameNumber;
    }

    public boolean equals(Object object) {
        if (object instanceof ImageBoxInfo) {
            return ((ImageBoxInfo)object).objectInfo.getKey().equals(this.objectInfo.getKey()) && this.frameNumber == ((ImageBoxInfo)object).frameNumber;
        }
        return false;
    }
}

