/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print;

import com.agfa.pacs.data.shared.data.DicomDataListenerAdapter;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObject;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObjectException;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObjectFactory;
import com.agfa.pacs.listtext.dicomobject.iod.ps.SoftcopyPresentationStateInformationObject;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateSource;
import com.agfa.pacs.listtext.dicomobject.presentation.SoftcopyPresentationStateProvider;
import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import com.agfa.pacs.listtext.lta.print.PrintManager;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public class ImageBoxInfoCreator
extends DicomDataListenerAdapter {
    private static final ALogger log = ALogger.getLogger(ImageBoxInfoCreator.class);
    private Map<String, IFramePresentationStateSource> framePresentationStateSources = new HashMap<String, IFramePresentationStateSource>();

    public List<IImageBoxInfo> createImageBoxInfos(List<IImageBoxInfo> list, boolean bl, boolean bl2) {
        ArrayList<IImageBoxInfo> arrayList = new ArrayList<IImageBoxInfo>();
        for (IImageBoxInfo object2 : list) {
            IObjectInfo iObjectInfo = object2.getObjectInfo();
            if (!UIDUtilities.isType((String)iObjectInfo.getSOPClassUID(), (UIDType)UIDType.Image) && !PrintManager.isSupportedCompositeObject(iObjectInfo)) continue;
            arrayList.add(object2);
        }
        Map<String, IFramePresentationStateSource> map = this.getFramePresentationStateSources();
        for (IImageBoxInfo iImageBoxInfo : arrayList) {
            IFramePresentationStateSource iFramePresentationStateSource;
            String string = iImageBoxInfo.getObjectInfo().getSOPInstanceUID();
            if (!bl || !map.containsKey(string) || (iFramePresentationStateSource = map.get(string)) == null) continue;
            iImageBoxInfo.setFramePresentationStateSource(iFramePresentationStateSource);
        }
        return arrayList;
    }

    public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        try {
            UIDType uIDType = UIDUtilities.getBaseType((String)attributes.getString(524310));
            if (uIDType == UIDType.Presentation) {
                DicomInformationObject dicomInformationObject = DicomInformationObjectFactory.getInstance().createDicomInformationObject(attributes);
                SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject = (SoftcopyPresentationStateInformationObject)dicomInformationObject;
                SoftcopyPresentationStateProvider softcopyPresentationStateProvider = new SoftcopyPresentationStateProvider(softcopyPresentationStateInformationObject);
                for (String string2 : softcopyPresentationStateProvider.getReferencedInstances()) {
                    this.framePresentationStateSources.put(string2, (IFramePresentationStateSource)softcopyPresentationStateProvider);
                }
            }
        }
        catch (DicomInformationObjectException dicomInformationObjectException) {
            log.error("Error on creation dicom io", (Throwable)dicomInformationObjectException);
        }
    }

    private Map<String, IFramePresentationStateSource> getFramePresentationStateSources() {
        return this.framePresentationStateSources;
    }
}

